/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class LOBDB2compatibilityTest
extends BaseJDBCTestCase {
    public LOBDB2compatibilityTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(LOBDB2compatibilityTest.class);
    }

    public void test_LOBDB2compatibility() throws Exception {
        Statement st = this.createStatement();
        st.executeUpdate("create table t1(c11 int)");
        st.executeUpdate("insert into t1 values(1)");
        LOBDB2compatibilityTest.assertStatementError("42818", st, "select c11 from t1 where cast(x'1111' as blob(5))=cast(x'1111' as blob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))=cast(x'1111' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1110' as blob(5))=cast(x'1110' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))=cast(x'11100000' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))=cast(x'1110000000' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where x'11' = cast(x'11' as blob(1))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'11' as blob(1)) = x'11'");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'11' as blob(1)) = cast(x'11' as blob(1))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where '1' = cast('1' as clob(1))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('1' as clob(1)) = '1'");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('1' as clob(1)) = cast('1' as clob(1))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where '1' = cast('1' as nclob(1))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('1' as nclob(1)) = '1'");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('1' as nclob(1)) = cast('1' as nclob(1))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, "select c11 from t1 where cast('1' as nclob(10)) = cast('1' as clob(10))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('1' as clob(10)) = cast('1' as nclob(10))");
        LOBDB2compatibilityTest.assertStatementError("42Y55", st, "drop table b");
        LOBDB2compatibilityTest.assertStatementError("42Y55", st, "drop table c");
        LOBDB2compatibilityTest.assertStatementError("42Y55", st, "drop table n");
        st.executeUpdate("create table b(blob blob(3K))");
        st.executeUpdate("create table c(clob clob(2M))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, "create table n(nclob nclob(1G))");
        st.executeUpdate(" insert into b values(cast(X'0031' as blob(3K)))");
        st.executeUpdate(" insert into c values(cast('2' as clob(2M)))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " insert into n values(cast('3' as nclob(1G)))");
        st.executeUpdate(" insert into b values(cast(X'0031' as blob(3K)))");
        st.executeUpdate(" insert into c values(cast('2' as clob(2M)))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " insert into n values(cast('3' as nclob(1G)))");
        st.executeUpdate(" insert into b values(cast(X'0031' as blob(3K)))");
        st.executeUpdate(" insert into c values(cast('2' as clob(2M)))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " insert into n values(cast('3' as nclob(1G)))");
        ResultSet rs = st.executeQuery("select blob from b");
        Object[][] expRS = new String[][]{{"0031"}, {"0031"}, {"0031"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        rs = st.executeQuery("select clob from c");
        expRS = new String[][]{{"2"}, {"2"}, {"2"}};
        JDBC.assertFullResultSet(rs, expRS, true);
        LOBDB2compatibilityTest.assertStatementError("42X05", st, " select nclob from n");
        LOBDB2compatibilityTest.assertStatementError("42818", st, "select * from b as b1, b as b2 where b1.blob=b2.blob");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where b1.blob!=b2.blob");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where b1.blob=x'0001'");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where x'0001'=b1.blob");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where x'0001'!=b1.blob");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where b1.blob=X'7575'");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select * from b as b1, b as b2 where X'7575'=b1.blob");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c.clob from c where c.clob = '2'");
        LOBDB2compatibilityTest.assertStatementError("42X05", st, " select n.nclob from n where n.nclob = '3'");
        LOBDB2compatibilityTest.assertStatementError("42818", st, "select c11 from t1 where cast(x'1111' as blob(5))=cast(x'1111' as blob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))!=cast(x'1111' as blob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))<cast(x'1111' as blob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))>cast(x'1111' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))<=cast(x'1110' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast(x'1111' as blob(5))>=cast(x'11100000' as blob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))=cast('fish' as clob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))!=cast('fish' as clob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))<cast('fish' as clob(5))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))>cast('fish' as clob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))<=cast('fish' as clob(7))");
        LOBDB2compatibilityTest.assertStatementError("42818", st, " select c11 from t1 where cast('fish' as clob(5))>=cast('fish' as clob(7))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))=cast('fish' as nclob(5))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))!=cast('fish' as nclob(5))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))<cast('fish' as nclob(5))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))>cast('fish' as nclob(7))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))<=cast('fish' as nclob(7))");
        LOBDB2compatibilityTest.assertStatementError("0A000", st, " select c11 from t1 where cast('fish' as nclob(5))>=cast('fish' as nclob(7))");
        LOBDB2compatibilityTest.assertStatementError("42X01", st, "values cast(B'1' as blob(10))");
        this.rollback();
        st.close();
    }
}

