/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import junit.framework.Test;
import org.apache.derbyTesting.junit.ChangeConfigurationSetup;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ServerSetup
extends ChangeConfigurationSetup {
    private final String host;
    private final int port;
    private JDBCClient client;
    private String dbPath;

    public ServerSetup(Test test, String host, int port) {
        super(test);
        this.host = host;
        this.port = port;
    }

    public ServerSetup(Test test, String host, int port, String dbPath) {
        super(test);
        this.host = host;
        this.port = port;
        this.dbPath = dbPath;
    }

    @Override
    TestConfiguration getNewConfiguration(TestConfiguration old) {
        return new TestConfiguration(old, this.client == null ? JDBCClient.DERBYNETCLIENT : this.client, this.host, this.port);
    }

    TestConfiguration getNewConfiguration(TestConfiguration old, String dbPath) {
        return new TestConfiguration(old, this.client == null ? JDBCClient.DERBYNETCLIENT : this.client, this.host, this.port, dbPath);
    }

    void setJDBCClient(JDBCClient newClient) {
        this.client = newClient;
    }

    void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }
}

