/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.util.Enumeration;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SystemPropertyTestSetup
extends TestSetup {
    protected Properties newValues;
    private Properties oldValues;
    private boolean staticProperties;

    public SystemPropertyTestSetup(Test test, Properties newValues, boolean staticProperties) {
        super(test);
        this.newValues = newValues;
        this.staticProperties = staticProperties;
    }

    public SystemPropertyTestSetup(Test test, Properties newValues) {
        super(test);
        this.newValues = newValues;
        this.staticProperties = false;
    }

    public static Test singleProperty(Test test, String property, String value) {
        return SystemPropertyTestSetup.singleProperty(test, property, value, false);
    }

    public static Test singleProperty(Test test, String property, String value, boolean staticProperty) {
        Properties properties = new Properties();
        properties.setProperty(property, value);
        return new SystemPropertyTestSetup(test, properties, staticProperty);
    }

    protected void setUp() throws Exception {
        this.oldValues = new Properties();
        if (this.staticProperties) {
            TestConfiguration.getCurrent().shutdownEngine(false);
        }
        this.setProperties(this.newValues);
    }

    protected void tearDown() throws Exception {
        try {
            if (this.staticProperties) {
                TestConfiguration.getCurrent().shutdownEngine();
            }
        }
        finally {
            this.restoreOldPropertyValues();
            this.oldValues = null;
        }
    }

    private void restoreOldPropertyValues() throws Exception {
        Enumeration<?> e = this.newValues.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (this.oldValues.getProperty(key) != null) continue;
            BaseTestCase.removeSystemProperty(key);
        }
        this.setProperties(this.oldValues);
    }

    private void setProperties(Properties values) {
        Enumeration<?> e = values.propertyNames();
        while (e.hasMoreElements()) {
            boolean change;
            String key = (String)e.nextElement();
            String value = values.getProperty(key);
            String old = BaseTestCase.getSystemProperty(key);
            if (old != null) {
                boolean bl = change = !old.equals(value);
                if (values != this.oldValues) {
                    this.oldValues.setProperty(key, old);
                }
            } else {
                change = true;
            }
            if (!change) continue;
            BaseTestCase.setSystemProperty(key, value);
        }
    }
}

