/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.info;

import java.lang.reflect.Method;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class JVMInfo {
    private static final boolean _isModuleAware;
    public static final int JDK_ID;
    public static final int J2SE_18 = 9;

    public static int jdbcMajorVersion() {
        return 4;
    }

    public static int jdbcMinorVersion() {
        switch (JDK_ID) {
            default: 
        }
        return 2;
    }

    public static String derbyVMLevel() {
        String jdbcVersion = JVMInfo.jdbcMajorVersion() + "." + JVMInfo.jdbcMinorVersion();
        switch (JDK_ID) {
            case 9: {
                return "Java SE 8 - JDBC " + jdbcVersion;
            }
        }
        return "?-?";
    }

    private static String getSystemProperty(String name) {
        return System.getProperty(name);
    }

    public static final boolean isSunJVM() {
        String vendor = JVMInfo.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(vendor) || "Oracle Corporation".equals(vendor);
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(JVMInfo.getSystemProperty("java.vendor"));
    }

    public static final boolean isModuleAware() {
        return _isModuleAware;
    }

    public static final String getSystemModulePath() {
        return JVMInfo.getSystemProperty("jdk.module.path");
    }

    public static void javaDump() {
        if (JVMInfo.isIBMJVM()) {
            Class<?> ibmc = null;
            try {
                ibmc = Class.forName("com.ibm.jvm.Dump");
                Method ibmm = ibmc.getMethod("JavaDump", new Class[0]);
                ibmm.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                SanityManager.THROWASSERT("Failed to execute com.ibm.jvm.Dump.JavaDump in IBM JVM", e);
            }
        }
    }

    public static boolean hasJNDI() {
        try {
            Class.forName("javax.naming.Referenceable");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    static {
        int id;
        String javaVersion = "1.8";
        if ((javaVersion = System.getProperty("java.specification.version", javaVersion)).equals("1.8")) {
            id = 9;
        } else {
            id = 9;
            try {
                String[] ver = javaVersion.split("[.]");
                int major = ver.length >= 1 ? Integer.parseInt(ver[0]) : 0;
                int minor = ver.length >= 2 ? Integer.parseInt(ver[1]) : 0;
                boolean highestMajor = true;
                int highestMinor = 8;
                if (major > 1 || major == 1 && minor >= 8) {
                    id = 9;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        JDK_ID = id;
        _isModuleAware = JVMInfo.getSystemModulePath() != null;
    }
}

