/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public abstract class Restriction
implements Serializable {
    public abstract String toSQL();

    protected String parenthesize(String raw) {
        return "( " + raw + " )";
    }

    public static class ColumnQualifier
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        public static final int ORDER_OP_LESSTHAN = 0;
        public static final int ORDER_OP_EQUALS = 1;
        public static final int ORDER_OP_LESSOREQUALS = 2;
        public static final int ORDER_OP_GREATERTHAN = 3;
        public static final int ORDER_OP_GREATEROREQUALS = 4;
        public static final int ORDER_OP_ISNULL = 5;
        public static final int ORDER_OP_ISNOTNULL = 6;
        public static final int ORDER_OP_NOT_EQUALS = 7;
        private String[] OPERATOR_SYMBOLS = new String[]{"<", "=", "<=", ">", ">=", "IS NULL", "IS NOT NULL", "!="};
        private String _columnName;
        private int _comparisonOperator;
        private Object _constantOperand;

        public ColumnQualifier(String columnName, int comparisonOperator, Object constantOperand) {
            this._columnName = columnName;
            this._comparisonOperator = comparisonOperator;
            this._constantOperand = constantOperand;
        }

        public String getColumnName() {
            return this._columnName;
        }

        public int getComparisonOperator() {
            return this._comparisonOperator;
        }

        public Object getConstantOperand() {
            return this._constantOperand;
        }

        @Override
        public String toSQL() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(IdUtil.normalToDelimited(this._columnName));
            buffer.append(" " + this.OPERATOR_SYMBOLS[this._comparisonOperator] + " ");
            if (this._constantOperand != null) {
                buffer.append(this.toEscapedString(this._constantOperand));
            }
            return buffer.toString();
        }

        protected String toEscapedString(Object o) {
            if (o instanceof Timestamp) {
                return "TIMESTAMP('" + o.toString() + "')";
            }
            if (o instanceof Date) {
                return "DATE('" + o.toString() + "')";
            }
            if (o instanceof Time) {
                return "TIME('" + o.toString() + "')";
            }
            if (o instanceof String) {
                return "'" + o.toString() + "'";
            }
            if (o instanceof byte[]) {
                byte[] b = (byte[])o;
                return "X'" + StringUtil.toHexString(b, 0, b.length) + "'";
            }
            return o.toString();
        }
    }

    public static class OR
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        private Restriction _leftChild;
        private Restriction _rightChild;

        public OR(Restriction leftChild, Restriction rightChild) {
            this._leftChild = leftChild;
            this._rightChild = rightChild;
        }

        public Restriction getLeftChild() {
            return this._leftChild;
        }

        public Restriction getRightChild() {
            return this._rightChild;
        }

        @Override
        public String toSQL() {
            return this.parenthesize(this._leftChild.toSQL()) + " OR " + this.parenthesize(this._rightChild.toSQL());
        }
    }

    public static class AND
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        private Restriction _leftChild;
        private Restriction _rightChild;

        public AND(Restriction leftChild, Restriction rightChild) {
            this._leftChild = leftChild;
            this._rightChild = rightChild;
        }

        public Restriction getLeftChild() {
            return this._leftChild;
        }

        public Restriction getRightChild() {
            return this._rightChild;
        }

        @Override
        public String toSQL() {
            return this.parenthesize(this._leftChild.toSQL()) + " AND " + this.parenthesize(this._rightChild.toSQL());
        }
    }
}

