/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionTest
extends BaseJDBCTestCase {
    public ConnectionTest(String string) {
        super(string);
    }

    public void embeddedCreateBlob() throws SQLException {
        Blob blob = this.getConnection().createBlob();
        if (blob.length() > 0L) {
            ConnectionTest.fail((String)"The new Blob should not have more than zero bytes contained in it");
        }
    }

    public void embeddedCreateClob() throws SQLException {
        Clob clob = this.getConnection().createClob();
        if (clob.length() > 0L) {
            ConnectionTest.fail((String)"The new Clob should not have a length of greater than zero");
        }
    }

    public void testCreateArrayNotImplemented() throws SQLException {
        try {
            this.getConnection().createArrayOf(null, null);
            ConnectionTest.fail((String)"createArrayOf(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateNClobNotImplemented() throws SQLException {
        try {
            this.getConnection().createNClob();
            ConnectionTest.fail((String)"createNClob() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateSQLXMLNotImplemented() throws SQLException {
        try {
            this.getConnection().createSQLXML();
            ConnectionTest.fail((String)"createSQLXML() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateStructNotImplemented() throws SQLException {
        try {
            this.getConnection().createStruct(null, null);
            ConnectionTest.fail((String)"createStruct(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetClientInfo() throws SQLException {
        ConnectionTest.assertTrue((String)"getClientInfo() must return an empty Properties object", (boolean)this.getConnection().getClientInfo().isEmpty());
    }

    public void testGetClientInfoString() throws SQLException {
        ConnectionTest.assertNull((String)"getClientInfo(null) must return null", (Object)this.getConnection().getClientInfo(null));
        ConnectionTest.assertNull((String)"getClientInfo(\"someProperty\") must return null", (Object)this.getConnection().getClientInfo("someProperty"));
    }

    public void testIsValidImplemented() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(0));
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(200));
        try {
            this.getConnection().isValid(-1);
        }
        catch (SQLException sQLException) {
            ConnectionTest.assertSQLState("Incorrect SQL state when calling isValid(-1)", "XJ081", sQLException);
        }
    }

    public void xtestIsValidWithTimeout() throws SQLException {
        if (ConnectionTest.usingEmbedded()) {
            return;
        }
        boolean bl = true;
        Connection connection = this.getConnection();
        bl = connection.isValid(200);
        ConnectionTest.assertTrue((boolean)bl);
        bl = connection.isValid(1);
        ConnectionTest.assertFalse((boolean)bl);
        try {
            connection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetTypeMapReturnsEmptyMap() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().getTypeMap().isEmpty());
    }

    public void testGetTypeMapReturnsAsExpected() throws SQLException {
        int n;
        Statement statement = this.getConnection().createStatement();
        try {
            n = statement.executeUpdate("DROP TABLE T1");
            n = statement.executeUpdate("DROP TYPE JAVA_UTIL_LIST RESTRICT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = statement.executeUpdate("CREATE TYPE JAVA_UTIL_LIST EXTERNAL NAME 'java.util.List'LANGUAGE JAVA");
        statement.execute("CREATE TABLE T1 (A1 JAVA_UTIL_LIST)");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT INTO T1(A1) VALUES (?)");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("First element");
        arrayList.add("Second element");
        preparedStatement.setObject(1, arrayList);
        preparedStatement.execute();
        Map<String, Class<?>> map = this.getConnection().getTypeMap();
        try {
            map.put("JAVA_UTIL_LIST", List.class);
            ConnectionTest.fail((String)"returned map should be immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        HashMap hashMap = new HashMap();
        this.getConnection().setTypeMap(hashMap);
        map = new HashMap();
        map.put("JAVA_UTIL_LIST", List.class);
        try {
            this.getConnection().setTypeMap(map);
            ConnectionTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            ConnectionTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
        ResultSet resultSet = statement.executeQuery("select * from T1");
        ConnectionTest.assertTrue((boolean)resultSet.next());
        for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
            Object object = resultSet.getObject(i);
            ConnectionTest.assertEquals(arrayList, (Object)object);
        }
        statement.executeUpdate("DROP TABLE T1");
        statement.executeUpdate("DROP TYPE JAVA_UTIL_LIST RESTRICT");
        statement.close();
        preparedStatement.close();
    }

    public void testIsWrapperReturnsFalse() throws SQLException {
        ConnectionTest.assertFalse((boolean)this.getConnection().isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperReturnsTrue() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isWrapperFor(Connection.class));
    }

    public void testSetClientInfoProperties() throws SQLException {
        this.getConnection().setClientInfo(null);
        Properties properties = new Properties();
        this.getConnection().setClientInfo(properties);
        properties.setProperty("prop1", "val1");
        properties.setProperty("prop2", "val2");
        try {
            this.getConnection().setClientInfo(properties);
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            ConnectionTest.assertSQLState("SQLStates must match", "XCY02", sQLClientInfoException);
            ConnectionTest.assertTrue((String)"Setting property 'prop1' must fail with REASON_UNKNOWN_PROPERTY", (boolean)sQLClientInfoException.getFailedProperties().get("prop1").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
            ConnectionTest.assertTrue((String)"Setting property 'prop2' must fail with REASON_UNKNOWN_PROPERTY", (boolean)sQLClientInfoException.getFailedProperties().get("prop2").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testSetClientInfoString() throws SQLException {
        this.getConnection().setClientInfo(null, null);
        try {
            this.getConnection().setClientInfo("foo", null);
            ConnectionTest.fail((String)"setClientInfo(String, null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.getConnection().setClientInfo("name", "value");
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            ConnectionTest.assertSQLState("SQLState must match 'unsupported'", "XCY02", sQLClientInfoException);
            ConnectionTest.assertTrue((String)"Setting property 'name' must fail with REASON_UNKNOWN_PROPERTY", (boolean)sQLClientInfoException.getFailedProperties().get("name").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testUnwrapValid() throws SQLException {
        Connection connection = this.getConnection().unwrap(Connection.class);
        ConnectionTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.getConnection(), (Object)connection);
    }

    public void testUnwrapInvalid() throws SQLException {
        try {
            ResultSet resultSet = this.getConnection().unwrap(ResultSet.class);
            ConnectionTest.fail((String)"unwrap should have thrown an exception");
        }
        catch (SQLException sQLException) {
            ConnectionTest.assertSQLState("Incorrect SQL state when unable to unwrap", "XJ128", sQLException);
        }
    }

    private static BaseTestSuite clientSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        return baseTestSuite;
    }

    private static BaseTestSuite embeddedSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest((Test)new ConnectionTest("embeddedCreateBlob"));
        baseTestSuite.addTest((Test)new ConnectionTest("embeddedCreateClob"));
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ConnectionTest suite");
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("ConnectionTest:embedded");
        baseTestSuite2.addTestSuite(ConnectionTest.class);
        baseTestSuite2.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only"));
        baseTestSuite.addTest((Test)baseTestSuite2);
        baseTestSuite2 = new BaseTestSuite("ConnectionTest:embedded XADataSource");
        baseTestSuite2.addTestSuite(ConnectionTest.class);
        baseTestSuite2.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only XADataSource"));
        baseTestSuite.addTest(TestConfiguration.connectionXADecorator((Test)baseTestSuite2));
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("ConnectionTest:client");
        baseTestSuite3.addTestSuite(ConnectionTest.class);
        baseTestSuite3.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite3));
        baseTestSuite3 = new BaseTestSuite("ConnectionTest:client XADataSource");
        baseTestSuite3.addTestSuite(ConnectionTest.class);
        baseTestSuite3.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only XADataSource"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionXADecorator((Test)baseTestSuite3)));
        return baseTestSuite;
    }
}

