/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.Wrapper41DataSource;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AssertEventCatcher;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceTest
extends BaseJDBCTestCase {
    private DataSource ds = null;

    public DataSourceTest(String string) {
        super(string);
    }

    public void setUp() {
        this.ds = JDBCDataSource.getDataSource();
    }

    @Override
    public void tearDown() throws Exception {
        this.ds = null;
        super.tearDown();
    }

    public void testIsWrapperForDataSource() throws SQLException {
        DataSourceTest.assertTrue((boolean)this.ds.isWrapperFor(DataSource.class));
    }

    public void testIsNotWrapperForPoolDataSource() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(ConnectionPoolDataSource.class));
    }

    public void testIsNotWrapperForXADataSource() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(XADataSource.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapDataSource() throws SQLException {
        DataSource dataSource = this.ds.unwrap(DataSource.class);
        DataSourceTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ds, (Object)dataSource);
    }

    public void testUnwrapConnectionPoolDataSource() {
        try {
            ConnectionPoolDataSource connectionPoolDataSource = this.ds.unwrap(ConnectionPoolDataSource.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testUnwrapXADataSource() {
        try {
            XADataSource xADataSource = this.ds.unwrap(XADataSource.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet resultSet = this.ds.unwrap(ResultSet.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("XJ128", sQLException);
        }
    }

    public void testConnectionErrorEvent() throws SQLException, Exception {
        AssertEventCatcher assertEventCatcher = new AssertEventCatcher(12);
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        pooledConnection.addConnectionEventListener(assertEventCatcher);
        Connection connection = pooledConnection.getConnection();
        DataSourceTest.dropTable(connection, "TAB1");
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        if (DataSourceTest.usingEmbedded()) {
            this.getTestConfiguration().shutdownDatabase();
        } else {
            this.getTestConfiguration().stopNetworkServer();
        }
        try {
            connection.createArrayOf("junk", null);
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("0A000", sQLException);
        }
        try {
            connection.createNClob();
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("0A000", sQLException);
        }
        try {
            connection.createSQLXML();
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("0A000", sQLException);
        }
        try {
            connection.createStruct("junk", null);
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("0A000", sQLException);
        }
        try {
            connection.createBlob();
        }
        catch (SQLException sQLException) {
            if (DataSourceTest.usingEmbedded()) {
                DataSourceTest.assertSQLState("08003", sQLException);
            }
            DataSourceTest.assertSQLState("08006", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.createClob();
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getClientInfo();
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.getClientInfo("junk");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setClientInfo(null);
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.setClientInfo("junk1", "junk2");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        try {
            connection.isWrapperFor(((Object)((Object)this)).getClass());
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        }
        assertEventCatcher.resetState();
        try {
            connection.unwrap(((Object)((Object)this)).getClass());
        }
        catch (SQLException sQLException) {
            if (DataSourceTest.usingEmbedded()) {
                DataSourceTest.assertSQLState("08003", sQLException);
            }
            DataSourceTest.assertSQLState("XJ128", sQLException);
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        }
        assertEventCatcher.resetState();
        try {
            connection.isValid(5);
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionClosedEventHappen());
        }
        DataSourceTest.assertFalse((boolean)assertEventCatcher.didConnectionErrorEventHappen());
        assertEventCatcher.resetState();
        if (DataSourceTest.usingEmbedded()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            this.getTestConfiguration().startNetworkServer();
        }
        connection = this.getConnection();
        connection.close();
    }

    public void test_jdbc4_1() throws Exception {
        DataSource dataSource = JDBCDataSource.getDataSource();
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        this.vetDSjdbc4_1(dataSource);
        this.vetDSjdbc4_1(connectionPoolDataSource);
        this.vetDSjdbc4_1(xADataSource);
    }

    private void vetDSjdbc4_1(CommonDataSource commonDataSource) throws Exception {
        DataSourceTest.println("Vetting a " + commonDataSource.getClass().getName());
        Wrapper41DataSource wrapper41DataSource = new Wrapper41DataSource(commonDataSource);
        try {
            wrapper41DataSource.getParentLogger();
            DataSourceTest.fail((String)"Should raise an Unimplemented Feature exception.");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertEquals((String)SQLFeatureNotSupportedException.class.getName(), (String)sQLException.getClass().getName());
        }
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("datasourcetestsuite-embedded");
        baseTestSuite.addTest((Test)new DataSourceTest("testIsNotWrapperForPoolDataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("testIsNotWrapperForXADataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("testUnwrapConnectionPoolDataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("testIsWrapperForDataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("testIsNotWrapperForResultSet"));
        baseTestSuite.addTest((Test)new DataSourceTest("testUnwrapXADataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("testConnectionErrorEvent"));
        baseTestSuite.addTest((Test)new DataSourceTest("testUnwrapResultSet"));
        baseTestSuite.addTest((Test)new DataSourceTest("testUnwrapDataSource"));
        baseTestSuite.addTest((Test)new DataSourceTest("test_jdbc4_1"));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("datasourcetestsuite-net");
        baseTestSuite2.addTest((Test)new DataSourceTest("testIsNotWrapperForPoolDataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testIsNotWrapperForXADataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testUnwrapConnectionPoolDataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testIsWrapperForDataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testIsNotWrapperForResultSet"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testUnwrapXADataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testConnectionErrorEvent"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testUnwrapResultSet"));
        baseTestSuite2.addTest((Test)new DataSourceTest("testUnwrapDataSource"));
        baseTestSuite2.addTest((Test)new DataSourceTest("test_jdbc4_1"));
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("datasourcetest");
        baseTestSuite3.addTest((Test)new CleanDatabaseTestSetup((Test)baseTestSuite));
        baseTestSuite3.addTest(TestConfiguration.clientServerDecorator((Test)new CleanDatabaseTestSetup((Test)baseTestSuite2)));
        return baseTestSuite3;
    }
}

