/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CurrentSchemaTest
extends BaseJDBCTestCase {
    public CurrentSchemaTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("CurrentSchemaTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(CurrentSchemaTest.class));
        return baseTestSuite;
    }

    public void testCurrentSchema() throws Exception {
        Statement statement = this.createStatement();
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema sys");
        this.assertCurrentSchema(statement, "SYS");
        CurrentSchemaTest.assertStatementError("X0Y68", statement, "create schema app");
        statement.executeUpdate("set current schema app");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema = sys");
        this.assertCurrentSchema(statement, "SYS");
        statement.executeUpdate("set current schema = app");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema sys");
        statement.executeUpdate("set schema user");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("create schema judy");
        Connection connection = this.openUserConnection("judy");
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("set schema app");
        this.assertCurrentSchema(statement2, "APP");
        statement2.executeUpdate("set schema user");
        this.assertCurrentSchema(statement2, "JUDY");
        connection.close();
        this.assertCurrentSchema(statement, "APP");
        ResultSet resultSet = statement.executeQuery("values current sqlid");
        Object[][] objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table sqlid(sqlid int)");
        statement.executeUpdate("drop table sqlid");
        statement.executeUpdate("set current sqlid judy");
        this.assertCurrentSchema(statement, "JUDY");
        CurrentSchemaTest.assertStatementError("42X01", statement, "set sqlid judy");
        statement.executeUpdate("set schema sys");
        this.assertCurrentSchema(statement, "SYS");
        statement.executeUpdate("set schema app");
        CurrentSchemaTest.assertStatementError("07000", statement, "set schema ?");
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("set schema ?");
        CurrentSchemaTest.assertStatementError("07000", preparedStatement);
        statement.executeUpdate("create table t1(name varchar(128))");
        statement.executeUpdate("insert into t1 values(null)");
        resultSet = statement.executeQuery("select name from t1");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42815", preparedStatement);
        resultSet = statement.executeQuery("values('notthere')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", preparedStatement);
        resultSet = statement.executeQuery("values('')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", preparedStatement);
        resultSet = statement.executeQuery("values('sys')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", preparedStatement);
        resultSet = statement.executeQuery("values('sys','app')");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        try {
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                preparedStatement.setObject(i, resultSet.getObject(i));
            }
        }
        catch (SQLException sQLException) {
            if (CurrentSchemaTest.usingDerbyNetClient()) {
                CurrentSchemaTest.assertSQLState("XCL14", sQLException);
            }
            CurrentSchemaTest.assertSQLState("XCL13", sQLException);
        }
        resultSet = statement.executeQuery("values('USER')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42Y07", preparedStatement);
        resultSet = statement.executeQuery("values('SYS')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertUpdateCount(preparedStatement, 0);
        this.assertCurrentSchema(statement, "SYS");
        this.rollback();
        this.setAutoCommit(true);
        statement.executeUpdate("set schema app");
        statement.executeUpdate("create table t1 ( a varchar(128))");
        statement.executeUpdate("insert into t1 values (current schema)");
        resultSet = statement.executeQuery("select * from t1");
        String[] stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("set schema judy");
        statement.executeUpdate("insert into app.t1 values (current schema)");
        resultSet = statement.executeQuery("select * from app.t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}, {"JUDY"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CurrentSchemaTest.assertUpdateCount(statement, 1, "delete from app.t1 where a = current schema");
        resultSet = statement.executeQuery("select * from app.t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("set current schema app");
        resultSet = statement.executeQuery("select current schema from t1");
        stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from t1 where a = current schema");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CurrentSchemaTest.assertUpdateCount(statement, 1, "delete from t1");
        statement.executeUpdate("insert into t1 values ('test')");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"test"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        CurrentSchemaTest.assertUpdateCount(statement, 1, "update t1 set a = current schema");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("set schema judy");
        CurrentSchemaTest.assertUpdateCount(statement, 1, "update app.t1 set a = current schema");
        resultSet = statement.executeQuery("select * from app.t1");
        stringArray = new String[]{"A"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"JUDY"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("set schema app");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("set schema APP");
        statement.executeUpdate(" create table t1 ( a int, b varchar(128) default current schema)");
        statement.executeUpdate("insert into t1 (a) values (1)");
        statement.executeUpdate("set schema SYS");
        statement.executeUpdate("insert into app.t1 (a) values (1)");
        statement.executeUpdate("set schema judy");
        statement.executeUpdate("insert into app.t1 (a) values (1)");
        statement.executeUpdate("set schema APP");
        resultSet = statement.executeQuery("select * from t1");
        stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "APP"}, {"1", "SYS"}, {"1", "JUDY"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table t1");
        CurrentSchemaTest.assertStatementError("42Y39", statement, "create table t1 ( a varchar(128), check (a = current schema))");
        CurrentSchemaTest.assertStatementError("42Y39", statement, " create table t1 ( a varchar(128), check (a = current sqlid))");
        statement.executeUpdate("create schema \"MiXCase\"");
        statement.executeUpdate("set schema \"MiXCase\"");
        this.assertCurrentSchema(statement, "MiXCase");
        statement.executeUpdate("set schema app");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema 'MiXCase'");
        this.assertCurrentSchema(statement, "MiXCase");
        CurrentSchemaTest.assertStatementError("42Y07", statement, "set schema 'MIXCASE'");
        CurrentSchemaTest.assertStatementError("42Y07", statement, "set schema mixcase");
        statement.executeUpdate("create schema t23456789012345678901234567890");
        this.assertCurrentSchema(statement, "MiXCase");
        statement.executeUpdate("set schema app");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema t23456789012345678901234567890");
        this.assertCurrentSchema(statement, "T23456789012345678901234567890");
        statement.executeUpdate(" set schema app");
        this.assertCurrentSchema(statement, "APP");
        statement.executeUpdate("set schema 'T23456789012345678901234567890'");
        this.assertCurrentSchema(statement, "T23456789012345678901234567890");
        statement.executeUpdate("set schema app");
        this.assertCurrentSchema(statement, "APP");
        this.setAutoCommit(false);
        preparedStatement = this.prepareStatement("set schema ?");
        resultSet = statement.executeQuery("values('T23456789012345678901234567890')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertUpdateCount(preparedStatement, 0);
        this.assertCurrentSchema(statement, "T23456789012345678901234567890");
        CurrentSchemaTest.assertStatementError("42622", statement, "create schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT");
        CurrentSchemaTest.assertStatementError("42622", statement, " set schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT");
        CurrentSchemaTest.assertStatementError("42622", statement, " set schema 'TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT'");
        resultSet = statement.executeQuery("values('TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT')");
        resultSet.next();
        preparedStatement.setObject(1, resultSet.getObject(1));
        CurrentSchemaTest.assertStatementError("42815", preparedStatement);
        this.rollback();
        this.setAutoCommit(true);
        statement.executeUpdate("drop schema judy restrict");
        CurrentSchemaTest.assertStatementError("42622", statement, " drop schema TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT restrict");
        this.rollback();
        statement.close();
    }

    private void assertCurrentSchema(Statement statement, String string) throws SQLException {
        JDBC.assertFullResultSet(statement.executeQuery("values current schema"), (Object[][])new String[][]{{string}}, true);
    }
}

