/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class DB2IsolationLevelsTest
extends BaseJDBCTestCase {
    public DB2IsolationLevelsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DB2IsolationLevelsTest Test");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(DB2IsolationLevelsTest.class));
        return baseTestSuite;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createStatement().executeUpdate("create table t1(c1 int not null constraint asdf primary key)");
    }

    @Override
    public void tearDown() throws Exception {
        this.createStatement().executeUpdate("drop table t1");
        super.tearDown();
    }

    public void test_DB2IsolationLevelsTest() throws Exception {
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("values current isolation");
        this.setAutoCommit(false);
        statement.executeUpdate("call syscs_util.syscs_set_runtimestatistics(1)");
        statement.executeUpdate("insert into t1 values 1");
        this.assertQueryResult(statement.executeQuery("select * from t1"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        this.assertIsolation(preparedStatement, "CS");
        statement.executeUpdate("set isolation RR");
        this.assertIsolation(preparedStatement, "RR");
        this.rollback();
        this.assertQueryResult(statement.executeQuery("select * from t1"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at serializable isolation level using share table locking chosen by the optimizer");
        statement.executeUpdate("set isolation reset");
        this.assertIsolation(preparedStatement, " ");
        statement.executeUpdate("set isolation read committed");
        this.assertIsolation(preparedStatement, "CS");
        this.rollback();
        this.assertQueryResult(statement.executeQuery("select * from t1"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        statement.executeUpdate("set isolation to reset");
        this.assertIsolation(preparedStatement, " ");
        statement.executeUpdate("set current isolation = RS");
        this.assertIsolation(preparedStatement, "RS");
        this.rollback();
        this.assertQueryResult(statement.executeQuery("select * from t1"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at repeatable read isolation level using share row locking chosen by the optimizer");
        statement.executeUpdate("set isolation reset");
        this.assertIsolation(preparedStatement, " ");
        statement.executeUpdate("set isolation = dirty read");
        this.assertIsolation(preparedStatement, "UR");
        this.rollback();
        this.assertQueryResult(statement.executeQuery("select * from t1"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at read uncommitted isolation level using share row locking chosen by the optimizer");
        statement.executeUpdate("set isolation serializable");
        this.assertIsolation(preparedStatement, "RR");
        this.assertQueryResult(statement.executeQuery("select * from t1 with CS"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at read committed isolation level using instantaneous share row locking chosen by the optimizer");
        statement.executeUpdate("set isolation cursor stability");
        this.assertIsolation(preparedStatement, "CS");
        this.assertQueryResult(statement.executeQuery("select * from t1 with RR"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at serializable isolation level using share table locking chosen by the optimizer");
        statement.executeUpdate("set isolation serializable");
        this.assertIsolation(preparedStatement, "RR");
        this.assertQueryResult(statement.executeQuery("select * from t1 with RS"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at repeatable read isolation level using share row locking chosen by the optimizer");
        statement.executeUpdate("set current isolation to read committed");
        this.assertIsolation(preparedStatement, "CS");
        this.assertQueryResult(statement.executeQuery("select * from t1 with ur"));
        this.assertPlan(statement, "Index Scan ResultSet for T1 using constraint ASDF at read uncommitted isolation level using share row locking chosen by the optimizer");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with rw");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with dirty read");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with read uncommitted");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with read committed");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with cursor stability");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with repeatable read");
        DB2IsolationLevelsTest.assertStatementError("42X01", statement, "select * from t1 with serializable");
        statement.executeUpdate("create table db2iso(cs int, rr int, ur int, rs int)");
        ResultSet resultSet = statement.executeQuery("select cs, rr, ur, rs from db2iso");
        JDBC.assertEmpty(resultSet);
        this.rollback();
    }

    private void assertQueryResult(ResultSet resultSet) throws SQLException {
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1"}}, true);
        resultSet.close();
    }

    private void assertPlan(Statement statement, String string) throws SQLException {
        SQLUtilities.getRuntimeStatisticsParser(statement).assertSequence(new String[]{string});
    }

    private void assertIsolation(PreparedStatement preparedStatement, String string) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{string}}, true);
        resultSet.close();
    }
}

