/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ForBitDataTest
extends BaseJDBCTestCase {
    private static String[] TABLES = new String[]{"CREATE TABLE FBDOK.T001 (C001 CHAR FOR BIT DATA)", "CREATE TABLE FBDOK.T002 (C002 CHAR(1) FOR BIT DATA)", "CREATE TABLE FBDOK.T003 (C003 CHAR(10) FOR BIT DATA)", "CREATE TABLE FBDOK.T004 (C004 CHAR(254) FOR BIT DATA)", "CREATE TABLE FBDOK.T005 (C005 VARCHAR(1) FOR BIT DATA)", "CREATE TABLE FBDOK.T006 (C006 VARCHAR(100) FOR BIT DATA)", "CREATE TABLE FBDOK.T007 (C007 VARCHAR(32672) FOR BIT DATA)", "CREATE TABLE FBDOK.T008 (C008 LONG VARCHAR FOR BIT DATA)", "CREATE TABLE FBDVAL.T001(ID INT NOT NULL PRIMARY KEY, C1 CHAR(10) FOR BIT DATA, C2 VARCHAR(10) FOR BIT DATA, C3 LONG VARCHAR FOR BIT DATA, C4 BLOB(10))", "CREATE TABLE FBDVAL.X001(XID INT NOT NULL PRIMARY KEY, X1 CHAR(12) FOR BIT DATA, C2 VARCHAR(12) FOR BIT DATA, C3 LONG VARCHAR FOR BIT DATA, C4 BLOB(12))", "CREATE TABLE FBDVAL.T002(ID INT NOT NULL PRIMARY KEY, C1 CHAR(10) FOR BIT DATA, C2 VARCHAR(10) FOR BIT DATA, C3 LONG VARCHAR FOR BIT DATA, C4 BLOB(10))", "CREATE TABLE FBDVAL.TEL(C2 VARCHAR(32672) FOR BIT DATA, C3 LONG VARCHAR FOR BIT DATA, C4 BLOB(128k))"};
    public static String[] testTypesExpectedValues = new String[]{"FBDOK,T001,C001,-2,CHAR () FOR BIT DATA,1,null,null,1,null,null,1,YES", "FBDOK,T002,C002,-2,CHAR () FOR BIT DATA,1,null,null,1,null,null,1,YES", "FBDOK,T003,C003,-2,CHAR () FOR BIT DATA,10,null,null,1,null,null,1,YES", "FBDOK,T004,C004,-2,CHAR () FOR BIT DATA,254,null,null,1,null,null,1,YES", "FBDOK,T005,C005,-3,VARCHAR () FOR BIT DATA,1,null,null,1,null,null,1,YES", "FBDOK,T006,C006,-3,VARCHAR () FOR BIT DATA,100,null,null,1,null,null,1,YES", "FBDOK,T007,C007,-3,VARCHAR () FOR BIT DATA,32672,null,null,1,null,null,1,YES", "FBDOK,T008,C008,-4,LONG VARCHAR FOR BIT DATA,32700,null,null,1,null,null,1,YES"};
    public static String[] testTypesExpectedValuesEmbedded = new String[]{"C001 CHAR () FOR BIT DATA precision 1", "C002 CHAR () FOR BIT DATA precision 1", "C003 CHAR () FOR BIT DATA precision 10", "C004 CHAR () FOR BIT DATA precision 254", "C005 VARCHAR () FOR BIT DATA precision 1", "C006 VARCHAR () FOR BIT DATA precision 100", "C007 VARCHAR () FOR BIT DATA precision 32672", "C008 LONG VARCHAR FOR BIT DATA precision 32700"};
    public static String[] testTypesExpectedValuesNetworkServer = new String[]{"C001 CHAR FOR BIT DATA precision 1", "C002 CHAR FOR BIT DATA precision 1", "C003 CHAR FOR BIT DATA precision 10", "C004 CHAR FOR BIT DATA precision 254", "C005 VARCHAR FOR BIT DATA precision 1", "C006 VARCHAR FOR BIT DATA precision 100", "C007 VARCHAR FOR BIT DATA precision 32672", "C008 LONG VARCHAR FOR BIT DATA precision 32700"};
    public static String[] testTypesExpectedValues3 = new String[]{"LONG VARCHAR FOR BIT DATA(-4) precision 32700", "VARCHAR () FOR BIT DATA(-3) precision 32672", "CHAR () FOR BIT DATA(-2) precision 254"};
    public static String[][] testCompareExpectedValues = new String[][]{{"30 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   50 0423a2ff202020202020 (10) ", "60 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "40 0423a1fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   30 0423a2fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   60 0423a2fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) "}, {"30 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "40 0423a1fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "30 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "40 0423a1fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   50 0423a2ff202020202020 (10) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   50 0423a2ff202020202020 (10) ", "60 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   30 0423a2fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   60 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) "}, {"30 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "30 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "40 0423a1fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   30 0423a2fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   40 0423a1fd202020202020 (10) ", "50 0423a2ff202020202020 (10)   50 0423a2ff202020202020 (10) ", "50 0423a2ff202020202020 (10)   60 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   30 0423a2fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   40 0423a1fd202020202020 (10) ", "60 0423a2fd202020202020 (10)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "30 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "40 0423a1fd202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   50 0423a2ff (4) ", "60 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "60 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "30 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd (4) ", "40 0423a1fd202020202020 (10)   50 0423a2ff (4) ", "40 0423a1fd202020202020 (10)   60 0423a2fd20 (5) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   30 0423a2fd (4) ", "50 0423a2ff202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   60 0423a2fd20 (5) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "60 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) "}, {"30 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd (4) ", "40 0423a1fd202020202020 (10)   50 0423a2ff (4) ", "40 0423a1fd202020202020 (10)   60 0423a2fd20 (5) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "30 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "30 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "30 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd202020202020 (10)   30 0423a2fd (4) ", "40 0423a1fd202020202020 (10)   40 0423a1fd (4) ", "40 0423a1fd202020202020 (10)   50 0423a2ff (4) ", "40 0423a1fd202020202020 (10)   60 0423a2fd20 (5) ", "40 0423a1fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff202020202020 (10)   50 0423a2ff (4) ", "50 0423a2ff202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "60 0423a2fd202020202020 (10)   50 0423a2ff (4) ", "60 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "60 0423a2fd202020202020 (10)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   30 0423a2fd (4) ", "50 0423a2ff202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   60 0423a2fd20 (5) ", "60 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) "}, {"30 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "30 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "30 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "40 0423a1fd202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   30 0423a2fd (4) ", "50 0423a2ff202020202020 (10)   40 0423a1fd (4) ", "50 0423a2ff202020202020 (10)   50 0423a2ff (4) ", "50 0423a2ff202020202020 (10)   60 0423a2fd20 (5) ", "60 0423a2fd202020202020 (10)   30 0423a2fd (4) ", "60 0423a2fd202020202020 (10)   40 0423a1fd (4) ", "60 0423a2fd202020202020 (10)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C3"}, {"42818 types not comparable C1 ... C4"}, {"42818 types not comparable C1 ... C4"}, {"42818 types not comparable C1 ... C4"}, {"42818 types not comparable C1 ... C4"}, {"42818 types not comparable C1 ... C4"}, {"42818 types not comparable C1 ... C4"}, {"30 0423a2fd (4)   30 0423a2fd202020202020 (10) ", "30 0423a2fd (4)   60 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   50 0423a2ff202020202020 (10) ", "60 0423a2fd20 (5)   30 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   40 0423a1fd202020202020 (10) ", "30 0423a2fd (4)   50 0423a2ff202020202020 (10) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   50 0423a2ff202020202020 (10) ", "40 0423a1fd (4)   60 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   30 0423a2fd202020202020 (10) ", "50 0423a2ff (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   60 0423a2fd202020202020 (10) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   40 0423a1fd202020202020 (10) ", "60 0423a2fd20 (5)   50 0423a2ff202020202020 (10) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) "}, {"30 0423a2fd (4)   50 0423a2ff202020202020 (10) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   50 0423a2ff202020202020 (10) ", "40 0423a1fd (4)   60 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   50 0423a2ff202020202020 (10) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   30 0423a2fd202020202020 (10) ", "30 0423a2fd (4)   50 0423a2ff202020202020 (10) ", "30 0423a2fd (4)   60 0423a2fd202020202020 (10) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   40 0423a1fd202020202020 (10) ", "40 0423a1fd (4)   50 0423a2ff202020202020 (10) ", "40 0423a1fd (4)   60 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   50 0423a2ff202020202020 (10) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   30 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   50 0423a2ff202020202020 (10) ", "60 0423a2fd20 (5)   60 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   30 0423a2fd202020202020 (10) ", "50 0423a2ff (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   60 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) "}, {"30 0423a2fd (4)   30 0423a2fd202020202020 (10) ", "30 0423a2fd (4)   40 0423a1fd202020202020 (10) ", "30 0423a2fd (4)   60 0423a2fd202020202020 (10) ", "40 0423a1fd (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   30 0423a2fd202020202020 (10) ", "50 0423a2ff (4)   40 0423a1fd202020202020 (10) ", "50 0423a2ff (4)   50 0423a2ff202020202020 (10) ", "50 0423a2ff (4)   60 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   30 0423a2fd202020202020 (10) ", "60 0423a2fd20 (5)   40 0423a1fd202020202020 (10) ", "60 0423a2fd20 (5)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd202020202020 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   30 0423a2fd (4) ", "30 0423a2fd (4)   60 0423a2fd20 (5) ", "40 0423a1fd (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   50 0423a2ff (4) ", "60 0423a2fd20 (5)   30 0423a2fd (4) ", "60 0423a2fd20 (5)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   40 0423a1fd (4) ", "30 0423a2fd (4)   50 0423a2ff (4) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd (4) ", "40 0423a1fd (4)   50 0423a2ff (4) ", "40 0423a1fd (4)   60 0423a2fd20 (5) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   30 0423a2fd (4) ", "50 0423a2ff (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   60 0423a2fd20 (5) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   40 0423a1fd (4) ", "60 0423a2fd20 (5)   50 0423a2ff (4) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) "}, {"30 0423a2fd (4)   50 0423a2ff (4) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd (4) ", "40 0423a1fd (4)   50 0423a2ff (4) ", "40 0423a1fd (4)   60 0423a2fd20 (5) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   50 0423a2ff (4) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   30 0423a2fd (4) ", "30 0423a2fd (4)   50 0423a2ff (4) ", "30 0423a2fd (4)   60 0423a2fd20 (5) ", "30 0423a2fd (4)   70 0b27a2fd016de2356690 (10) ", "40 0423a1fd (4)   30 0423a2fd (4) ", "40 0423a1fd (4)   40 0423a1fd (4) ", "40 0423a1fd (4)   50 0423a2ff (4) ", "40 0423a1fd (4)   60 0423a2fd20 (5) ", "40 0423a1fd (4)   70 0b27a2fd016de2356690 (10) ", "50 0423a2ff (4)   50 0423a2ff (4) ", "50 0423a2ff (4)   70 0b27a2fd016de2356690 (10) ", "60 0423a2fd20 (5)   30 0423a2fd (4) ", "60 0423a2fd20 (5)   50 0423a2ff (4) ", "60 0423a2fd20 (5)   60 0423a2fd20 (5) ", "60 0423a2fd20 (5)   70 0b27a2fd016de2356690 (10) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"30 0423a2fd (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   30 0423a2fd (4) ", "50 0423a2ff (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   60 0423a2fd20 (5) ", "60 0423a2fd20 (5)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) "}, {"30 0423a2fd (4)   30 0423a2fd (4) ", "30 0423a2fd (4)   40 0423a1fd (4) ", "30 0423a2fd (4)   60 0423a2fd20 (5) ", "40 0423a1fd (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   30 0423a2fd (4) ", "50 0423a2ff (4)   40 0423a1fd (4) ", "50 0423a2ff (4)   50 0423a2ff (4) ", "50 0423a2ff (4)   60 0423a2fd20 (5) ", "60 0423a2fd20 (5)   30 0423a2fd (4) ", "60 0423a2fd20 (5)   40 0423a1fd (4) ", "60 0423a2fd20 (5)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   30 0423a2fd (4) ", "70 0b27a2fd016de2356690 (10)   40 0423a1fd (4) ", "70 0b27a2fd016de2356690 (10)   50 0423a2ff (4) ", "70 0b27a2fd016de2356690 (10)   60 0423a2fd20 (5) ", "70 0b27a2fd016de2356690 (10)   70 0b27a2fd016de2356690 (10) "}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C3"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C2 ... C4"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C1"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C2"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C3"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C3 ... C4"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C1"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C2"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C3"}, {"42818 types not comparable C4 ... C4"}, {"42818 types not comparable C4 ... C4"}, {"42818 types not comparable C4 ... C4"}, {"42818 types not comparable C4 ... C4"}, {"42818 types not comparable C4 ... C4"}, {"42818 types not comparable C4 ... C4"}};
    public static String[] testEncodedLengthsExpectedValues = new String[]{"C1 OK DATA OK C2 OK DATA OK C3 OK DATA OK", "C1 NULL C2 OK DATA OK C3 OK DATA OK", "C1 NULL C2 NULL C3 OK DATA OK"};

    public ForBitDataTest(String string) {
        super(string);
    }

    public void testNegative() throws SQLException {
        this.assertCompileError("42611", "CREATE TABLE FBDFAIL.T001 (C001 CHAR(255) FOR BIT DATA)");
        this.assertCompileError("42611", "CREATE TABLE FBDFAIL.T001 (C001 CHAR(255) FOR BIT DATA)");
        this.assertCompileError("42611", "CREATE TABLE FBDFAIL.T002 (C002 VARCHAR(32673) FOR BIT DATA)");
        this.assertCompileError("42X01", "CREATE TABLE FBDFAIL.T003 (C003 VARCHAR FOR BIT DATA)");
        this.assertCompileError("42X01", "CREATE TABLE FBDFAIL.T004 (C004 LONG VARCHAR(100) FOR BIT DATA)");
    }

    public void testTypes() throws SQLException {
        String string;
        Wrapper wrapper;
        Connection connection = this.getConnection();
        ResultSet resultSet = connection.getMetaData().getColumns(null, "FBDOK", null, null);
        String string2 = null;
        int n = 0;
        while (resultSet.next()) {
            string2 = resultSet.getString(2) + ",";
            string2 = string2 + resultSet.getString(3) + ",";
            string2 = string2 + resultSet.getString(4) + ",";
            string2 = string2 + resultSet.getString(5) + ",";
            string2 = string2 + resultSet.getString(6) + ",";
            string2 = string2 + resultSet.getString(7) + ",";
            string2 = string2 + resultSet.getString(9) + ",";
            string2 = string2 + resultSet.getString(10) + ",";
            string2 = string2 + resultSet.getString(11) + ",";
            string2 = string2 + resultSet.getString(13) + ",";
            string2 = string2 + resultSet.getString(16) + ",";
            string2 = string2 + resultSet.getString(17) + ",";
            string2 = string2 + resultSet.getString(18);
            ForBitDataTest.assertEquals((String)testTypesExpectedValues[n], (String)string2);
            ++n;
        }
        resultSet.close();
        for (n = 1; n <= 8; ++n) {
            wrapper = this.prepareStatement("SELECT * FROM FBDOK.T00" + n);
            ResultSetMetaData resultSetMetaData = wrapper.getMetaData();
            string2 = resultSetMetaData.getColumnName(1) + " " + resultSetMetaData.getColumnTypeName(1) + " precision " + resultSetMetaData.getPrecision(1);
            if (ForBitDataTest.usingDerbyNetClient()) {
                ForBitDataTest.assertEquals((String)testTypesExpectedValuesNetworkServer[n - 1], (String)string2);
            } else {
                ForBitDataTest.assertEquals((String)testTypesExpectedValuesEmbedded[n - 1], (String)string2);
            }
            wrapper.close();
        }
        wrapper = connection.getMetaData();
        resultSet = wrapper.getTypeInfo();
        int n2 = 0;
        block5: while (resultSet.next()) {
            string = resultSet.getString(1);
            int n3 = resultSet.getInt(2);
            switch (n3) {
                case -4: 
                case -3: 
                case -2: {
                    break;
                }
                default: {
                    continue block5;
                }
            }
            string2 = string + "(" + n3 + ") precision " + resultSet.getInt(3);
            ForBitDataTest.assertEquals((String)testTypesExpectedValues3[n2], (String)string2);
            ++n2;
        }
        resultSet.close();
        string = "VALUES X'2345d45a2e44'";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        string2 = resultSetMetaData.getColumnName(1) + " " + resultSetMetaData.getColumnTypeName(1) + " precision " + resultSetMetaData.getPrecision(1);
        if (ForBitDataTest.usingDerbyNetClient()) {
            ForBitDataTest.assertEquals((String)"1 CHAR FOR BIT DATA precision 6", (String)string2);
        } else {
            ForBitDataTest.assertEquals((String)"1 CHAR () FOR BIT DATA precision 6", (String)string2);
        }
        string = "VALUES X''";
        preparedStatement = this.prepareStatement(string);
        resultSetMetaData = preparedStatement.getMetaData();
        string2 = resultSetMetaData.getColumnName(1) + " " + resultSetMetaData.getColumnTypeName(1) + " precision " + resultSetMetaData.getPrecision(1);
        if (ForBitDataTest.usingDerbyNetClient()) {
            ForBitDataTest.assertEquals((String)"1 CHAR FOR BIT DATA precision 0", (String)string2);
        } else {
            ForBitDataTest.assertEquals((String)"1 CHAR () FOR BIT DATA precision 0", (String)string2);
        }
    }

    public void testValues() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from FBDVAL.T001");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO FBDVAL.T001 VALUES(?, ?, ?, ?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT C1, C2, C3, C4, ID FROM FBDVAL.T001 WHERE ID >= ? AND ID < ? ORDER BY ID");
        this.insertData(preparedStatement, 0, null, 10, true);
        this.showData(preparedStatement2, 0, null, "ORG <NULL> CHR <NULL> VAR <NULL> LVC <NULL> BLOB <NULL> ");
        byte[] byArray = new byte[7];
        this.insertData(preparedStatement, 10, byArray, 10, true);
        this.showData(preparedStatement2, 10, byArray, "ORG 00000000000000 (7) CHR 00000000000000202020 (10) VAR 00000000000000 (7) LVC 00000000000000 (7) BLOB 00000000000000 (7) ");
        byte[] byArray2 = new byte[15];
        this.insertData(preparedStatement, 20, byArray2, 10, true);
        this.showData(preparedStatement2, 20, byArray2, "ORG 000000000000000000000000000000 (15) CHR <NULL> VAR <NULL> LVC 000000000000000000000000000000 (15) BLOB <NULL> ");
        byte[] byArray3 = new byte[]{4, 35, -94, -3};
        this.insertData(preparedStatement, 30, byArray3, 10, true);
        this.showData(preparedStatement2, 30, byArray3, "ORG 0423a2fd (4) CHR 0423a2fd202020202020 (10) VAR 0423a2fd (4) LVC 0423a2fd (4) BLOB 0423a2fd (4) ");
        byte[] byArray4 = new byte[]{11, 39, -94, -3, 1, 109, -30, 53, 102, -112};
        this.insertData(preparedStatement, 40, byArray4, 10, true);
        this.showData(preparedStatement2, 40, byArray4, "ORG 0b27a2fd016de2356690 (10) CHR 0b27a2fd016de2356690 (10) VAR 0b27a2fd016de2356690 (10) LVC 0b27a2fd016de2356690 (10) BLOB 0b27a2fd016de2356690 (10) ");
        byte[] byArray5 = new byte[]{-21, -54, -2, -70, -66, -2, -19, -6, -50, 36, 120, 67, -110, 49, 109};
        this.insertData(preparedStatement, 50, byArray5, 10, true);
        this.showData(preparedStatement2, 50, byArray5, "ORG ebcafebabefeedface24784392316d (15) CHR <NULL> VAR <NULL> LVC ebcafebabefeedface24784392316d (15) BLOB <NULL> ");
        byte[] byArray6 = new byte[]{32, 32, 32, 32};
        this.insertData(preparedStatement, 60, byArray6, 10, true);
        this.showData(preparedStatement2, 60, byArray6, "ORG 20202020 (4) CHR 20202020202020202020 (10) VAR 20202020 (4) LVC 20202020 (4) BLOB 20202020 (4) ");
        byte[] byArray7 = new byte[]{-54, -2, 32, 32, 32, 32};
        this.insertData(preparedStatement, 70, byArray7, 10, true);
        this.showData(preparedStatement2, 70, byArray7, "ORG cafe20202020 (6) CHR cafe2020202020202020 (10) VAR cafe20202020 (6) LVC cafe20202020 (6) BLOB cafe20202020 (6) ");
        byte[] byArray8 = new byte[]{-54, -2, 32, 32, 32, 32, -54, -2, 32, 32, 32, 32};
        this.insertData(preparedStatement, 210, byArray8, 10, true);
        this.showData(preparedStatement2, 210, byArray8, "ORG cafe20202020cafe20202020 (12) CHR <NULL> VAR <NULL> LVC cafe20202020cafe20202020 (12) BLOB <NULL> ");
        preparedStatement.close();
        Statement statement2 = this.createStatement();
        String string = "INSERT INTO FBDVAL.T001 VALUES(80, X'2020202020', X'2020202020', X'2020202020', null)";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 80, byArray6, "ORG 20202020 (4) CHR 20202020202020202020 (10) VAR 2020202020 (5) LVC 2020202020 (5) BLOB <NULL> ");
        string = "INSERT INTO FBDVAL.T001 VALUES(90, X'CAFE20202020CAFE20202020', null, null, null)";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 90, byArray8, "ORG cafe20202020cafe20202020 (12) CHR cafe20202020cafe2020 (10) VAR <NULL> LVC <NULL> BLOB <NULL> ");
        string = "INSERT INTO FBDVAL.T001 VALUES(100, null, X'CAFE20202020CAFE20202020', null, null)";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 100, byArray8, "ORG cafe20202020cafe20202020 (12) CHR <NULL> VAR cafe20202020cafe2020 (10) LVC <NULL> BLOB <NULL> ");
        string = "INSERT INTO FBDVAL.T001 VALUES(110, null, null, X'CAFE20202020CAFE20202020', null)";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 110, byArray8, "ORG cafe20202020cafe20202020 (12) CHR <NULL> VAR <NULL> LVC cafe20202020cafe20202020 (12) BLOB <NULL> ");
        string = "INSERT INTO FBDVAL.T001 VALUES(120, X'CAFE20202020CAFE20202020DD', null, null, null)";
        try {
            statement2.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        string = "INSERT INTO FBDVAL.T001 VALUES(130, null, X'CAFE20202020CAFE20202020DD', null, null)";
        try {
            statement2.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        string = "INSERT INTO FBDVAL.T001 VALUES(140, null, null, X'CAFE20202020CAFE20202020DD', null)";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 140, byArray8, "ORG cafe20202020cafe20202020 (12) CHR <NULL> VAR <NULL> LVC cafe20202020cafe20202020dd (13) BLOB <NULL> ");
        string = "INSERT INTO FBDVAL.X001 VALUES(200, X'CAFE20202020CAFE20202020', null, null, null)";
        statement2.executeUpdate(string);
        string = "INSERT INTO FBDVAL.T001 SELECT * FROM FBDVAL.X001";
        statement2.executeUpdate(string);
        this.showData(preparedStatement2, 200, byArray8, "ORG cafe20202020cafe20202020 (12) CHR cafe20202020cafe2020 (10) VAR <NULL> LVC <NULL> BLOB <NULL> ");
        preparedStatement2.close();
        statement2.close();
    }

    public void testCompare() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("delete from FBDVAL.T001");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO FBDVAL.T001 VALUES(?, ?, ?, ?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("INSERT INTO FBDVAL.T002 VALUES(?, ?, ?, ?, ?)");
        this.insertData(preparedStatement, 0, null, 10, false);
        this.insertData(preparedStatement2, 0, null, 10, false);
        byte[] byArray = new byte[]{4, 35, -94, -3};
        this.insertData(preparedStatement, 30, byArray, 10, false);
        this.insertData(preparedStatement2, 30, byArray, 10, false);
        byArray[2] = -95;
        this.insertData(preparedStatement, 40, byArray, 10, false);
        this.insertData(preparedStatement2, 40, byArray, 10, false);
        byArray[2] = -94;
        byArray[3] = -1;
        this.insertData(preparedStatement, 50, byArray, 10, false);
        this.insertData(preparedStatement2, 50, byArray, 10, false);
        byte[] byArray2 = new byte[]{4, 35, -94, -3, 32};
        this.insertData(preparedStatement, 60, byArray2, 10, false);
        this.insertData(preparedStatement2, 60, byArray2, 10, false);
        byte[] byArray3 = new byte[]{11, 39, -94, -3, 1, 109, -30, 53, 102, -112};
        this.insertData(preparedStatement, 70, byArray3, 10, false);
        this.insertData(preparedStatement2, 70, byArray3, 10, false);
        String[] stringArray = new String[]{"C1", "C2", "C3", "C4"};
        String[] stringArray2 = new String[]{"=", "<>", "<", "<=", ">", ">="};
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                for (int k = 0; k < stringArray2.length; ++k) {
                    String string = "SELECT T.ID, T." + stringArray[i] + ", O.ID, O." + stringArray[j] + " FROM FBDVAL.T001 O, FBDVAL.T002 T WHERE T." + stringArray[i] + " " + stringArray2[k] + " O." + stringArray[j] + " ORDER BY 1,3";
                    try {
                        PreparedStatement preparedStatement3 = this.prepareStatement(string);
                        this.showCompareData(preparedStatement3, testCompareExpectedValues[n]);
                    }
                    catch (SQLException sQLException) {
                        ForBitDataTest.assertSQLState("42818", sQLException);
                    }
                    ++n;
                }
            }
        }
        statement.close();
    }

    public void testEncodedLengths() throws SQLException, IOException {
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO FBDVAL.TEL VALUES(?, ?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("SELECT * FROM FBDVAL.TEL");
        PreparedStatement preparedStatement3 = this.prepareStatement("DELETE FROM FBDVAL.TEL");
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 10, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 30, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 31, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 32, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 1345, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 23456, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 32672, testEncodedLengthsExpectedValues[0]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 32700, testEncodedLengthsExpectedValues[1]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, Short.MAX_VALUE, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 32768, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 32769, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 65535, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 65536, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 65537, testEncodedLengthsExpectedValues[2]);
        this.insertEL(preparedStatement, preparedStatement2, preparedStatement3, 115882, testEncodedLengthsExpectedValues[2]);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ForBitTestData");
        baseTestSuite.addTest(ForBitDataTest.baseSuite("ForBitTestData:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ForBitDataTest.baseSuite("ForBitTestData:client")));
        return baseTestSuite;
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(ForBitDataTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                for (int i = 0; i < TABLES.length; ++i) {
                    statement.execute(TABLES[i]);
                }
            }
        };
    }

    private void insertEL(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, int n, String string) throws SQLException, IOException {
        byte[] byArray = new byte[n];
        int n2 = (int)(System.currentTimeMillis() % (long)n);
        byArray[n2] = 35;
        preparedStatement.setBytes(1, (byte[])(n <= 32672 ? byArray : null));
        preparedStatement.setBytes(2, (byte[])(n <= 32700 ? byArray : null));
        preparedStatement.setBinaryStream(3, (InputStream)new ByteArrayInputStream(byArray), n);
        preparedStatement.executeUpdate();
        this.selectData(preparedStatement2, byArray, n2, n, string);
        preparedStatement3.executeUpdate();
        preparedStatement.setBinaryStream(1, (InputStream)(n <= 32672 ? new ByteArrayInputStream(byArray) : null), n);
        preparedStatement.setBinaryStream(2, (InputStream)(n <= 32700 ? new ByteArrayInputStream(byArray) : null), n);
        preparedStatement.setBinaryStream(3, (InputStream)new ByteArrayInputStream(byArray), n);
        preparedStatement.executeUpdate();
        this.selectData(preparedStatement2, byArray, n2, n, string);
        preparedStatement3.executeUpdate();
    }

    private void selectData(PreparedStatement preparedStatement, byte[] byArray, int n, int n2, String string) throws SQLException, IOException {
        Object object = null;
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            byte[] byArray2 = resultSet.getBytes(1);
            if (byArray2 != null) {
                object = "C1 " + (String)(byArray2.length == n2 ? "OK" : "FAIL <" + byArray2.length + ">");
                object = (String)object + " DATA " + (String)(byArray2[n] == 35 ? "OK" : "FAIL " + n);
            } else {
                object = "C1 NULL";
            }
            byArray2 = resultSet.getBytes(2);
            if (byArray2 != null) {
                object = (String)object + " C2 " + (String)(byArray2.length == n2 ? "OK" : "FAIL <" + byArray2.length + ">");
                object = (String)object + " DATA " + (String)(byArray2[n] == 35 ? "OK" : "FAIL " + n);
            } else {
                object = (String)object + " C2 NULL";
            }
            InputStream inputStream = resultSet.getBinaryStream(3);
            String string2 = this.checkEncodedLengthValue(" C3", inputStream, n2, n);
            object = (String)object + string2;
            ForBitDataTest.assertEquals((String)string, (String)object);
        }
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            object = this.checkEncodedLengthValue("C1", resultSet.getBinaryStream(1), n2, n) + this.checkEncodedLengthValue(" C2", resultSet.getBinaryStream(2), n2, n) + this.checkEncodedLengthValue(" C3", resultSet.getBinaryStream(3), n2, n);
            ForBitDataTest.assertEquals((String)string, (String)object);
        }
        resultSet.close();
    }

    private String checkEncodedLengthValue(String string, InputStream inputStream, int n, int n2) throws IOException {
        int n3;
        String string2 = null;
        if (inputStream == null) {
            string2 = string + " NULL";
            return string2;
        }
        byte[] byArray = new byte[3213];
        boolean bl = false;
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) >= 0) {
            if (n2 >= n4 && n2 < n4 + n3 && byArray[n2 - n4] == 35) {
                bl = true;
            }
            n4 += n3;
        }
        string2 = string + " " + (String)(n4 == n ? "OK" : "FAIL <" + n4 + ">");
        string2 = string2 + " DATA " + (String)(bl ? "OK" : "FAIL " + n2);
        return string2;
    }

    private void showCompareData(PreparedStatement preparedStatement, String[] stringArray) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next()) {
            String string = resultSet.getInt(1) + " " + this.showData(resultSet.getBytes(2)) + "  " + resultSet.getInt(3) + " " + this.showData(resultSet.getBytes(4));
            ForBitDataTest.assertEquals((String)stringArray[n], (String)string);
            ++n;
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void insertData(PreparedStatement preparedStatement, int n, byte[] byArray, int n2, boolean bl) throws SQLException {
        int n3;
        int n4 = n3 = byArray == null ? 0 : byArray.length;
        if (byArray == null || byArray.length <= n2) {
            preparedStatement.setInt(1, n);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.setBytes(4, byArray);
            preparedStatement.setBytes(5, byArray);
            preparedStatement.executeUpdate();
            if (bl) {
                preparedStatement.setInt(1, n + 1);
                preparedStatement.setBinaryStream(2, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.setBinaryStream(3, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.setBinaryStream(4, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.setBinaryStream(5, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.executeUpdate();
            }
            return;
        }
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setBytes(2, byArray);
            preparedStatement.setBytes(3, null);
            preparedStatement.setBytes(4, null);
            preparedStatement.setBytes(5, null);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        if (bl) {
            try {
                preparedStatement.setInt(1, n + 1);
                preparedStatement.setBinaryStream(2, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                ForBitDataTest.assertSQLState("22001", sQLException);
            }
        }
        try {
            preparedStatement.setInt(1, n + 2);
            preparedStatement.setBytes(2, null);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.setBytes(4, null);
            preparedStatement.setBytes(5, null);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        if (bl) {
            try {
                preparedStatement.setInt(1, n + 3);
                preparedStatement.setBinaryStream(3, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                ForBitDataTest.assertSQLState("22001", sQLException);
            }
        }
        try {
            preparedStatement.setInt(1, n + 4);
            preparedStatement.setBytes(2, null);
            preparedStatement.setBytes(3, null);
            preparedStatement.setBytes(4, byArray);
            preparedStatement.setBytes(5, null);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        if (bl) {
            try {
                preparedStatement.setInt(1, n + 5);
                preparedStatement.setBinaryStream(4, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                ForBitDataTest.assertSQLState("22001", sQLException);
            }
        }
        try {
            preparedStatement.setInt(1, n + 6);
            preparedStatement.setBytes(2, null);
            preparedStatement.setBytes(3, null);
            preparedStatement.setBytes(4, null);
            preparedStatement.setBytes(5, byArray);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            ForBitDataTest.assertSQLState("22001", sQLException);
        }
        if (bl) {
            try {
                preparedStatement.setInt(1, n + 7);
                preparedStatement.setBinaryStream(5, (InputStream)(byArray == null ? null : new ByteArrayInputStream(byArray)), n3);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                ForBitDataTest.assertSQLState("22001", sQLException);
            }
        }
    }

    private void showData(PreparedStatement preparedStatement, int n, byte[] byArray, String string) throws SQLException {
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n + 10);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string2 = "ORG " + this.showData(byArray);
            string2 = string2 + "CHR " + this.showData(resultSet.getBytes(1));
            string2 = string2 + "VAR " + this.showData(resultSet.getBytes(2));
            string2 = string2 + "LVC " + this.showData(resultSet.getBytes(3));
            string2 = string2 + "BLOB " + this.showData(resultSet.getBytes(4));
            ForBitDataTest.assertEquals((String)string, (String)string2);
        }
        resultSet.close();
    }

    private String showData(byte[] byArray) {
        if (byArray == null) {
            return "<NULL> ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(' ');
        stringBuffer.append('(');
        stringBuffer.append(byArray.length);
        stringBuffer.append(')');
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }
}

