/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OptionalToolsTest
extends GeneratedColumnsHelper {
    protected static final String NO_SUCH_TABLE_FUNCTION = "42ZB4";
    protected static final String UNEXPECTED_USER_EXCEPTION = "38000";
    protected static final String MISSING_SCHEMA = "42Y07";
    protected static final String UNKNOWN_TOOL = "X0Y88";
    protected static final String UNKNOWN_ROUTINE = "42Y03";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};
    private static final String FOREIGN_DB = "foreignDB";

    public OptionalToolsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(OptionalToolsTest.class);
        Object object = DatabasePropertyTestSetup.builtinAuthentication((Test)baseTestSuite, LEGAL_USERS, "optionalToolsPermissions");
        object = TestConfiguration.sqlAuthorizationDecorator(object);
        object = TestConfiguration.additionalDatabaseDecorator(object, FOREIGN_DB);
        return object;
    }

    public void test_01_dbmdWrapper() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        String string = "select type_name, minimum_scale, maximum_scale from table( getTypeInfo() ) s";
        this.expectExecutionError(connection2, "42504", "call syscs_util.syscs_register_tool( 'databaseMetaData', true )");
        this.goodStatement(connection, "create table t( a int )");
        this.expectCompilationError(connection, NO_SUCH_TABLE_FUNCTION, string);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'databaseMetaData', true )");
        this.assertResults(connection, string, new String[][]{{"BIGINT", "0", "0"}, {"LONG VARCHAR FOR BIT DATA", null, null}, {"VARCHAR () FOR BIT DATA", null, null}, {"CHAR () FOR BIT DATA", null, null}, {"LONG VARCHAR", null, null}, {"CHAR", null, null}, {"NUMERIC", "0", "31"}, {"DECIMAL", "0", "31"}, {"INTEGER", "0", "0"}, {"SMALLINT", "0", "0"}, {"FLOAT", null, null}, {"REAL", null, null}, {"DOUBLE", null, null}, {"VARCHAR", null, null}, {"BOOLEAN", null, null}, {"DATE", "0", "0"}, {"TIME", "0", "0"}, {"TIMESTAMP", "0", "9"}, {"OBJECT", null, null}, {"BLOB", null, null}, {"CLOB", null, null}, {"XML", null, null}}, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'databaseMetaData', false )");
        this.expectCompilationError(connection, NO_SUCH_TABLE_FUNCTION, string);
    }

    public void test_02_foreignDBViews() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.getTestConfiguration().openConnection(FOREIGN_DB, FRANK, FRANK);
        Connection connection3 = this.getTestConfiguration().openConnection(FOREIGN_DB, ALICE, ALICE);
        this.goodStatement(connection2, "create table employee\n(\n    firstName   varchar( 50 ),\n    lastName    varchar( 50 ),\n    employeeID  int primary key\n)\n");
        this.goodStatement(connection2, "insert into employee values ( 'Billy', 'Goatgruff', 1 )\n");
        this.goodStatement(connection2, "insert into employee values ( 'Mary', 'Hadalittlelamb', 2 )\n");
        this.goodStatement(connection3, "create table stars\n(\n    name   varchar( 50 ),\n    magnitude int,\n    starID  int primary key\n)\n");
        this.goodStatement(connection3, "insert into stars values ( 'Polaris', 100, 1 )\n");
        String string = "jdbc:derby:" + this.getTestConfiguration().getPhysicalDatabaseName(FOREIGN_DB) + ";user=TEST_DBO;password=TEST_DBO";
        String string2 = "select * from frank.employee order by employeeID";
        String string3 = "select * from alice.stars order by starID";
        String[][] stringArray = new String[][]{{"Billy", "Goatgruff", "1"}, {"Mary", "Hadalittlelamb", "2"}};
        String[][] stringArray2 = new String[][]{{"Polaris", "100", "1"}};
        this.goodStatement(connection, "create function countConnections() returns int\nlanguage java parameter style java no sql\nexternal name 'org.apache.derby.vti.ForeignTableVTI.countConnections'\n");
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'foreignViews', true )");
        this.expectCompilationError(connection, MISSING_SCHEMA, string2);
        this.expectCompilationError(connection, MISSING_SCHEMA, string3);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'foreignViews', true, '" + string + "' )");
        this.assertResults(connection, string2, stringArray, false);
        this.assertResults(connection, string3, stringArray2, false);
        this.assertResults(connection, "values countConnections()", new String[][]{{"1"}}, false);
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'foreignViews', false )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + string + "' )");
        this.assertResults(connection, "values countConnections()", new String[][]{{"0"}}, false);
        this.expectCompilationError(connection, MISSING_SCHEMA, string2);
        this.expectCompilationError(connection, MISSING_SCHEMA, string3);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + string + "' )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'foreignViews', true, '" + string + "', 'XYZ_' )");
        string2 = "select * from xyz_frank.employee order by employeeID";
        string3 = "select * from xyz_alice.stars order by starID";
        this.assertResults(connection, string2, stringArray, false);
        this.assertResults(connection, string3, stringArray2, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'foreignViews', false, '" + string + "', 'XYZ_' )");
        this.expectCompilationError(connection, MISSING_SCHEMA, string2);
        this.expectCompilationError(connection, MISSING_SCHEMA, string3);
        this.assertResults(connection, "values countConnections()", new String[][]{{"0"}}, false);
        this.goodStatement(connection, "drop function countConnections");
    }

    public void test_03_customTool() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.expectExecutionError(connection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'uknownToolName', true )");
        this.expectExecutionError(connection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'customTool', true )");
        this.expectExecutionError(connection, UNKNOWN_TOOL, "call syscs_util.syscs_register_tool( 'customTool', true, 'java.lang.String' )");
        this.expectCompilationError(connection, UNKNOWN_ROUTINE, "values toString( 100 )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'customTool', true, 'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample' )");
        this.assertResults(connection, "values toString( 100 )", new String[][]{{"100"}}, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'customTool', false, 'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample' )");
        this.expectCompilationError(connection, UNKNOWN_ROUTINE, "values toString( 100 )");
        this.expectCompilationError(connection, UNKNOWN_ROUTINE, "values foobar( 100 )");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool\n(\n    'customTool',\n    true,\n    'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample$VariableName',\n    'foobar'\n)\n");
        this.assertResults(connection, "values foobar( 100 )", new String[][]{{"100"}}, false);
        this.goodStatement(connection, "call syscs_util.syscs_register_tool\n(\n    'customTool',\n    false,\n    'org.apache.derbyTesting.functionTests.tests.lang.OptionalToolExample$VariableName',\n    'foobar'\n)\n");
        this.expectCompilationError(connection, UNKNOWN_ROUTINE, "values foobar( 100 )");
    }

    public void test_04_customOptimizerTrace() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create function fullTrace() returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace.fullTrace'\n");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool\n(\n    'optimizerTracing', true, 'custom',\n    'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace'\n)\n");
        this.goodStatement(connection, "select tablename from sys.systables where 1=2");
        this.goodStatement(connection, "select columnname from sys.syscolumns where 1=2");
        this.goodStatement(connection, "call syscs_util.syscs_register_tool( 'optimizerTracing', false )");
        this.assertResults(connection, "values fullTrace()", new String[][]{{"<text>select tablename from sys.systables where 1=2</text><text>select columnname from sys.syscolumns where 1=2</text><text>call syscs_util.syscs_register_tool( 'optimizerTracing', false )</text>"}}, false);
        this.goodStatement(connection, "drop function fullTrace");
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom' )");
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom', 'foo.bar.Wibble' )");
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool( 'optimizerTracing', true, 'custom', 'java.lang.String' )");
        this.expectExecutionError(connection, UNEXPECTED_USER_EXCEPTION, "call syscs_util.syscs_register_tool\n(\n    'optimizerTracing', true, 'custom',\n    'org.apache.derbyTesting.functionTests.tests.lang.DummyOptTrace$BadSubclass'\n)\n");
    }
}

