/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RenameTableTest
extends BaseJDBCTestCase {
    private static final String PRIMARY_VIOLATION = "23505";
    private static final String FOREIGN_VIOLATION = "23503";
    private static final String DEFERRED_PRIMARY_VIOLATION = "23506";
    private static final String DEFERRED_FOREIGN_VIOLATION = "23516";
    private static final String USER_ERROR = "38000";

    public RenameTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(RenameTableTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenameNonExistingTable() throws SQLException {
        Statement statement = this.createStatement();
        RenameTableTest.assertStatementError("42Y55", statement, "rename table notexists to notexists1");
    }

    public void testExistedNameForRenameTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int not null primary key)");
        statement.executeUpdate("create table t2(c21 int not null primary key)");
        RenameTableTest.assertStatementError("X0Y32", statement, "rename table t1 to t2");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table t2");
    }

    public void testRenameSystemTable() throws SQLException {
        Statement statement = this.createStatement();
        RenameTableTest.assertStatementError("42X62", statement, "rename table sys.systables to fake");
    }

    public void testRenameTableWithViews() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int not null primary key)");
        statement.executeUpdate("insert into t1 values 11");
        statement.executeUpdate("create view v1 as select * from t1");
        RenameTableTest.assertStatementError("42Y62", statement, "rename table v1 to fake");
        RenameTableTest.assertStatementError("X0Y23", statement, "rename table t1 to fake");
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop table t1");
    }

    public void testRenameWithIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t3(c31 int not null)");
        statement.executeUpdate("create index i1_t3 on t3(c31)");
        RenameTableTest.assertUpdateCount(statement, 0, "rename table t3 to t3r");
        statement.executeUpdate("drop table t3r");
    }

    public void testRenameWithPreparedStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t3(c31 int not null primary key)");
        statement.executeUpdate("insert into t3 values 31");
        statement.executeUpdate("insert into t3 values 32");
        statement.executeUpdate("insert into t3 values 33");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t3 where c31 > ?");
        preparedStatement.setInt(1, 30);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.close();
        RenameTableTest.assertUpdateCount(statement, 0, "rename table t3 to t3r");
        preparedStatement.setInt(1, 30);
        try {
            ResultSet resultSet2 = preparedStatement.executeQuery();
            RenameTableTest.fail((String)"Table/View t3 Doesn't exists:");
        }
        catch (SQLException sQLException) {
            RenameTableTest.assertSQLState("42X05", sQLException);
        }
        statement.executeUpdate("drop table t3r");
    }

    public void testRenameTableWithTriggersOnIt() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t6 (c61 int default 1)");
        statement.executeUpdate("create table t7(c71 int)");
        statement.executeUpdate("create trigger t7insert after insert on t7 referencing new as NEWROW for each row insert into t6 values(NEWROW.c71)");
        statement.executeUpdate("insert into t7 values(1)");
        RenameTableTest.assertStatementError("X0Y25", statement, "rename table t7 to t7r");
        RenameTableTest.assertStatementError("42X05", statement, "select * from t7r");
        ResultSet resultSet = statement.executeQuery("select * from t7");
        resultSet.next();
        resultSet.close();
        RenameTableTest.assertStatementError("X0Y25", statement, "rename table t6 to t6r");
        statement.execute("insert into t7 values(3)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t6 order by c61"), new String[][]{{"1"}, {"3"}});
        RenameTableTest.assertStatementError("42X05", statement, "select * from t7r");
        statement.executeUpdate("drop table t7");
        statement.executeUpdate("drop table t6");
    }

    public void testRenameWithCheckConstraintsOnIt() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tcheck (i int check(i>5))");
        RenameTableTest.assertStatementError("X0Y25", statement, "rename table tcheck to tcheck1");
        statement.executeUpdate("drop table tcheck");
        statement.executeUpdate("create table tcheck (i int, j int, constraint tcon check (i+j>2))");
        RenameTableTest.assertStatementError("X0Y25", statement, "rename table tcheck to tcheck1");
        statement.executeUpdate("alter table tcheck drop constraint tcon");
        statement.executeUpdate("rename table tcheck to tcheck1");
        statement.executeUpdate("drop table tcheck1");
    }

    public void testRenameInvalidation_derby_4479() throws SQLException {
        this.getConnection().setAutoCommit(true);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table a (x int not null primary key)");
        statement.executeUpdate("rename table a to b");
        statement.executeUpdate("create table a (x int not null primary key)");
        statement.executeUpdate("drop table a");
        statement.executeUpdate("drop table b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_6672_1() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        this.goodStatement(connection, "create procedure runStatementAndRaiseError( text varchar( 128 ) )\nlanguage java parameter style java modifies sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RenameTableTest.runStatementAndRaiseError'\n");
        this.goodStatement(connection, "create table primary1( a int primary key )");
        this.goodStatement(connection, "create table foreign1( a int references primary1( a ) )");
        this.goodStatement(connection, "rename table primary1 to primary2");
        this.goodStatement(connection, "rename table foreign1 to foreign2");
        this.goodStatement(connection, "rename column primary2.a to b");
        this.goodStatement(connection, "rename column foreign2.a to b");
        this.goodStatement(connection, "insert into primary2 values 1");
        RenameTableTest.assertPreparedStatementError(PRIMARY_VIOLATION, connection.prepareStatement("insert into primary2 values 1"));
        this.goodStatement(connection, "insert into foreign2 values 1");
        RenameTableTest.assertPreparedStatementError(FOREIGN_VIOLATION, connection.prepareStatement("insert into foreign2 values 2"));
        this.goodStatement(connection, "create table primary10( a int primary key initially deferred )");
        this.goodStatement(connection, "create table foreign10( a int references primary10( a ) initially deferred )");
        connection.setAutoCommit(false);
        try {
            this.goodStatement(connection, "insert into primary10 values 1");
            this.goodStatement(connection, "rename table primary10 to primary20");
            this.goodStatement(connection, "insert into primary20 values 1");
            try {
                connection.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)DEFERRED_PRIMARY_VIOLATION, (String)sQLException.getSQLState());
            }
            this.goodStatement(connection, "insert into primary10 values 1");
            this.goodStatement(connection, "rename table primary10 to primary20");
            this.goodStatement(connection, "rename table foreign10 to foreign20");
            this.goodStatement(connection, "insert into foreign20 values 2");
            try {
                connection.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)DEFERRED_FOREIGN_VIOLATION, (String)sQLException.getSQLState());
            }
        }
        finally {
            connection.setAutoCommit(true);
        }
        this.goodStatement(connection, "create table primary100( a int primary key initially deferred )");
        this.goodStatement(connection, "create table foreign100( a int references primary100( a ) initially deferred )");
        connection.setAutoCommit(false);
        try {
            this.goodStatement(connection, "insert into primary100 values 1, 1");
            try {
                connection.prepareStatement("call runStatementAndRaiseError( 'rename table primary100 to primary200' )").execute();
                RenameTableTest.fail((String)"Statement should have failed!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)USER_ERROR, (String)sQLException.getSQLState());
            }
            try {
                connection.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)DEFERRED_PRIMARY_VIOLATION, (String)sQLException.getSQLState());
            }
            this.goodStatement(connection, "insert into primary100 values 1");
            this.goodStatement(connection, "rename table primary100 to primary200");
            this.goodStatement(connection, "insert into foreign100 values 2");
            try {
                connection.prepareStatement("call runStatementAndRaiseError( 'rename table foreign100 to foreign200' )").execute();
                RenameTableTest.fail((String)"Statement should have failed!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)USER_ERROR, (String)sQLException.getSQLState());
            }
            try {
                connection.commit();
                RenameTableTest.fail((String)"Commit should not have succeeded!");
            }
            catch (SQLException sQLException) {
                RenameTableTest.assertEquals((String)DEFERRED_FOREIGN_VIOLATION, (String)sQLException.getSQLState());
            }
        }
        finally {
            connection.setAutoCommit(true);
        }
    }

    public static void runStatementAndRaiseError(String string) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        connection.prepareStatement(string).execute();
        throw new SQLException("Oh sorry, an error occurred.");
    }
}

