/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RestrictedVTITest
extends GeneratedColumnsHelper {
    public RestrictedVTITest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(RestrictedVTITest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        return cleanDatabaseTestSetup;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection connection = this.getConnection();
        if (!this.routineExists(connection, "GETLASTPROJECTION")) {
            this.goodStatement(connection, "create function getLastProjection\n()\nreturns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastProjection'\n");
        }
        if (!this.routineExists(connection, "GETLASTRESTRICTION")) {
            this.goodStatement(connection, "create function getLastRestriction\n()\nreturns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastRestriction'\n");
        }
        if (!this.routineExists(connection, "GETCOUNT")) {
            this.goodStatement(connection, "create function getCount\n()\nreturns int\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastQualifiedRowCount'\n");
        }
        if (!this.routineExists(connection, "INTEGERLIST")) {
            this.goodStatement(connection, "create function integerList()\nreturns table( s_r int, s_nr int, ns_r int, ns_nr int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        }
        if (!this.routineExists(connection, "NULLABLEINTEGERLIST")) {
            this.goodStatement(connection, "create function nullableIntegerList()\nreturns table( s_r int, s_nr int, ns_r int, ns_nr int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.nullableIntegerList'\n");
        }
        if (!this.routineExists(connection, "INTEGERLISTSPECIALCOLNAMES")) {
            this.goodStatement(connection, "create function integerListSpecialColNames()\nreturns table( \"CoL \"\"1\"\"\" int,\n\"cOL \"\"2\"\"\" int, col3 int, col4 int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".integerListSpecialColNames'\n");
        }
        if (!this.routineExists(connection, "MAKEBLOB5370")) {
            this.goodStatement(connection, "create function makeBlob5370( ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.makeSimpleBlob'\n");
        }
        if (!this.routineExists(connection, "LASTQUERY5370")) {
            this.goodStatement(connection, "create function lastQuery5370() returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedTableVTI.getLastQuery'\n");
        }
        if (!this.routineExists(connection, "RESTRICTED5370")) {
            this.goodStatement(connection, "create function restricted5370( schemaName varchar( 32672 ), tableName varchar( 32672 ) )\nreturns table\n(\n    key_col int,\n    boolean_col  BOOLEAN,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB,\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2), \n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA\n)\nlanguage java parameter style derby_jdbc_result_set reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedTableVTI.readTable'\n");
        }
        if (!this.tableExists(connection, "T_4357_1")) {
            this.goodStatement(connection, "create table t_4357_1( a int )\n");
            this.goodStatement(connection, "insert into t_4357_1( a ) values cast( null as int), ( 1 ), ( 100 ), ( 1000 ), ( 10000)\n");
        }
        if (!this.tableExists(connection, "T_5370")) {
            this.goodStatement(connection, "create table t_5370\n(\n    key_col int,\n    boolean_col  BOOLEAN,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB,\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2), \n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA\n)\n");
            this.goodStatement(connection, "insert into t_5370\n(\n    key_col,\n    boolean_col,\n    bigint_col,\n    blob_col,\n    char_col,\n    char_for_bit_data_col,\n    clob_col,\n    date_col,\n    decimal_col,\n    real_col,\n    double_col,\n    int_col,\n    long_varchar_col,\n    long_varchar_for_bit_data_col,\n    numeric_col, \n    smallint_col,\n    time_col,\n    timestamp_col,\n    varchar_col,\n    varchar_for_bit_data_col\n)\nvalues\n(\n    0,\n    false,\n    0,\n    makeBlob5370(),\n    '0',\n    X'DE',\n    '0',\n    date('1994-02-23'),\n    0.00,\n    0.0,\n    0.0,\n    0,\n    '0',\n    X'DE',\n    0.00, \n    0,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '0',\n    X'DE'\n),\n(\n    1,\n    true,\n    1,\n    makeBlob5370(),\n    '1',\n    X'DD',\n    '1',\n    date('1994-02-24'),\n    1.00,\n    1.0,\n    1.0,\n    1,\n    '1',\n    X'DE',\n    1.00, \n    1,\n    time('15:09:03'),\n    timestamp('1963-09-23 03:23:34.234'),\n    '1',\n    X'DD'\n),\n(\n    2,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null\n)\n");
        }
    }

    public void test_01_heartbeat() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000 order by s_r\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null);
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select s_r from table( integerList() ) s where s_r > 1 and ns_r < ?");
        preparedStatement.setInt(1, 30000);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, new String[][]{{"100"}, {"1000"}}, false);
        this.assertResults(connection, "values ( getLastProjection() )\n", new String[][]{{"[S_R, null, NS_R, null]"}}, false);
        this.assertResults(connection, "values ( getLastRestriction() )\n", new String[][]{{"( \"NS_R\" < 30000 ) AND ( \"S_R\" > 1 )"}}, false);
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where not( s_r > 1 and ns_r < 3000 )\n", new String[][]{{"1", "2"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "( \"S_R\" <= 1 ) OR ( \"NS_R\" >= 3000 )");
    }

    public void test_02_aliasing() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select 2*w, x from table( integerList() ) as s( w, x, y, z ) where w > 1 and mod( y, 3 ) = 0\n", new String[][]{{"200", "200"}, {"2000", "2000"}, {"20000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"S_R\" > 1");
    }

    public void test_03_allRelationalOperators() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r is null\n", new String[][]{{null, "2"}}, "[S_R, S_NR, null, null]", "\"S_R\" IS NULL ");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r is not null\n", new String[][]{{"100", null}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" IS NOT NULL ");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r < 1000\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" < 1000");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r <= 100\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" <= 100");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r = 100\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" = 100");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r > 100\n", new String[][]{{"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r >= 100\n", new String[][]{{"100", null}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" >= 100");
    }

    public void test_04_misc() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r < s_nr + ns_r\n", new String[][]{{"10000", "20000"}}, "[S_R, S_NR, NS_R, null]", null);
        this.assertPR(connection, "select s_r from table( nullableIntegerList() ) s where ns_r = cast( '300' as int)\n", new String[][]{{"100"}}, "[S_R, null, NS_R, null]", "\"NS_R\" = 300");
    }

    public void test_05_joins() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select a, w, y from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w\n", new String[][]{{"100", "100", "300"}, {"1000", "1000", null}, {"10000", "10000", "30000"}}, "[S_R, null, NS_R, null]", null);
        this.assertPR(connection, "select a, w, y from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w order by y\n", new String[][]{{"100", "100", "300"}, {"10000", "10000", "30000"}, {"1000", "1000", null}}, "[S_R, null, NS_R, null]", null);
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and y is not null\n", new String[][]{{"100", "100", null}, {"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"NS_R\" IS NOT NULL ");
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and y is not null order by w\n", new String[][]{{"100", "100", null}, {"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"NS_R\" IS NOT NULL ");
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a > 100\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a > 100 order by x\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a + x > 100\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", null);
        this.assertPR(connection, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and x + y > 100\n", new String[][]{{"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", null);
    }

    public void test_06_distinct() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select distinct s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(connection, "select distinct s_r, s_nr from table( integerList() ) s\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null);
    }

    public void test_07_subqueries() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select * from t_4357_1 where exists ( select x from table( nullableIntegerList() ) as s( w, x, y, z ) where a = w )\n", new String[][]{{"100"}, {"1000"}, {"10000"}}, "[S_R, S_NR, null, null]", null);
        this.assertPR(connection, "select * from table( nullableIntegerList() ) as t( a, b, c, d ) where exists ( select x from table( nullableIntegerList() ) as s( w, x, y, z ) where a = w )\n", new String[][]{{"100", null, "300", "400"}, {"1000", "2000", null, "4000"}, {"10000", "20000", "30000", null}}, "[S_R, S_NR, null, null]", null);
    }

    public void test_08_having() throws Exception {
        this.assertPR(this.getConnection(), "select s_r, count(*) from table(integerList()) t group by s_r having s_r > 1", new String[][]{{"100", "1"}, {"1000", "1"}, {"10000", "1"}}, "[S_R, null, null, null]", null);
    }

    public void test_09_4651() throws Exception {
        Connection connection = this.getConnection();
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null, 4);
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where s_r > 500 order by s_r\n", new String[][]{{"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 500", 2);
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where s_r > 500 or 1=1 order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null, 4);
        this.assertPR(connection, "select s_r, s_nr from table( integerList() ) s where s_r > 500 and 1 != 1 order by s_r\n", new String[0][], "[S_R, S_NR, null, null]", null, 4);
    }

    public void test_10_quotes_in_column_names() throws Exception {
        String[][] stringArray = new String[][]{{"100", "200", "300", "400"}};
        String string = "( \"cOL \"\"2\"\"\" < 1000 ) AND ( \"CoL \"\"1\"\"\" > 1 )";
        this.assertPR(this.getConnection(), "select * from table(integerListSpecialColNames()) t where \"CoL \"\"1\"\"\" > 1 and \"cOL \"\"2\"\"\" < 1000", stringArray, "[CoL \"1\", cOL \"2\", COL3, COL4]", string);
        Statement statement = this.createStatement();
        ResultSet resultSet = RestrictedVTITest.executeQuery(statement, "values getLastRestriction()");
        RestrictedVTITest.assertTrue((String)"empty result", (boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        RestrictedVTITest.assertEquals((String)string, (String)string2);
        resultSet.close();
        resultSet = RestrictedVTITest.executeQuery(statement, "select * from table(integerListSpecialColNames()) t where " + string2);
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
    }

    public void test_11_5369_5370() throws Exception {
        Connection connection = this.getConnection();
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.vetDatatypeCount(connection, 22);
        this.vet5370positive(connection, "BOOLEAN_COL", "false", "false", "true");
        this.vet5370positive(connection, "BIGINT_COL", "0", "0", "1");
        this.vet5370positive(connection, "CHAR_COL", "'0'", "0         ", "1         ");
        this.vet5370positive(connection, "CHAR_FOR_BIT_DATA_COL", "X'de'", "de202020202020202020", "dd202020202020202020");
        this.vet5370positive(connection, "DATE_COL", "DATE('1994-02-23')", "1994-02-23", "1994-02-24");
        this.vet5370positive(connection, "DECIMAL_COL", "0.00", "0.00", "1.00");
        this.vet5370positive(connection, "REAL_COL", "0.0", "0.0", "1.0");
        this.vet5370positive(connection, "DOUBLE_COL", "0.0", "0.0", "1.0");
        this.vet5370positive(connection, "INT_COL", "0", "0", "1");
        this.vet5370positive(connection, "NUMERIC_COL", "0.00", "0.00", "1.00");
        this.vet5370positive(connection, "SMALLINT_COL", "0", "0", "1");
        this.vet5370positive(connection, "TIME_COL", "TIME('15:09:02')", "15:09:02", "15:09:03");
        this.vet5370positive(connection, "TIMESTAMP_COL", "TIMESTAMP('1962-09-23 03:23:34.234')", "1962-09-23 03:23:34.234", "1963-09-23 03:23:34.234");
        this.vet5370positive(connection, "VARCHAR_COL", "'0'", "0", "1");
        this.vet5370positive(connection, "VARCHAR_FOR_BIT_DATA_COL", "X'de'", "de", "dd");
        this.vet5370negative("BLOB_COL", "makeBlob5370()");
        this.vet5370negative("CLOB_COL", "'0'");
        this.vet5370negative("LONG_VARCHAR_COL", "'0'");
        this.vet5370negative("LONG_VARCHAR_FOR_BIT_DATA_COL", "X'de'");
    }

    private void vet5370positive(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        this.assertResults(connection, "select " + string + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + string + " = " + string2, new String[][]{{string3}}, false);
        this.assertResults(connection, "values( lastQuery5370() )", new String[][]{{"select " + RestrictedVTITest.doubleQuote(string) + "\nfrom " + RestrictedVTITest.doubleQuote("APP") + "." + RestrictedVTITest.doubleQuote("T_5370") + "\nwhere " + RestrictedVTITest.doubleQuote(string) + " = " + string2}}, false);
        this.assertResults(connection, "select " + string + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + string + " != " + string2, new String[][]{{string4}}, false);
        this.assertResults(connection, "values( lastQuery5370() )", new String[][]{{"select " + RestrictedVTITest.doubleQuote(string) + "\nfrom " + RestrictedVTITest.doubleQuote("APP") + "." + RestrictedVTITest.doubleQuote("T_5370") + "\nwhere " + RestrictedVTITest.doubleQuote(string) + " != " + string2}}, false);
    }

    private static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    private void vet5370negative(String string, String string2) throws Exception {
        this.expectCompilationError("42818", "select " + string + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + string + " = " + string2);
    }

    private int vetDatatypeCount(Connection connection, int n) throws Exception {
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        int n2 = 0;
        while (resultSet.next()) {
            ++n2;
        }
        resultSet.close();
        RestrictedVTITest.assertEquals((int)n, (int)n2);
        return n2;
    }

    public void test_12_6036() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create view v6036 as select * from table( integerList() ) s");
        this.assertResults(connection, "select s_nr from table( integerList() ) s where ns_r = 3000", new String[][]{{"2000"}}, false);
        this.assertResults(connection, "values getLastProjection()", new String[][]{{"[null, S_NR, NS_R, null]"}}, false);
        this.assertResults(connection, "values getLastRestriction()", new String[][]{{"\"NS_R\" = 3000"}}, false);
        this.assertResults(connection, "select s_nr from v6036 where ns_r = 3000", new String[][]{{"2000"}}, false);
        this.assertResults(connection, "values getLastProjection()", new String[][]{{"[S_R, S_NR, NS_R, NS_NR]"}}, false);
        this.assertResults(connection, "values getLastRestriction()", new String[][]{{"\"NS_R\" = 3000"}}, false);
    }

    public static IntegerArrayVTI integerList() {
        return new IntegerArrayVTI(new String[]{"S_R", "S_NR", "NS_R", "NS_NR"}, (int[][])new int[][]{{1, 2, 3, 4}, {100, 200, 300, 400}, {1000, 2000, 3000, 4000}, {10000, 20000, 30000, 40000}});
    }

    public static IntegerArrayVTI nullableIntegerList() {
        return new IntegerArrayVTI(new String[]{"S_R", "S_NR", "NS_R", "NS_NR"}, (Integer[][])new Integer[][]{{null, RestrictedVTITest.i(2), RestrictedVTITest.i(3), RestrictedVTITest.i(4)}, {RestrictedVTITest.i(100), null, RestrictedVTITest.i(300), RestrictedVTITest.i(400)}, {RestrictedVTITest.i(1000), RestrictedVTITest.i(2000), null, RestrictedVTITest.i(4000)}, {RestrictedVTITest.i(10000), RestrictedVTITest.i(20000), RestrictedVTITest.i(30000), null}});
    }

    private static Integer i(int n) {
        return n;
    }

    public static IntegerArrayVTI integerListSpecialColNames() {
        return new IntegerArrayVTI(new String[]{"CoL \"1\"", "cOL \"2\"", "COL3", "COL4"}, (int[][])new int[][]{{1, 2, 3, 4}, {100, 200, 300, 400}, {1000, 2000, 3000, 4000}, {10000, 20000, 30000, 40000}});
    }

    private boolean routineExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.sysaliases where alias = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private boolean tableExists(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count (*) from sys.systables where tablename = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        boolean bl = resultSet.getInt(1) > 0;
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private void assertPR(Connection connection, String string, String[][] stringArray, String string2, String string3, int n) throws Exception {
        this.assertPR(connection, string, stringArray, string2, string3);
        this.assertResults(connection, "values ( getCount() )\n", new String[][]{{Integer.toString(n)}}, false);
    }

    private void assertPR(Connection connection, String string, String[][] stringArray, String string2, String string3) throws Exception {
        this.assertResults(connection, string, stringArray, false);
        this.assertResults(connection, "values ( getLastProjection() )\n", new String[][]{{string2}}, false);
        this.assertResults(connection, "values ( getLastRestriction() )\n", new String[][]{{string3}}, false);
    }
}

