/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;
import org.apache.derby.impl.sql.catalog.SequenceRange;
import org.apache.derby.impl.sql.catalog.SequenceUpdater;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.SGVetter;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequenceGeneratorTest
extends GeneratedColumnsHelper {
    private static final long ALLOCATION_COUNT = 100L;
    private static final int TWEAKED_ALLOCATION_COUNT = 7;
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH"};
    private static final String MISSING_ALLOCATOR = "X0Y85";
    private static final String DUPLICATE_SEQUENCE = "X0Y68";
    private static boolean _fullDebug = false;

    public SequenceGeneratorTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(SequenceGeneratorTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)cleanDatabaseTestSetup, 5, 5);
        Test test2 = DatabasePropertyTestSetup.builtinAuthentication(test, LEGAL_USERS, "sequenceGenerator");
        Test test3 = TestConfiguration.sqlAuthorizationDecorator(test2);
        return test3;
    }

    public void test_01_basic() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        int n = Integer.MIN_VALUE;
        this.goodStatement(connection, "create sequence seq_01\n");
        SequenceGeneratorTest.assertEquals((long)n, (long)this.getCurrentValue(TEST_DBO, "SEQ_01"));
        int n2 = n;
        long l = (long)n2 + 100L;
        int n3 = 0;
        while ((long)n3 < 100L) {
            this.vetBumping(connection, TEST_DBO, "SEQ_01", n2++, l);
            ++n3;
        }
        this.vetBumping(connection, TEST_DBO, "SEQ_01", n2++, l += 100L);
        this.goodStatement(connection, "create sequence seq_01_a\n");
        n3 = n;
        long l2 = (long)n3 + 100L;
        for (int i = 0; i < 2; ++i) {
            this.vetBumping(connection, TEST_DBO, "SEQ_01_A", n3++, l2);
        }
        l = (long)n2 + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_01", n2++, l);
    }

    private void vetBumping(Connection connection, String string, String string2, int n, long l) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "values( next value for " + string + "." + string2 + " )\n");
        SequenceGeneratorTest.assertEquals((int)n, (int)this.getScalarInteger(preparedStatement));
        SequenceGeneratorTest.assertEquals((long)l, (long)this.getCurrentValue(string, string2));
    }

    public void test_02_boundary() throws Exception {
        T_SequenceUpdater t_SequenceUpdater = new T_SequenceUpdater((Long)Integer.MIN_VALUE, true, 1L, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        SequenceGeneratorTest.assertEquals((long)Integer.MIN_VALUE, (long)t_SequenceUpdater.getValueOnDisk());
        long l = Integer.MIN_VALUE;
        long l2 = l + 100L;
        for (long i = 0L; i < 100L; ++i) {
            this.vetBumping(t_SequenceUpdater, l + i, l2);
        }
        this.vetBumping(t_SequenceUpdater, l + 100L, l2 += 100L);
        this.vetBoundaries(32767L, -32768L);
        this.vetBoundaries(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBoundaries(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBoundaries(16383L, -16384L);
        this.vetBoundaries(0x3FFFFFFFL, -1073741824L);
        this.vetBoundaries(0x3FFFFFFFFFFFFFFFL, -4611686018427387904L);
    }

    private void vetBoundaries(long l, long l2) throws Exception {
        this.vetBoundaries(l, l2, 1L);
        this.vetBoundaries(l, l2, 100L);
        this.vetBoundaries(l, l2, 200L);
    }

    private void vetBoundaries(long l, long l2, long l3) throws Exception {
        this.vetUpperBoundary(l, l2, l3);
        this.vetLowerBoundary(l, l2, l3);
    }

    private void vetUpperBoundary(long l, long l2, long l3) throws Exception {
        long l4 = l2;
        long l5 = l - 100L * l3;
        long l6 = l;
        long l7 = (l6 - l5) / 2L;
        if (l5 > 0L) {
            this.vetBoundaries(l, l2, l3, l5, l4);
        }
        if (l7 > 0L) {
            this.vetBoundaries(l, l2, l3, l7, l4);
        }
        if (l6 > 0L) {
            this.vetBoundaries(l, l2, l3, l6, l4);
        }
    }

    private void vetLowerBoundary(long l, long l2, long l3) throws Exception {
        long l4 = l;
        long l5 = l2 + 100L * l3;
        long l6 = l2;
        long l7 = (l6 - l5) / 2L;
        if (l5 < 0L) {
            this.vetBoundaries(l, l2, -l3, l5, l4);
        }
        if (l7 < 0L) {
            this.vetBoundaries(l, l2, -l3, l7, l4);
        }
        if (l6 < 0L) {
            this.vetBoundaries(l, l2, -l3, l6, l4);
        }
    }

    private void vetBoundaries(long l, long l2, long l3, long l4, long l5) throws Exception {
        long l6 = 201L;
        this.vetBumping(l4, true, l3, l, l2, l5, l6);
        this.vetBumping(l4, false, l3, l, l2, l5, l6);
    }

    private void vetBumping(long l, boolean bl, long l2, long l3, long l4, long l5, long l6) throws Exception {
        if (_fullDebug) {
            SequenceGeneratorTest.println("stepSize = " + l2 + " and firstValue = " + l + " and canCycle = " + bl);
        }
        SGVetter sGVetter = new SGVetter(l, bl, l2, l3, l4, l5, 100L);
        T_SequenceUpdater t_SequenceUpdater = new T_SequenceUpdater(l, bl, l2, l3, l4, l5);
        if (_fullDebug) {
            SequenceGeneratorTest.println("");
        }
        for (long i = 0L; i < l6; ++i) {
            this.vetBump(sGVetter, t_SequenceUpdater);
        }
    }

    private void vetBump(SGVetter sGVetter, T_SequenceUpdater t_SequenceUpdater) throws Exception {
        this.assertLongEquals(sGVetter.getUpperBound(), t_SequenceUpdater.getValueOnDisk());
        Long l = sGVetter.getNextValue();
        if (_fullDebug) {
            SequenceGeneratorTest.println("Expecting value = " + l + " and expecting ValueOnDisk = " + sGVetter.getUpperBound());
        }
        if (l != null) {
            long l2 = t_SequenceUpdater.getCurrentValueAndAdvance();
            SequenceGeneratorTest.assertEquals((long)l, (long)l2);
        } else {
            try {
                t_SequenceUpdater.getCurrentValueAndAdvance();
                SequenceGeneratorTest.fail((String)"Expected to catch cycle exception.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assertLongEquals(sGVetter.getUpperBound(), t_SequenceUpdater.getValueOnDisk());
    }

    private void assertLongEquals(Long l, Long l2) {
        if (l == null) {
            SequenceGeneratorTest.assertNull((Object)l2);
        } else {
            SequenceGeneratorTest.assertNotNull((Object)l2);
            SequenceGeneratorTest.assertEquals((long)l, (long)l2);
        }
    }

    private void vetBumping(T_SequenceUpdater t_SequenceUpdater, long l, long l2) throws Exception {
        long l3 = t_SequenceUpdater.getCurrentValueAndAdvance();
        long l4 = t_SequenceUpdater.getValueOnDisk();
        SequenceGeneratorTest.println("Expected value = " + l + " vs actual value = " + l3);
        SequenceGeneratorTest.println("    Expected value on disk = " + l2 + " vs actual value on disk = " + l4);
        SequenceGeneratorTest.assertEquals((long)l, (long)l3);
        SequenceGeneratorTest.assertEquals((long)l2, (long)l4);
    }

    public void test_03_nonCycling() throws Exception {
        this.vetNonCycling(32767L, -32768L);
        this.vetNonCycling(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetNonCycling(Long.MAX_VALUE, Long.MIN_VALUE);
    }

    private void vetNonCycling(long l, long l2) throws Exception {
        this.vetNonCycling(l, l2, 1L);
        this.vetNonCycling(l, l2, -1L);
    }

    private void vetNonCycling(long l, long l2, long l3) throws Exception {
        long l4;
        long l5;
        long l6 = 3L;
        if (l3 > 0L) {
            l5 = l - l6;
            l4 = l2;
        } else {
            l5 = l2 + l6;
            l4 = l;
        }
        SGVetter sGVetter = new SGVetter(l5, false, l3, l, l2, l4, 100L);
        T_SequenceUpdater t_SequenceUpdater = new T_SequenceUpdater(l5, false, l3, l, l2, l4);
        long l7 = l6 + 2L;
        for (long i = 0L; i <= l7; ++i) {
            this.vetBump(sGVetter, t_SequenceUpdater);
        }
    }

    public void test_04_reboot() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        int n = Integer.MIN_VALUE;
        this.goodStatement(connection, "create sequence seq_04\n");
        int n2 = n;
        long l = (long)n2 + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_04", n2++, l);
        this.vetBumping(connection, TEST_DBO, "SEQ_04", n2++, l);
        this.getTestConfiguration().shutdownDatabase();
        connection = this.openUserConnection(TEST_DBO);
        l = (long)n2 + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_04", n2++, l);
        this.getTestConfiguration().shutdownDatabase();
        connection = this.openUserConnection(TEST_DBO);
        l = (long)n2 + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_04", n2++, l);
    }

    public void test_05_concurrency() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        int n = Integer.MIN_VALUE;
        this.goodStatement(connection, "create sequence seq_05\n");
        this.goodStatement(connection, "grant usage on sequence seq_05 to public\n");
        int n2 = n;
        long l = n2;
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        connection2.setAutoCommit(false);
        connection3.setAutoCommit(false);
        long l2 = 200L;
        for (long i = 0L; i < l2; ++i) {
            Connection connection4;
            Connection connection5 = connection4 = i % 2L == 0L ? connection2 : connection3;
            if (i % 100L == 0L) {
                l += 100L;
            }
            this.vetBumping(connection4, TEST_DBO, "SEQ_05", n2++, l);
        }
        connection2.commit();
        connection3.commit();
    }

    public void test_06_bigStepSize() throws Exception {
        long l = 276701161105643274L;
        T_SequenceUpdater t_SequenceUpdater = new T_SequenceUpdater(Long.MIN_VALUE, true, l, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        long l2 = t_SequenceUpdater.getCurrentValueAndAdvance();
        long l3 = t_SequenceUpdater.getValueOnDisk();
        long l4 = l3 - l2;
        SequenceGeneratorTest.assertEquals((long)l, (long)l4);
        this.vetBigStep(32767L, -32768L);
        this.vetBigStep(Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.vetBigStep(Long.MAX_VALUE, Long.MIN_VALUE);
        this.vetBigStep(100L, 0L);
    }

    private void vetBigStep(long l, long l2) throws Exception {
        Long l3 = l2;
        long l4 = l2;
        long l5 = l - 1L;
        boolean bl = true;
        long l6 = 1L;
        SGVetter sGVetter = new SGVetter(l3, bl, l5, l, l2, l4, l6);
        T_SequenceUpdater t_SequenceUpdater = new T_SequenceUpdater(l3, bl, l5, l, l2, l4);
        for (long i = 0L; i < 100L; ++i) {
            this.vetBump(sGVetter, t_SequenceUpdater);
        }
    }

    public void test_07_dropSequence() throws Exception {
        int n;
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create sequence seq_07\n");
        int n2 = n = Integer.MIN_VALUE;
        long l = (long)n2 + 100L;
        int n3 = 0;
        while ((long)n3 < 100L) {
            this.vetBumping(connection, TEST_DBO, "SEQ_07", n2++, l);
            ++n3;
        }
        this.goodStatement(connection, "values( next value for seq_07 )\n");
        this.goodStatement(connection, "drop sequence seq_07 restrict\n");
        this.expectCompilationError("42X94", "values ( next value for seq_07 )\n");
    }

    public void test_08_userWrittenAllocators() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create sequence seq_08\n");
        String string = ((Object)((Object)this)).getClass().getName() + "$UnknownClass";
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + string + "')");
        this.expectExecutionError(connection, MISSING_ALLOCATOR, "values ( next value for seq_08 )");
        string = ((Object)((Object)this)).getClass().getName() + "$BadAllocator";
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + string + "')");
        this.expectExecutionError(connection, MISSING_ALLOCATOR, "values ( next value for seq_08 )");
        string = ((Object)((Object)this)).getClass().getName() + "$LegalAllocator";
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + string + "')");
        this.vetBumping(connection, TEST_DBO, "SEQ_08", Integer.MIN_VALUE, -2147483641L);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', null )");
    }

    public void test_09_defaultRangeSize() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create sequence seq_09_01\n");
        long l = 30L;
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + l + "')");
        this.vetBumping(connection, TEST_DBO, "SEQ_09_01", Integer.MIN_VALUE, Integer.MIN_VALUE + l);
        this.goodStatement(connection, "create sequence seq_09_02\n");
        l = 0L;
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + l + "')");
        this.vetBumping(connection, TEST_DBO, "SEQ_09_02", Integer.MIN_VALUE, -2147483548L);
        this.goodStatement(connection, "create sequence seq_09_03\n");
        l = -1L;
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + l + "')");
        this.expectExecutionError(connection, MISSING_ALLOCATOR, "values ( next value for seq_09_03 )");
        this.goodStatement(connection, "create sequence seq_09_04\n");
        l = 0x7FFFFFFFFFFFFFFEL;
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + l + "')");
        this.expectExecutionError(connection, MISSING_ALLOCATOR, "values ( next value for seq_09_04 )");
        this.goodStatement(connection, "create sequence seq_09_05 as smallint\n");
        l = 98301L;
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', '" + l + "')");
        this.vetBumping(connection, TEST_DBO, "SEQ_09_05", Short.MIN_VALUE, -32767L);
        this.goodStatement(connection, "call syscs_util.syscs_set_database_property( 'derby.language.sequence.preallocator', null )");
    }

    public void test_10_5398() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create sequence seq_10\n");
        int n = Integer.MIN_VALUE;
        long l = (long)n + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_10", n++, l);
        this.getTestConfiguration().shutdownEngine();
        connection = this.openUserConnection(TEST_DBO);
        l = (long)n + 100L;
        this.vetBumping(connection, TEST_DBO, "SEQ_10", n++, l);
    }

    public void test_11_5493_correctness() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create table t_5493 (x int)\n");
        this.goodStatement(connection, "create sequence s_5493\n");
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select count(*) from sys.syssequences with rs\n");
        this.getScalarInteger(preparedStatement);
        preparedStatement.close();
        int n = Integer.MIN_VALUE;
        this.expectExecutionError(connection, "X0Y84", "values next value for s_5493");
        this.goodStatement(connection, "drop table t_5493\n");
        connection.rollback();
        preparedStatement = this.chattyPrepare(connection, "values next value for s_5493");
        SequenceGeneratorTest.assertEquals((int)n++, (int)this.getScalarInteger(preparedStatement));
        preparedStatement.close();
        this.goodStatement(connection, "drop sequence s_5493 restrict\n");
        connection.commit();
        connection.setAutoCommit(bl);
    }

    public void test_12_5493_function() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.goodStatement(connection, "create sequence s_5493\n");
        this.goodStatement(connection, "grant usage on sequence s_5493 to public\n");
        int n = Integer.MIN_VALUE;
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "values next value for s_5493");
        SequenceGeneratorTest.assertEquals((int)n++, (int)this.getScalarInteger(preparedStatement));
        preparedStatement.close();
        preparedStatement = this.chattyPrepare(connection, "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        SequenceGeneratorTest.assertEquals((int)n++, (int)this.getScalarInteger(preparedStatement));
        preparedStatement.close();
        this.expectExecutionError(connection, "X0X81", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493_1' )\n");
        connection.setAutoCommit(false);
        this.goodStatement(connection, "drop sequence s_5493 restrict\n");
        this.expectExecutionError(connection, "X0X81", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        this.expectCompilationError(connection, "42X94", "values next value for s_5493");
        this.expectExecutionError(connection2, "40XL1", "values syscs_util.syscs_peek_at_sequence( 'TEST_DBO', 'S_5493' )\n");
        this.expectCompilationError(connection2, "40XL1", "values next value for TEST_DBO.s_5493");
        connection.commit();
        connection.setAutoCommit(true);
    }

    public void test_13_5494() throws Exception {
        String string = "DB_5494";
        SequenceGeneratorTest.assertLaunchedJUnitTestMethod(((Object)((Object)this)).getClass().getName() + ".preCrashActions", string);
        SequenceGeneratorTest.assertLaunchedJUnitTestMethod(((Object)((Object)this)).getClass().getName() + ".postCrashActions", string);
    }

    public void preCrashActions() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        int n = Integer.MIN_VALUE;
        this.goodStatement(connection, "create sequence s_5494\n");
        this.assertNextValue(connection, TEST_DBO, "S_5494", n);
        SequenceGeneratorTest.assertEquals((long)((long)n + 100L), (long)this.getCurrentValue(connection2, TEST_DBO, "S_5494"));
    }

    public void postCrashActions() throws Exception {
        int n = -2147483548;
        Connection connection = this.openUserConnection(TEST_DBO);
        SequenceGeneratorTest.assertEquals((long)n, (long)this.getCurrentValue(connection, TEST_DBO, "S_5494"));
        this.assertNextValue(connection, TEST_DBO, "S_5494", n);
        this.goodStatement(connection, "drop sequence s_5494 restrict\n");
    }

    private void assertNextValue(Connection connection, String string, String string2, int n) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "values( next value for " + string + "." + string2 + " )\n");
        SequenceGeneratorTest.assertEquals((int)n, (int)this.getScalarInteger(preparedStatement));
    }

    public void test_14_6553() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        this.goodStatement(connection, "create table t1_6553_1(x int, y int, z int)");
        this.goodStatement(connection, "create table t2_6553_1(x int, y int, z int)");
        this.goodStatement(connection, "create sequence seq_6553_1");
        this.goodStatement(connection, "values next value for seq_6553_1");
        this.goodStatement(connection, "create trigger tr1 after insert on t1_6553_1 insert into t2_6553_1(x) values (next value for seq_6553_1)");
        connection.setAutoCommit(false);
        this.goodStatement(connection, "create sequence seq_6553");
        connection.commit();
        this.goodStatement(connection, "values next value for seq_6553");
        this.expectExecutionError(connection, DUPLICATE_SEQUENCE, "create sequence seq_6553");
        connection.rollback();
        connection.setAutoCommit(true);
    }

    private long getCurrentValue(String string, String string2) throws Exception {
        return this.getCurrentValue(this.openUserConnection(TEST_DBO), string, string2);
    }

    private long getCurrentValue(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.chattyPrepare(connection, "select currentvalue from sys.syssequences seq, sys.sysschemas s where s.schemaname = ? and seq.sequencename = ? and s.schemaid = seq.schemaid");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        long l = this.getScalarLong(preparedStatement);
        connection.commit();
        return l;
    }

    private int getScalarInteger(PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    private long getScalarLong(PreparedStatement preparedStatement) throws Exception {
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        preparedStatement.close();
        return l;
    }

    public static final class T_SequenceUpdater
    extends SequenceUpdater {
        private Long _valueOnDisk;

        public T_SequenceUpdater(Long l, boolean bl, long l2, long l3, long l4, long l5) {
            this._valueOnDisk = l;
            this._sequenceGenerator = new SequenceGenerator(l, bl, l2, l3, l4, l5, "DUMMY_SCHEMA", "DUMMY_SEQUENCE", (SequencePreallocator)new SequenceRange());
        }

        public Long getValueOnDisk() {
            return this._valueOnDisk;
        }

        public long getCurrentValueAndAdvance() throws Exception {
            SQLLongint sQLLongint = new SQLLongint();
            this.getCurrentValueAndAdvance((NumberDataValue)sQLLongint);
            return sQLLongint.getLong();
        }

        protected SequenceGenerator createSequenceGenerator(TransactionController transactionController) {
            return this._sequenceGenerator;
        }

        protected boolean updateCurrentValueOnDisk(TransactionController transactionController, Long l, Long l2, boolean bl) {
            this._valueOnDisk = l2;
            return true;
        }

        public boolean updateCurrentValueOnDisk(Long l, Long l2) {
            return this.updateCurrentValueOnDisk(null, l, l2, false);
        }
    }

    public static final class LegalAllocator
    implements SequencePreallocator {
        public int nextRangeSize(String string, String string2) {
            return 7;
        }
    }

    public static final class BadAllocator {
    }
}

