/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby4676Test
extends BaseJDBCTestCase {
    private List<HelperThread> threads;

    public Derby4676Test(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby4676Test.class);
    }

    protected void setUp() {
        this.threads = new ArrayList<HelperThread>();
    }

    @Override
    protected void tearDown() throws Exception {
        HelperThread helperThread;
        int n;
        super.tearDown();
        List<HelperThread> list = this.threads;
        this.threads = null;
        for (n = 0; n < list.size(); ++n) {
            helperThread = list.get(n);
            helperThread.join();
            Connection connection = helperThread.conn;
            if (connection == null || connection.isClosed()) continue;
            connection.rollback();
            connection.close();
        }
        for (n = 0; n < list.size(); ++n) {
            helperThread = list.get(n);
            if (helperThread.exception == null) continue;
            Derby4676Test.fail("Helper thread failed", helperThread.exception);
        }
    }

    public void testConcurrentFetchAndDelete() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table t(x int, y int)");
        statement.execute("create index idx on t(x)");
        HelperThread helperThread = new HelperThread(this){

            @Override
            void body(Connection connection) throws Exception {
                Thread.sleep(1000L);
                Statement statement = connection.createStatement();
                for (int i = 0; i < 1000; ++i) {
                    statement.execute("insert into t values (1,2)");
                    statement.execute("delete from t");
                }
                statement.close();
            }
        };
        this.startThread(helperThread);
        while (helperThread.isAlive()) {
            JDBC.assertDrainResults(statement.executeQuery("select * from t --derby-properties index=idx"));
        }
    }

    private void startThread(HelperThread helperThread) {
        helperThread.start();
        this.threads.add(helperThread);
    }

    private abstract class HelperThread
    extends Thread {
        Exception exception;
        Connection conn;

        private HelperThread() {
        }

        @Override
        public void run() {
            try {
                this.conn = Derby4676Test.this.openDefaultConnection();
                this.body(this.conn);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }

        abstract void body(Connection var1) throws Exception;
    }
}

