/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class Changes10_12
extends UpgradeChange {
    private static final String LANG_AI_CANNOT_MODIFY_AI = "42Z23";
    private static final String LANG_NULL_INTO_NON_NULL = "23502";

    public Changes10_12(String string) {
        super(string);
    }

    public static Test suite(int n) {
        return new BaseTestSuite(Changes10_12.class, "Upgrade test for 10.12");
    }

    public void testDerby6414UpdateIdentityColumn() throws SQLException {
        if (!this.oldAtLeast(10, 1)) {
            return;
        }
        Statement statement = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                statement.execute("create table t1_6414(a int, c int generated always as identity,d char(3),e char(5))");
                statement.execute("insert into t1_6414(a) values (1), (2)");
                this.assertCompileError(LANG_AI_CANNOT_MODIFY_AI, "update t1_6414 set e='ccccc', a=-a, c=default");
                statement.execute("create table t2_6414(a int, c int generated by default as identity,d char(3),e char(5))");
                statement.execute("insert into t2_6414(a,d,e,c) values (1,'aaa','aaaaa',1)");
                statement.execute("insert into t2_6414(a,d,e,c) values (2,'bbb','bbbbb',default)");
                Changes10_12.assertStatementError(LANG_NULL_INTO_NON_NULL, statement, "update t2_6414 set e='ccccc', a=-a, c=default, d='ccc'");
                break;
            }
            case 1: {
                if (!this.oldAtLeast(10, 11)) {
                    this.assertCompileError(LANG_AI_CANNOT_MODIFY_AI, "update t1_6414 set e='ccccc', a=-a, c=default");
                    Changes10_12.assertStatementError(LANG_NULL_INTO_NON_NULL, statement, "update t2_6414 set e='ccccc', a=-a, c=default, d='ccc'");
                    break;
                }
                statement.execute("update t1_6414 set e='ccccc', a=-a, c=default");
                JDBC.assertFullResultSet(statement.executeQuery("select * from t1_6414"), new String[][]{{"-1", "3", null, "ccccc"}, {"-2", "4", null, "ccccc"}});
                statement.execute("update t2_6414 set e='ccccc', a=-a, c=default, d='ccc'");
                JDBC.assertFullResultSet(statement.executeQuery("select * from t2_6414"), new String[][]{{"-1", "2", "ccc", "ccccc"}, {"-2", "3", "ccc", "ccccc"}});
                break;
            }
            case 2: {
                this.assertCompileError(LANG_AI_CANNOT_MODIFY_AI, "update t1_6414 set e='ccccc', a=-a, c=default");
                Changes10_12.assertStatementError(LANG_NULL_INTO_NON_NULL, statement, "update t2_6414 set e='ccccc', a=-a, c=default, d='ccc'");
                break;
            }
            case 3: {
                statement.execute("update t1_6414 set e='ccccc', a=-a, c=default");
                if (!this.oldAtLeast(10, 11)) {
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t1_6414"), new String[][]{{"-1", "3", null, "ccccc"}, {"-2", "4", null, "ccccc"}});
                } else {
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t1_6414"), new String[][]{{"1", "5", null, "ccccc"}, {"2", "6", null, "ccccc"}});
                }
                statement.execute("update t2_6414 set e='ccccc', a=-a, c=default, d='ccc'");
                if (!this.oldAtLeast(10, 11)) {
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t2_6414"), new String[][]{{"-1", "2", "ccc", "ccccc"}, {"-2", "3", "ccc", "ccccc"}});
                    break;
                }
                JDBC.assertFullResultSet(statement.executeQuery("select * from t2_6414"), new String[][]{{"1", "4", "ccc", "ccccc"}, {"2", "5", "ccc", "ccccc"}});
            }
        }
    }

    public void testAlterTableAddIdentity() throws SQLException {
        Statement statement = this.createStatement();
        String string = "alter table derby_3888_t1 add column id int generated always as identity";
        String string2 = "alter table derby_3888_t2 add column id int generated by default as identity";
        if (!(this.oldAtLeast(10, 1) || this.getPhase() != 0 && this.getPhase() != 2)) {
            string2 = string2.replace("by default", "always");
        }
        switch (this.getPhase()) {
            case 0: {
                statement.execute("create table derby_3888_t1(x int)");
                statement.execute("insert into derby_3888_t1 values 1");
                this.assertCompileError("42601", string);
                statement.execute("create table derby_3888_t2(x int)");
                statement.execute("insert into derby_3888_t2 values 1");
                this.assertCompileError("42601", string2);
                break;
            }
            case 1: {
                if (this.oldAtLeast(10, 11)) {
                    statement.execute(string);
                    statement.execute("insert into derby_3888_t1(x) values 2");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from derby_3888_t1 order by x"), new String[][]{{"1", "1"}, {"2", "2"}});
                    break;
                }
                this.assertCompileError("XCL47", string);
                this.assertCompileError("XCL47", string2);
                statement.execute("insert into derby_3888_t1(x) values 2");
                break;
            }
            case 2: {
                String[][] stringArray;
                statement.execute("insert into derby_3888_t1(x) values 3");
                if (this.oldAtLeast(10, 11)) {
                    String[][] stringArrayArray = new String[3][];
                    stringArrayArray[0] = new String[]{"1", "1"};
                    stringArrayArray[1] = new String[]{"2", "2"};
                    stringArray = stringArrayArray;
                    stringArrayArray[2] = new String[]{"3", "3"};
                } else {
                    String[][] stringArray2 = new String[3][];
                    stringArray2[0] = new String[]{"1"};
                    stringArray2[1] = new String[]{"2"};
                    stringArray = stringArray2;
                    stringArray2[2] = new String[]{"3"};
                }
                String[][] stringArray3 = stringArray;
                JDBC.assertFullResultSet(statement.executeQuery("select * from derby_3888_t1 order by x"), stringArray3);
                this.assertCompileError("42601", string2);
                break;
            }
            case 3: {
                if (!this.oldAtLeast(10, 11)) {
                    statement.execute(string);
                }
                statement.execute(string2);
                statement.execute("insert into derby_3888_t2(x) values 2");
                statement.execute("insert into derby_3888_t1(x) values 4");
                JDBC.assertFullResultSet(statement.executeQuery("select * from derby_3888_t1 order by x"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}});
                JDBC.assertFullResultSet(statement.executeQuery("select * from derby_3888_t2 order by x"), new String[][]{{"1", "1"}, {"2", "2"}});
                statement.execute("drop table derby_3888_t1");
                statement.execute("drop table derby_3888_t2");
            }
        }
    }
}

