/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.RunTest;

public class TestUtil {
    public static boolean HAVE_DRIVER_CLASS;
    public static final int UNKNOWN_FRAMEWORK = -1;
    public static final int EMBEDDED_FRAMEWORK = 0;
    public static final int DERBY_NET_FRAMEWORK = 1;
    public static final int DB2JCC_FRAMEWORK = 2;
    public static final int DERBY_NET_CLIENT_FRAMEWORK = 3;
    public static final int OLD_NET_FRAMEWORK = 4;
    private static int framework;
    private static String XA_DATASOURCE_STRING;
    private static String CONNECTION_POOL_DATASOURCE_STRING;
    private static String REGULAR_DATASOURCE_STRING;
    private static Class[] STRING_ARG_TYPE;
    private static Class[] INT_ARG_TYPE;
    private static Class[] BOOLEAN_ARG_TYPE;
    private static Hashtable<String, Class[]> specialAttributes;
    public static String TABLE_START_TAG;
    public static String TABLE_END_TAG;
    public static String TD_INVERSE;
    public static String TD_CENTER;
    public static String TD_LEFT;
    public static String TD_END;
    public static String END_HTML_PAGE;

    public static boolean isNetFramework() {
        framework = TestUtil.getFramework();
        switch (framework) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJCCFramework() {
        int n = TestUtil.getFramework();
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDerbyNetClientFramework() {
        return TestUtil.getFramework() == 3;
    }

    public static boolean isEmbeddedFramework() {
        return TestUtil.getFramework() == 0;
    }

    private static int getFramework() {
        String string;
        if (framework != -1) {
            return framework;
        }
        String string2 = System.getProperty("framework");
        if (string2 == null && (string = RunTest.framework) != null) {
            string2 = string;
        }
        if (string2 == null || string2.toUpperCase(Locale.ENGLISH).equals("EMBEDDED")) {
            framework = 0;
        } else if (string2.toUpperCase(Locale.ENGLISH).equals("DERBYNETCLIENT")) {
            framework = 3;
        } else if (string2.toUpperCase(Locale.ENGLISH).equals("DERBYNET")) {
            framework = 1;
        } else if (string2.toUpperCase(Locale.ENGLISH).indexOf("DB2JNET") != -1) {
            framework = 4;
        }
        return framework;
    }

    public static String getJdbcUrlPrefix() {
        String string = TestUtil.getHostName();
        return TestUtil.getJdbcUrlPrefix(string, 1527);
    }

    public static String getHostName() {
        String string = System.getProperty("hostName");
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    public static String getJdbcUrlPrefix(String string, int n) {
        int n2 = TestUtil.getFramework();
        switch (n2) {
            case 0: {
                return "jdbc:derby:";
            }
            case 1: 
            case 4: {
                return "jdbc:derby:net://" + string + ":" + n + "/";
            }
            case 3: {
                return "jdbc:derby://" + string + ":" + n + "/";
            }
            case 2: {
                return "jdbc:db2://" + string + ":" + n + "/";
            }
        }
        return null;
    }

    public static void loadDriver() throws Exception {
        framework = TestUtil.getFramework();
        Class<?> clazz = Class.forName(switch (framework) {
            case 0 -> "org.apache.derby.jdbc.EmbeddedDriver";
            case 1, 2, 4 -> "com.ibm.db2.jcc.DB2Driver";
            case 3 -> "org.apache.derby.jdbc.ClientDriver";
            default -> "org.apache.derby.jdbc.EmbeddedDriver";
        });
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static DataSource getDataSource(Properties properties) {
        String string = TestUtil.getDataSourcePrefix() + REGULAR_DATASOURCE_STRING + "DataSource40";
        return (DataSource)TestUtil.getDataSourceWithReflection(string, properties);
    }

    public static XADataSource getXADataSource(Properties properties) {
        String string = TestUtil.getDataSourcePrefix() + XA_DATASOURCE_STRING + "DataSource40";
        return (XADataSource)TestUtil.getDataSourceWithReflection(string, properties);
    }

    public static ConnectionPoolDataSource getConnectionPoolDataSource(Properties properties) {
        String string = TestUtil.getDataSourcePrefix() + CONNECTION_POOL_DATASOURCE_STRING + "DataSource40";
        return (ConnectionPoolDataSource)TestUtil.getDataSourceWithReflection(string, properties);
    }

    public static String getDataSourcePrefix() {
        framework = TestUtil.getFramework();
        switch (framework) {
            case 1: 
            case 2: 
            case 4: {
                return "com.ibm.db2.jcc.DB2";
            }
            case 3: {
                return "org.apache.derby.jdbc.Client";
            }
            case 0: {
                return "org.apache.derby.jdbc.Embedded";
            }
        }
        Exception exception = new Exception("FAIL: No DataSource Prefix for framework: " + framework);
        exception.printStackTrace();
        return null;
    }

    private static Object getDataSourceWithReflection(String string, Properties properties) {
        Object[] objectArray = null;
        Object object = null;
        Method method = null;
        String string2 = null;
        if (specialAttributes == null) {
            specialAttributes = new Hashtable();
            specialAttributes.put("portNumber", INT_ARG_TYPE);
            specialAttributes.put("driverType", INT_ARG_TYPE);
            specialAttributes.put("retrieveMessagesFromServerOnGetMessage", BOOLEAN_ARG_TYPE);
            specialAttributes.put("retrieveMessageText", BOOLEAN_ARG_TYPE);
        }
        try {
            Class<?> clazz = Class.forName(string);
            object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            String string3 = TestUtil.getHostName();
            if (!TestUtil.isEmbeddedFramework() && string3 != null && properties.getProperty("serverName") == null) {
                properties.setProperty("serverName", string3);
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                Class[] classArray = specialAttributes.get(string4);
                if (classArray == null) {
                    classArray = STRING_ARG_TYPE;
                }
                String string5 = properties.getProperty(string4);
                if (classArray == INT_ARG_TYPE) {
                    objectArray = new Integer[]{Integer.valueOf(string5)};
                } else if (classArray == BOOLEAN_ARG_TYPE) {
                    objectArray = new Boolean[]{Boolean.valueOf(string5)};
                } else if (classArray == STRING_ARG_TYPE) {
                    objectArray = new String[]{string5};
                } else {
                    throw new Exception("FAIL: getDataSourceWithReflection: Argument type " + classArray[0].getName() + " not supportted for attribute:  key:" + string4 + " value:" + string5);
                }
                string2 = TestUtil.getSetterName(string4);
                method = object.getClass().getMethod(string2, classArray);
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            System.out.println("Error accessing method " + string2);
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
        return object;
    }

    public static String getSetterName(String string) {
        return "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String getGetterName(String string) {
        return "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void dumpSQLExceptions(SQLException sQLException) {
        TestUtil.dumpSQLExceptions(sQLException, false);
    }

    public static void dumpSQLExceptions(SQLException sQLException, boolean bl) {
        String string = "";
        if (!bl) {
            System.out.println("FAIL -- unexpected exception ****************");
        } else {
            string = "EXPECTED ";
        }
        do {
            System.out.println(string + "SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException.getMessage());
        } while ((sQLException = sQLException.getNextException()) != null);
    }

    public static String sqlNameFromJdbc(int n) {
        switch (n) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(n);
    }

    public static String getNameFromJdbcType(int n) {
        switch (n) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "Types.REAL";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 1: {
                return "Types.CHAR";
            }
            case 12: {
                return "Types.VARCHAR";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case 91: {
                return "Types.DATE";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(n);
    }

    public static void startHTMLPage(String string, String string2) {
        System.out.println("<HTML> \n <HEAD>");
        System.out.println(" <meta http-equiv=\"Content-Type\"content=\"text/html; charset=iso-8859-1\">");
        System.out.println("<meta name=\"Author\" content=\"" + string2 + "\">");
        System.out.println("<title>" + string + "</title>");
        System.out.println("</HEAD> <BODY>");
        System.out.println("<H1>" + string + "</H1>");
    }

    public static void endHTMLPage() {
        System.out.println(END_HTML_PAGE);
    }

    public static void printBoolArrayHTMLTable(String string, String string2, String[] stringArray, String[] stringArray2, boolean[][] blArray, String string3) {
        int n;
        int n2;
        System.out.println("<H2>" + string3 + "</H2>");
        System.out.println(TABLE_START_TAG);
        System.out.println("<TR>");
        System.out.println(TD_INVERSE + string2 + "---><BR><BR><BR><BR><BR>");
        System.out.println("<---" + string);
        System.out.println(TD_END);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            System.out.println(TD_INVERSE);
            for (n = 0; n < stringArray2[n2].length() && n < 20; ++n) {
                System.out.println(stringArray2[n2].charAt(n) + "<BR>");
            }
            System.out.println(TD_END);
        }
        System.out.println("</TR>");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            System.out.println("<TR>");
            System.out.println(TD_LEFT);
            System.out.println("<C> " + stringArray[n2] + "</C>");
            System.out.println(TD_END);
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println(TD_CENTER);
                System.out.println(blArray[n2][n] ? "Y" : "-");
                System.out.println(TD_END);
            }
            System.out.println("</TR>");
        }
        System.out.println(TABLE_END_TAG);
        System.out.println("<P><P>");
    }

    public static String stringToHexLiteral(String string) {
        String string2 = null;
        try {
            byte[] byArray = string.getBytes("UTF-16BE");
            string2 = TestUtil.convertToHexString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This shouldn't happen as UTF-16BE should be supported");
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    private static String convertToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X'");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString() + "'";
    }

    public static int getJDBCMajorVersion(Connection connection) {
        try {
            connection.getClass().getMethod("setSavepoint", null);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Method method = databaseMetaData.getClass().getMethod("getJDBCMajorVersion", null);
            return ((Number)method.invoke((Object)databaseMetaData, null)).intValue();
        }
        catch (Throwable throwable) {
            return 2;
        }
    }

    public static void cleanUpTest(Statement statement, String[] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                statement.execute("drop " + stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String string, String string2) throws SQLException {
        try {
            Connection connection;
            if (HAVE_DRIVER_CLASS) {
                int n = TestUtil.getFramework();
                Class<?> clazz = Class.forName(switch (n) {
                    case 0 -> "org.apache.derby.jdbc.EmbeddedDriver";
                    case 1, 2, 4 -> "com.ibm.db2.jcc.DB2Driver";
                    case 3 -> "org.apache.derby.jdbc.ClientDriver";
                    default -> "org.apache.derby.jdbc.EmbeddedDriver";
                });
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                String string3 = TestUtil.getJdbcUrlPrefix() + string;
                if (string2 != null) {
                    string3 = string3 + ";" + string2;
                }
                if (n == 1 && (string2 == null || string2 != null && string2.indexOf("user") < 0)) {
                    string3 = string3 + ":user=APP;password=APP;retrieveMessagesFromServerOnGetMessage=true;";
                }
                connection = DriverManager.getConnection(string3);
            } else {
                Properties properties = new Properties();
                properties.setProperty("databaseName", string);
                if (string2 != null) {
                    properties.setProperty("connectionAttributes", string2);
                }
                connection = TestUtil.getDataSourceConnection(properties);
            }
            return connection;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("FAILure: Class not found!");
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("FAILure: Cannot instantiate class");
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("FAILure: Not allowed to use class");
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("FAILure: No such constructor");
            noSuchMethodException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("FAILure: Cannot execute constructor");
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public static Connection getDataSourceConnection(Properties properties) throws SQLException {
        DataSource dataSource = TestUtil.getDataSource(properties);
        Connection connection = dataSource.getConnection();
        return connection;
    }

    public static void shutdownUsingDataSource(String string) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("databaseName", string);
        properties.setProperty("shutdownDatabase", "shutdown");
        DataSource dataSource = TestUtil.getDataSource(properties);
        Connection connection = dataSource.getConnection();
    }

    public static boolean compareURL(String string) {
        if (TestUtil.isEmbeddedFramework()) {
            if (string.compareTo("jdbc:derby:wombat") == 0) {
                return true;
            }
        } else if (TestUtil.isNetFramework()) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                String string2 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.compareTo("wombat;create=true") != 0) {
                    return false;
                }
                if (TestUtil.isJCCFramework() && string2.compareTo("jdbc:derby:net:") == 0) {
                    return true;
                }
                if (TestUtil.isDerbyNetClientFramework() && string2.compareTo("jdbc:derby:") == 0) {
                    return true;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return false;
    }

    public static void dumpAllStackTracesIfSupported(PrintWriter printWriter) {
        try {
            String string = System.getProperty("java.version");
            JavaVersionHolder javaVersionHolder = new JavaVersionHolder(string);
            if (javaVersionHolder.atLeast(1, 5)) {
                Class<?> clazz = Class.forName("org.apache.derbyTesting.functionTests.util.ThreadDump");
                Method method = clazz.getMethod("getStackDumpString", new Class[0]);
                String string2 = (String)method.invoke(null, new Object[0]);
                printWriter.println(string2);
            }
        }
        catch (Exception exception) {
            printWriter.println("Error trying to dump thread stack traces");
            if (exception instanceof InvocationTargetException) {
                ((InvocationTargetException)exception).getTargetException().printStackTrace(printWriter);
            }
            exception.printStackTrace(printWriter);
        }
    }

    static {
        try {
            Class.forName("java.sql.Driver");
            HAVE_DRIVER_CLASS = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HAVE_DRIVER_CLASS = false;
        }
        framework = -1;
        XA_DATASOURCE_STRING = "XA";
        CONNECTION_POOL_DATASOURCE_STRING = "ConnectionPool";
        REGULAR_DATASOURCE_STRING = "";
        STRING_ARG_TYPE = new Class[]{String.class};
        INT_ARG_TYPE = new Class[]{Integer.TYPE};
        BOOLEAN_ARG_TYPE = new Class[]{Boolean.TYPE};
        specialAttributes = null;
        TABLE_START_TAG = "<TABLE border=1 cellspacing=1 cellpadding=1  bgcolor=white  style='width:100%'>";
        TABLE_END_TAG = "</TABLE>";
        TD_INVERSE = "<td  valign=bottom align=center style=background:#DADADA;  padding:.75pt .75pt .75pt .75pt'> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:  6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_CENTER = "<TD valign=center align=center> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_LEFT = "<TD valign=center align=left> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_END = "</SPAN></TD>";
        END_HTML_PAGE = "</BODY> </HTML>";
    }
}

