/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Utilities;

public class IndexStatsUtil {
    private static final boolean INDEX = false;
    private static final boolean TABLE = true;
    private static final int NO_EXPECTATION = -1;
    private static final String SEP = BaseJDBCTestCase.getSystemProperty("line.separator");
    private final Connection con;
    private final long timeout;
    private PreparedStatement psGetTableId;
    private PreparedStatement psGetStatsForTable;
    private PreparedStatement psGetIndexId;
    private PreparedStatement psGetStatsForIndex;
    private PreparedStatement psGetStats;
    private PreparedStatement psGetIdToNameMapConglom;
    private PreparedStatement psGetIdToNameMapTable;

    public IndexStatsUtil(Connection connection) {
        this(connection, 0L);
    }

    public IndexStatsUtil(Connection connection, long l) {
        try {
            Assert.assertTrue((boolean)connection.getAutoCommit());
        }
        catch (SQLException sQLException) {
            Assert.fail((String)("Failed to get auto commit: " + sQLException.getMessage()));
        }
        if (l < 0L) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.con = connection;
        this.timeout = l;
    }

    public void assertNoStats() throws SQLException {
        this.assertStats(0);
    }

    public void assertNoStatsTable(String string) throws SQLException {
        this.assertTableStats(string, 0);
    }

    public void assertStats(int n) throws SQLException {
        IdxStats[] idxStatsArray = this.getStats();
        if (idxStatsArray.length != n) {
            Assert.assertEquals((String)IndexStatsUtil.buildStatString(idxStatsArray, "<ALL TABLES>"), (int)n, (int)idxStatsArray.length);
        }
    }

    public void assertTableStats(String string, int n) throws SQLException {
        this.getStatsTable(string, n);
    }

    public void assertIndexStats(String string, int n) throws SQLException {
        this.getStatsIndex(string, n);
    }

    public static String buildStatString(IdxStats[] idxStatsArray, String string) {
        StringBuffer stringBuffer = new StringBuffer("Index statistics for " + string + SEP);
        for (int i = 0; i < idxStatsArray.length; ++i) {
            stringBuffer.append(i + 1).append(": ").append(idxStatsArray[i].toString()).append(SEP);
        }
        if (idxStatsArray.length == 0) {
            stringBuffer.append(" : <no stats>").append(SEP);
        }
        return stringBuffer.toString();
    }

    public IdxStats[] getStats() throws SQLException {
        if (this.psGetStats == null) {
            this.psGetStats = this.con.prepareStatement("select * from SYS.SYSSTATISTICS order by TABLEID, REFERENCEID, COLCOUNT");
        }
        return this.buildStatisticsList(this.psGetStats.executeQuery(), this.getIdToNameMap());
    }

    public IdxStats[] getStatsTable(String string) throws SQLException {
        return this.getStatsTable(string, -1);
    }

    public IdxStats[] getStatsTable(String string, int n) throws SQLException {
        if (this.psGetTableId == null) {
            this.psGetTableId = this.con.prepareStatement("select TABLEID from SYS.SYSTABLES where TABLENAME = ?");
        }
        this.psGetTableId.setString(1, string);
        ResultSet resultSet = this.psGetTableId.executeQuery();
        Assert.assertTrue((String)("No such table: " + string), (boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        Assert.assertFalse((String)("More than one table named " + string), (boolean)resultSet.next());
        resultSet.close();
        IdxStats[] idxStatsArray = this.querySystemTable(string2, true, n);
        if (n != -1 && idxStatsArray.length != n) {
            Assert.assertEquals((String)("failed to get statistics for table " + string + " (#expected=" + n + ", timeout=" + this.timeout + ")" + SEP + IndexStatsUtil.buildStatString(idxStatsArray, string)), (int)n, (int)idxStatsArray.length);
        }
        return idxStatsArray;
    }

    public IdxStats[] getNewStatsTable(String string, IdxStats[] idxStatsArray) throws SQLException {
        if (this.timeout == 0L) {
            throw new IllegalStateException("no timeout specified in the constructor");
        }
        this.awaitChange(idxStatsArray, this.timeout);
        return this.getStatsTable(string, idxStatsArray.length);
    }

    public IdxStats[] getStatsIndex(String string) throws SQLException {
        return this.getStatsIndex(string, -1);
    }

    public IdxStats[] getStatsIndex(String string, int n) throws SQLException {
        if (this.psGetIndexId == null) {
            this.psGetIndexId = this.con.prepareStatement("select CONGLOMERATEID from SYS.SYSCONGLOMERATES where CONGLOMERATENAME = ? and CAST(ISINDEX as VARCHAR(5)) = 'true'");
        }
        this.psGetIndexId.setString(1, string);
        ResultSet resultSet = this.psGetIndexId.executeQuery();
        Assert.assertTrue((String)("No such index: " + string), (boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        Assert.assertFalse((String)("More than one index named " + string), (boolean)resultSet.next());
        resultSet.close();
        IdxStats[] idxStatsArray = this.querySystemTable(string2, false, n);
        if (n != -1 && idxStatsArray.length != n) {
            Assert.assertEquals((String)("failed to get statistics for index " + string + " (#expected=" + n + ", timeout=" + this.timeout + ")" + SEP + IndexStatsUtil.buildStatString(idxStatsArray, string)), (int)n, (int)idxStatsArray.length);
        }
        return idxStatsArray;
    }

    private IdxStats[] querySystemTable(String string, boolean bl, int n) throws SQLException {
        PreparedStatement preparedStatement;
        if (bl) {
            if (this.psGetStatsForTable == null) {
                this.psGetStatsForTable = this.con.prepareStatement("select * from SYS.SYSSTATISTICS where TABLEID = ? order by REFERENCEID, COLCOUNT");
            }
            preparedStatement = this.psGetStatsForTable;
        } else {
            if (this.psGetStatsForIndex == null) {
                this.psGetStatsForIndex = this.con.prepareStatement("select * from SYS.SYSSTATISTICS where REFERENCEID = ? order by COLCOUNT");
            }
            preparedStatement = this.psGetStatsForIndex;
        }
        preparedStatement.setString(1, string);
        long l = System.currentTimeMillis();
        long l2 = -1L;
        IdxStats[] idxStatsArray = null;
        while (l2 < this.timeout) {
            if (idxStatsArray != null) {
                Utilities.sleep(Math.min(250L, this.timeout - l2));
            }
            idxStatsArray = this.buildStatisticsList(preparedStatement.executeQuery(), this.getIdToNameMap());
            if (n == -1 || idxStatsArray.length == n) break;
            l2 = System.currentTimeMillis() - l;
        }
        return idxStatsArray;
    }

    public void printStats() throws SQLException {
        System.out.println(IndexStatsUtil.buildStatString(this.getStats(), "all tables"));
    }

    private Map<String, String> getIdToNameMap() throws SQLException {
        if (this.psGetIdToNameMapConglom == null) {
            this.psGetIdToNameMapConglom = this.con.prepareStatement("select CONGLOMERATEID, CONGLOMERATENAME from SYS.SYSCONGLOMERATES");
        }
        if (this.psGetIdToNameMapTable == null) {
            this.psGetIdToNameMapTable = this.con.prepareStatement("select TABLEID, TABLENAME from SYS.SYSTABLES");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = this.psGetIdToNameMapConglom.executeQuery();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        resultSet.close();
        resultSet = this.psGetIdToNameMapTable.executeQuery();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        resultSet.close();
        return hashMap;
    }

    private IdxStats[] buildStatisticsList(ResultSet resultSet, Map<String, String> map) throws SQLException {
        ArrayList<IdxStats> arrayList = new ArrayList<IdxStats>();
        while (resultSet.next()) {
            arrayList.add(new IdxStats(resultSet.getString(1), resultSet.getString(2), map.get(resultSet.getString(2)), resultSet.getString(3), map.get(resultSet.getString(3)), resultSet.getTimestamp(4), resultSet.getInt(7), resultSet.getString(8)));
        }
        resultSet.close();
        return arrayList.toArray(new IdxStats[arrayList.size()]);
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean bl) {
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{this.psGetStats, this.psGetIndexId, this.psGetStatsForIndex, this.psGetStatsForTable, this.psGetTableId, this.psGetIdToNameMapConglom, this.psGetIdToNameMapTable};
        for (int i = 0; i < preparedStatementArray.length; ++i) {
            try {
                if (preparedStatementArray[i] == null) continue;
                preparedStatementArray[i].close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (!this.con.isClosed()) {
                this.con.rollback();
            }
            if (bl) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void awaitChange(IdxStats[] idxStatsArray, long l) throws SQLException {
        HashSet<IdxStats> hashSet = new HashSet<IdxStats>(Arrays.asList(idxStatsArray));
        HashSet<IdxStats> hashSet2 = null;
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() - l2 < l || hashSet2 == null) {
            hashSet2 = new HashSet<IdxStats>(Arrays.asList(this.getStats()));
            hashSet2.retainAll(hashSet);
            if (hashSet2.isEmpty()) {
                return;
            }
            Utilities.sleep(200L);
        }
        IdxStats[] idxStatsArray2 = new IdxStats[hashSet2.size()];
        hashSet2.toArray(idxStatsArray2);
        Assert.fail((String)(idxStatsArray2.length + " missing statistics changes (timeout=" + l + "ms): " + IndexStatsUtil.buildStatString(idxStatsArray2, "<unchanged statistics>")));
    }

    public static final class IdxStats {
        private static final String NA = "<n/a>";
        public final long rows;
        public final long card;
        public final int lcols;
        public final String id;
        public final String tableId;
        public final String tableName;
        public final String indexId;
        public final String indexName;
        public final Timestamp created;

        public IdxStats(String string, String string2, String string3, String string4, String string5, Timestamp timestamp, int n, String string6) {
            this.id = string;
            this.indexId = string2;
            this.indexName = string3 != null ? string3 : NA;
            this.tableId = string4;
            this.tableName = string5 != null ? string5 : NA;
            this.created = timestamp;
            this.lcols = n;
            int n2 = string6.indexOf(61);
            int n3 = string6.indexOf(32, n2 + 2);
            int n4 = string6.indexOf(61, n3);
            this.card = Integer.parseInt(string6.substring(n2 + 1, n3).trim());
            this.rows = Integer.parseInt(string6.substring(n4 + 1).trim());
        }

        public boolean after(IdxStats idxStats) {
            return this.created.after(idxStats.created);
        }

        public boolean before(IdxStats idxStats) {
            return this.created.before(idxStats.created);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("{tableId=").append(this.tableId).append(", tableName=").append(this.tableName).append(", indexName=").append(this.indexName).append(", lcols=").append(this.lcols).append(", rows=").append(this.rows).append(", unique/card=").append(this.card).append(", created=").append(this.created).append('}');
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            IdxStats idxStats = (IdxStats)object;
            return this.id.equals(idxStats.id);
        }

        public int hashCode() {
            int n = 7;
            n = 17 * n + this.id.hashCode();
            return n;
        }
    }
}

