/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DropDatabaseSetup;

public class SupportFilesSetup
extends TestSetup {
    public static final String EXTIN = "extin";
    public static final String EXTINOUT = "extinout";
    public static final String EXTOUT = "extout";
    private String[] readOnly;
    private String[] readWrite;
    private String[] readOnlyTargetFileNames;
    private String[] readWriteTargetFileNames;

    public SupportFilesSetup(Test test) {
        this(test, null, null);
    }

    public SupportFilesSetup(Test test, String[] stringArray) {
        this(test, stringArray, null, null, null);
    }

    public SupportFilesSetup(Test test, String[] stringArray, String[] stringArray2) {
        this(test, stringArray, stringArray2, null, null);
    }

    public SupportFilesSetup(Test test, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        super(test);
        this.readOnly = stringArray;
        this.readWrite = stringArray2;
        this.readOnlyTargetFileNames = stringArray3;
        this.readWriteTargetFileNames = stringArray4;
    }

    protected void setUp() throws IOException {
        SupportFilesSetup.privCopyFiles(EXTIN, this.readOnly, this.readOnlyTargetFileNames);
        SupportFilesSetup.privCopyFiles(EXTINOUT, this.readWrite, this.readWriteTargetFileNames);
        SupportFilesSetup.privCopyFiles(EXTOUT, null, null);
    }

    protected void tearDown() {
        DropDatabaseSetup.removeDirectory(EXTIN);
        DropDatabaseSetup.removeDirectory(EXTINOUT);
        DropDatabaseSetup.removeDirectory(EXTOUT);
    }

    public static void privCopyFiles(String string, String[] stringArray, String[] stringArray2) throws IOException {
        SupportFilesSetup.copyFiles(string, stringArray, stringArray2);
    }

    private static void copyFiles(String string, String[] stringArray, String[] stringArray2) throws IOException {
        File file = new File(string);
        file.mkdir();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = "org/apache/derbyTesting/".concat(stringArray[i]);
            String string3 = stringArray2 == null ? string2.substring(string2.lastIndexOf(47) + 1) : stringArray2[i];
            URL uRL = BaseTestCase.getTestResource(string2);
            SupportFilesSetup.assertNotNull((String)string2, (Object)uRL);
            InputStream inputStream = BaseTestCase.openTestResource(uRL);
            File file2 = new File(file, string3);
            file2.delete();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[32768];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static URL getReadOnlyURL(String string) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getReadOnly(string));
    }

    public static URL getReadWriteURL(String string) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getReadWrite(string));
    }

    public static URL getWriteOnlyURL(String string) throws MalformedURLException {
        return SupportFilesSetup.getURL(SupportFilesSetup.getWriteOnly(string));
    }

    public static File getReadOnly(String string) {
        return SupportFilesSetup.getFile(EXTIN, string);
    }

    public static String getReadOnlyFileName(String string) {
        return SupportFilesSetup.getReadOnly(string).getAbsolutePath();
    }

    public static String getReadWriteFileName(String string) {
        return SupportFilesSetup.getReadWrite(string).getAbsolutePath();
    }

    public static File getReadWrite(String string) {
        return SupportFilesSetup.getFile(EXTINOUT, string);
    }

    public static File getWriteOnly(String string) {
        return SupportFilesSetup.getFile(EXTOUT, string);
    }

    private static File getFile(String string, String string2) {
        File file = new File(string);
        return new File(file, string2);
    }

    private static URL getURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static void deleteFile(String string) {
        SupportFilesSetup.deleteFile(new File(string));
    }

    public static void deleteFile(File file) {
        if (PrivilegedFileOpsForTests.exists(file)) {
            SupportFilesSetup.assertTrue((boolean)PrivilegedFileOpsForTests.delete(file));
        }
    }
}

