/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.system.oe.util.HandleCheckError;

public class OEChecks {
    private HandleCheckError errorHandler;
    private short scale = 1;
    private Connection conn = null;

    public void initialize(HandleCheckError handleCheckError, Connection connection, short s) throws Exception {
        this.errorHandler = handleCheckError;
        this.conn = connection;
        connection.setAutoCommit(false);
        this.scale = s;
    }

    public void checkAllRowCounts() throws Exception {
        this.testWarehouseRows();
        this.testStockRows();
        this.testItemRows();
        this.testCustomerRows();
        this.testDistrictRows();
        this.testOrdersRows();
        this.testNewOrdersRows();
        this.testOrderLineRows();
        this.testHistoryRows();
    }

    public void testWarehouseRows() throws Exception {
        this.checkCountStar("WAREHOUSE", this.scale);
    }

    public void testStockRows() throws Exception {
        this.checkCountStar("STOCK", 100000 * this.scale);
    }

    public void testOrdersRows() throws Exception {
        this.checkCountStar("ORDERS", 30000 * this.scale);
    }

    public void testDistrictRows() throws Exception {
        this.checkCountStar("DISTRICT", 10 * this.scale);
    }

    public void testCustomerRows() throws Exception {
        this.checkCountStar("CUSTOMER", 30000 * this.scale);
    }

    public void testItemRows() throws Exception {
        this.checkCountStar("ITEM", 100000);
    }

    public void testNewOrdersRows() throws Exception {
        this.checkCountStar("NEWORDERS", 9000 * this.scale);
    }

    public void testHistoryRows() throws Exception {
        this.checkCountStar("HISTORY", 30000 * this.scale);
    }

    public void testOrderLineRows() throws Exception {
        this.checkWithinOnePercent("ORDERLINE", 300000 * this.scale);
    }

    private void checkCountStar(String string, int n) throws Exception {
        if (n != this.rowsInTable(string)) {
            this.errorHandler.handleCheckError("ERROR:Number of rows loaded for " + string + " not correct, expected=" + n + " rows found=" + this.rowsInTable(string));
        }
    }

    private int rowsInTable(String string) throws SQLException {
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string);
        resultSet.next();
        int n = resultSet.getInt(1);
        this.conn.commit();
        resultSet.close();
        statement.close();
        return n;
    }

    private void checkWithinOnePercent(String string, int n) throws Exception {
        double d = this.rowsInTable(string);
        double d2 = (double)n * 0.99;
        double d3 = (double)n * 1.01;
        if (d < d2 || d > d3) {
            this.errorHandler.handleCheckError("ERROR! Initial rows" + d + " in " + string + " is out of range.[" + d2 + "-" + d3 + "]");
        }
    }
}

