/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public class RoleGrantDescriptor
extends TupleDescriptor
implements Provider {
    private final UUID uuid;
    private final String roleName;
    private final String grantee;
    private final String grantor;
    private boolean withAdminOption;
    private final boolean isDef;

    public RoleGrantDescriptor(DataDictionary dataDictionary, UUID uUID, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(dataDictionary);
        this.uuid = uUID;
        this.roleName = string;
        this.grantee = string2;
        this.grantor = string3;
        this.withAdminOption = bl;
        this.isDef = bl2;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public boolean isDef() {
        return this.isDef;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isWithAdminOption() {
        return this.withAdminOption;
    }

    public void setWithAdminOption(boolean bl) {
        this.withAdminOption = bl;
    }

    public String toString() {
        return "";
    }

    @Override
    public String getDescriptorType() {
        return "Role";
    }

    @Override
    public String getDescriptorName() {
        return this.roleName + " " + this.grantor + " " + this.grantee;
    }

    public void drop(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.dropRoleGrant(this.roleName, this.grantee, this.grantor, transactionController);
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String getObjectName() {
        return (this.isDef ? "CREATE ROLE: " : "GRANT ROLE: ") + this.roleName + " GRANT TO: " + this.grantee + " GRANTED BY: " + this.grantor + (this.withAdminOption ? " WITH ADMIN OPTION" : "");
    }

    @Override
    public String getClassType() {
        return "RoleGrant";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(471);
    }
}

