/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class VerifyAggregateExpressionsVisitor
implements Visitor {
    private GroupByList groupByList;

    VerifyAggregateExpressionsVisitor(GroupByList groupByList) {
        this.groupByList = groupByList;
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        if (visitable instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)visitable;
            if (this.groupByList == null) {
                throw StandardException.newException("42Y35", columnReference.getSQLColumnName());
            }
            if (this.groupByList.findGroupingColumn(columnReference) == null) {
                throw StandardException.newException("42Y36", columnReference.getSQLColumnName());
            }
        } else if (visitable instanceof SubqueryNode) {
            SubqueryNode subqueryNode = (SubqueryNode)visitable;
            if (subqueryNode.getSubqueryType() != 17 || subqueryNode.hasCorrelatedCRs()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30", new Object[0]);
            }
            HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(AggregateNode.class);
            subqueryNode.accept(hasNodeVisitor);
            if (hasNodeVisitor.hasNode()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30", new Object[0]);
            }
        }
        return visitable;
    }

    @Override
    public boolean skipChildren(Visitable visitable) throws StandardException {
        return visitable instanceof AggregateNode || visitable instanceof SubqueryNode || visitable instanceof ValueNode && this.groupByList != null && this.groupByList.findGroupingColumn((ValueNode)visitable) != null;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }
}

