/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.UndoHandler;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.AllocationActions;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerOperation;
import org.apache.derby.impl.store.raw.data.DirectActions;
import org.apache.derby.impl.store.raw.data.DirectAllocActions;
import org.apache.derby.impl.store.raw.data.EncryptOrDecryptData;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.InputStreamContainer;
import org.apache.derby.impl.store.raw.data.LoggableActions;
import org.apache.derby.impl.store.raw.data.LoggableAllocActions;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.impl.store.raw.data.RFResource;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.ReclaimSpaceHelper;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.StreamFileContainer;
import org.apache.derby.impl.store.raw.data.StreamFileContainerHandle;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.ProductVersionHolder;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class BaseDataFileFactory
implements DataFactory,
CacheableFactory,
ModuleControl,
ModuleSupportable {
    StorageFactory storageFactory;
    WritableStorageFactory writableStorageFactory;
    private long nextContainerId = System.currentTimeMillis();
    private boolean databaseEncrypted;
    private CacheManager pageCache;
    private CacheManager containerCache;
    private LogFactory logFactory;
    private ProductVersionHolder jbmsVersion;
    private String jvmVersion;
    private String osInfo;
    private String jarCPath;
    private RawStoreFactory rawStoreFactory;
    private String dataDirectory;
    private boolean throwDBlckException;
    private UUID identifier;
    private final Object freezeSemaphore = new Object();
    private boolean isFrozen;
    private int writersInProgress;
    private boolean removeStubsOK;
    private boolean isCorrupt;
    private boolean inCreateNoLog;
    private StorageRandomAccessFile fileLockOnDB;
    private StorageFile exFileLock;
    private HeaderPrintWriter istream;
    private static final String LINE = "----------------------------------------------------------------";
    boolean dataNotSyncedAtAllocation = true;
    boolean dataNotSyncedAtCheckpoint = false;
    private PageActions loggablePageActions;
    private AllocationActions loggableAllocActions;
    private boolean readOnly;
    private boolean supportsRandomAccess;
    private FileResource fileHandler;
    private Hashtable<LogInstant, Object[]> droppedTableStubInfo;
    private Hashtable<String, StorageFile> postRecoveryRemovedFiles;
    private int actionCode;
    private static final int REMOVE_TEMP_DIRECTORY_ACTION = 2;
    private static final int GET_CONTAINER_PATH_ACTION = 3;
    private static final int GET_ALTERNATE_CONTAINER_PATH_ACTION = 4;
    private static final int FIND_MAX_CONTAINER_ID_ACTION = 5;
    private static final int DELETE_IF_EXISTS_ACTION = 6;
    private static final int GET_PATH_ACTION = 7;
    private static final int POST_RECOVERY_REMOVE_ACTION = 8;
    private static final int REMOVE_STUBS_ACTION = 9;
    private static final int BOOT_ACTION = 10;
    private static final int GET_LOCK_ON_DB_ACTION = 11;
    private static final int RELEASE_LOCK_ON_DB_ACTION = 12;
    private static final int RESTORE_DATA_DIRECTORY_ACTION = 13;
    private static final int GET_CONTAINER_NAMES_ACTION = 14;
    private ContainerKey containerId;
    private boolean stub;
    private StorageFile actionFile;
    private UUID myUUID;
    private UUIDFactory uuidFactory;
    private String databaseDirectory;
    private File backupRoot;
    private String[] bfilelist;
    private UndoHandler undo_handler = null;

    public BaseDataFileFactory() {
        SecurityUtil.checkDerbyInternalsPrivilege();
    }

    @Override
    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.serviceType");
        if (string == null) {
            return false;
        }
        if (!this.handleServiceType(string)) {
            return false;
        }
        return properties.getProperty("derby.__rt.serviceDirectory") != null;
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        String string;
        String string2;
        this.jbmsVersion = BaseDataFileFactory.getMonitor().getEngineVersion();
        this.jvmVersion = BaseDataFileFactory.buildJvmVersion();
        this.osInfo = BaseDataFileFactory.buildOSinfo();
        this.jarCPath = BaseDataFileFactory.jarClassPath(this.getClass());
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        UUIDFactory uUIDFactory = BaseDataFileFactory.getMonitor().getUUIDFactory();
        this.identifier = uUIDFactory.createUUID();
        PersistentService persistentService = BaseDataFileFactory.getMonitor().getServiceType(this);
        try {
            this.storageFactory = persistentService.getStorageFactoryInstance(true, this.dataDirectory, properties.getProperty("derby.storage.tempDirectory", PropertyUtil.getSystemProperty("derby.storage.tempDirectory")), this.identifier.toANSIidentifier());
        }
        catch (IOException iOException) {
            if (bl) {
                throw StandardException.newException("XBM0H.D", iOException, this.dataDirectory);
            }
            throw StandardException.newException("XJ004.C", iOException, this.dataDirectory);
        }
        if (this.luceneLoaded() && (string2 = properties.getProperty("dataEncryption")) != null && "TRUE".equals(string2.toUpperCase())) {
            throw StandardException.newException("42XBL", new Object[0]);
        }
        if (this.storageFactory instanceof WritableStorageFactory) {
            this.writableStorageFactory = (WritableStorageFactory)this.storageFactory;
        }
        this.actionCode = 10;
        try {
            this.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = properties.getProperty("derby.database.forceDatabaseLock", PropertyUtil.getSystemProperty("derby.database.forceDatabaseLock"));
        this.throwDBlckException = Boolean.valueOf(string2 != null ? string2.trim() : string2);
        if (!this.isReadOnly()) {
            this.getJBMSLockOnDB(this.identifier, uUIDFactory, this.dataDirectory);
        }
        String string3 = null;
        string3 = properties.getProperty("createFrom");
        if (string3 == null) {
            string3 = properties.getProperty("restoreFrom");
        }
        if (string3 == null) {
            string3 = properties.getProperty("rollForwardRecoveryFrom");
        }
        if (string3 != null) {
            try {
                string = properties.getProperty("dataEncryption");
                this.databaseEncrypted = Boolean.valueOf(string);
                this.restoreDataDirectory(string3);
            }
            catch (StandardException standardException) {
                this.releaseJBMSLockOnDB();
                throw standardException;
            }
        }
        this.logMsg(LINE);
        string = this.isReadOnly() ? "D000" : "D001";
        boolean bl2 = Boolean.valueOf(properties.getProperty("derby.stream.error.logBootTrace", PropertyUtil.getSystemProperty("derby.stream.error.logBootTrace")));
        this.logMsg(String.valueOf(new Date()) + MessageService.getTextMessage(string, this.jbmsVersion, this.identifier, this.dataDirectory, this.getClass().getClassLoader(), this.jarCPath));
        this.logMsg(this.jvmVersion);
        this.logMsg(this.osInfo);
        this.logMsg("derby.system.home=" + PropertyUtil.getSystemProperty("derby.system.home"));
        String string4 = PropertyUtil.getSystemProperty("derby.stream.error.style");
        if (string4 != null) {
            this.logMsg("derby.stream.error.style=" + string4);
        }
        if ((string4 = PropertyUtil.getSystemProperty("derby.stream.error.file")) != null) {
            this.logMsg("derby.stream.error.file=" + string4);
        }
        if ((string4 = PropertyUtil.getSystemProperty("derby.stream.error.method")) != null) {
            this.logMsg("derby.stream.error.method=" + string4);
        }
        if ((string4 = PropertyUtil.getSystemProperty("derby.stream.error.field")) != null) {
            this.logMsg("derby.stream.error.field=" + string4);
        }
        if (bl2) {
            Monitor.logThrowable(new Throwable("boot trace"));
        }
        uUIDFactory = null;
        CacheFactory cacheFactory = (CacheFactory)BaseDataFileFactory.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        int n = this.getIntParameter("derby.storage.pageCacheSize", null, 1000, 40, Integer.MAX_VALUE);
        this.pageCache = cacheFactory.newCacheManager(this, "PageCache", n / 2, n);
        int n2 = this.getIntParameter("derby.storage.fileCacheSize", null, 100, 2, Integer.MAX_VALUE);
        this.containerCache = cacheFactory.newCacheManager(this, "ContainerCache", n2 / 2, n2);
        this.pageCache.registerMBean(this.dataDirectory);
        this.containerCache.registerMBean(this.dataDirectory);
        if (bl) {
            String string5 = properties.getProperty("derby.__rt.storage.createWithNoLog");
            this.inCreateNoLog = string5 != null && Boolean.valueOf(string5) != false;
        }
        this.droppedTableStubInfo = new Hashtable();
        if ("test".equalsIgnoreCase(PropertyUtil.getSystemProperty("derby.system.durability"))) {
            this.dataNotSyncedAtCheckpoint = true;
            Monitor.logMessage(MessageService.getTextMessage("D013", "derby.system.durability", "test"));
        }
        this.fileHandler = new RFResource(this);
    }

    @Override
    public void stop() {
        DaemonService daemonService;
        boolean bl = false;
        if (this.rawStoreFactory != null && (daemonService = this.rawStoreFactory.getDaemon()) != null) {
            daemonService.stop();
        }
        boolean bl2 = PropertyUtil.getSystemBoolean("derby.stream.error.logBootTrace");
        this.logMsg(LINE);
        this.logMsg(String.valueOf(new Date()) + MessageService.getTextMessage("D002", this.getIdentifier(), this.getRootDirectory(), this.getClass().getClassLoader()));
        if (bl2) {
            Monitor.logThrowable(new Throwable("shutdown trace"));
        }
        if (!this.isCorrupt) {
            try {
                if (this.pageCache != null && this.containerCache != null) {
                    this.pageCache.shutdown();
                    this.containerCache.shutdown();
                    bl = true;
                }
            }
            catch (StandardException standardException) {
                standardException.printStackTrace(this.istream.getPrintWriter());
            }
        }
        this.removeTempDirectory();
        if (this.isReadOnly()) {
            if (this.storageFactory != null) {
                this.storageFactory.shutdown();
            }
            return;
        }
        if (this.removeStubsOK && bl) {
            this.removeStubs();
        }
        this.releaseJBMSLockOnDB();
        if (this.writableStorageFactory != null) {
            this.writableStorageFactory.shutdown();
        }
    }

    @Override
    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.pageCache) {
            StoredPage storedPage = new StoredPage();
            storedPage.setFactory(this);
            return storedPage;
        }
        return this.newContainerObject();
    }

    @Override
    public void createFinished() throws StandardException {
        if (!this.inCreateNoLog) {
            throw StandardException.newException("XSDG5.D", new Object[0]);
        }
        this.checkpoint();
        this.inCreateNoLog = false;
    }

    @Override
    public ContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n, false);
    }

    @Override
    public RawContainerHandle openDroppedContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n) throws StandardException {
        return this.openContainer(rawTransaction, containerKey, lockingPolicy, n |= 0x400, true);
    }

    private RawContainerHandle openContainer(RawTransaction rawTransaction, ContainerKey containerKey, LockingPolicy lockingPolicy, int n, boolean bl) throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = (n & 0x80) == 0;
        if ((n & 0x40) != 0) {
            BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, containerKey, lockingPolicy, n);
            if (baseContainerHandle.useContainer(true, bl2)) {
                return baseContainerHandle;
            }
            return null;
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.find(containerKey);
        if (fileContainer == null) {
            return null;
        }
        if (containerKey.getSegmentId() == -1L) {
            n = (n & 0x800) == 2048 ? (n |= 1) : (n |= 0x101);
            lockingPolicy = rawTransaction.newLockingPolicy(0, 0, true);
        } else {
            if (this.inCreateNoLog) {
                n |= 3;
            } else if (this.logFactory.logArchived() || this.logFactory.inReplicationMasterMode()) {
                n &= 0xFFFFFFFC;
            } else if (!((n & 1) != 1 && (n & 2) != 2 || rawTransaction.blockBackup(false))) {
                n &= 0xFFFFFFFC;
            }
            if ((n & 1) == 1 && (n & 2) == 0) {
                n |= 0x200;
            }
        }
        PageActions pageActions = null;
        AllocationActions allocationActions = null;
        if ((n & 4) == 4) {
            if ((n & 1) == 0) {
                pageActions = this.getLoggablePageActions();
                allocationActions = this.getLoggableAllocationActions();
            } else {
                pageActions = new DirectActions();
                allocationActions = new DirectAllocActions();
            }
        }
        BaseContainerHandle baseContainerHandle = new BaseContainerHandle(this.getIdentifier(), rawTransaction, pageActions, allocationActions, lockingPolicy, fileContainer, n);
        try {
            if (!baseContainerHandle.useContainer(bl, bl2)) {
                this.containerCache.release(fileContainer);
                return null;
            }
        }
        catch (StandardException standardException) {
            this.containerCache.release(fileContainer);
            throw standardException;
        }
        return baseContainerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addContainer(RawTransaction rawTransaction, long l, long l2, int n, Properties properties, int n2) throws StandardException {
        long l3 = l2 != 0L ? l2 : this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l3);
        boolean bl = l == -1L;
        ContainerHandle containerHandle = null;
        LockingPolicy lockingPolicy = null;
        if (!bl) {
            if (this.isReadOnly()) {
                throw StandardException.newException("40XD1", new Object[0]);
            }
            lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
            containerHandle = rawTransaction.openContainer(containerKey, lockingPolicy, 68);
        }
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, properties);
        ContainerHandle containerHandle2 = null;
        Page page = null;
        try {
            if (bl && (n2 & 2) == 2) {
                n |= 0x800;
            }
            containerHandle2 = rawTransaction.openContainer(containerKey, null, 4 | n);
            if (!bl) {
                RawContainerHandle rawContainerHandle = (RawContainerHandle)containerHandle2;
                ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 1);
                rawContainerHandle.preDirty(true);
                try {
                    rawTransaction.logAndDo(containerOperation);
                    this.flush(rawTransaction.getLastLogInstant());
                }
                finally {
                    rawContainerHandle.preDirty(false);
                }
            }
            page = containerHandle2.addPage();
        }
        finally {
            if (page != null) {
                page.unlatch();
                page = null;
            }
            this.containerCache.release(fileContainer);
            if (containerHandle2 != null) {
                containerHandle2.close();
                containerHandle2 = null;
            }
            if (!bl) {
                lockingPolicy.unlockContainer(rawTransaction, containerHandle);
            }
        }
        return l3;
    }

    @Override
    public long addAndLoadStreamContainer(RawTransaction rawTransaction, long l, Properties properties, RowSource rowSource) throws StandardException {
        long l2 = this.getNextId();
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this, properties);
        streamFileContainer.load(rowSource);
        return l2;
    }

    @Override
    public StreamContainerHandle openStreamContainer(RawTransaction rawTransaction, long l, long l2, boolean bl) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        StreamFileContainer streamFileContainer = new StreamFileContainer(containerKey, this);
        if ((streamFileContainer = streamFileContainer.open(false)) == null) {
            return null;
        }
        StreamFileContainerHandle streamFileContainerHandle = new StreamFileContainerHandle(this.getIdentifier(), rawTransaction, streamFileContainer, bl);
        if (streamFileContainerHandle.useContainer()) {
            return streamFileContainerHandle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropStreamContainer(RawTransaction rawTransaction, long l, long l2) throws StandardException {
        boolean bl = l == -1L;
        try (StreamContainerHandle streamContainerHandle = null;){
            ContainerKey containerKey = new ContainerKey(l, l2);
            rawTransaction.notifyObservers(containerKey);
            streamContainerHandle = rawTransaction.openStreamContainer(l, l2, false);
            if (bl && streamContainerHandle != null) {
                streamContainerHandle.removeContainer();
                return;
            }
        }
    }

    @Override
    public void reCreateContainerForRedoRecovery(RawTransaction rawTransaction, long l, long l2, ByteArray byteArray) throws StandardException {
        ContainerKey containerKey = new ContainerKey(l, l2);
        FileContainer fileContainer = (FileContainer)this.containerCache.create(containerKey, byteArray);
        this.containerCache.release(fileContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropContainer(RawTransaction rawTransaction, ContainerKey containerKey) throws StandardException {
        block14: {
            boolean bl = containerKey.getSegmentId() == -1L;
            LockingPolicy lockingPolicy = null;
            if (!bl) {
                if (this.isReadOnly()) {
                    throw StandardException.newException("40XD1", new Object[0]);
                }
                lockingPolicy = rawTransaction.newLockingPolicy(2, 5, true);
            }
            rawTransaction.notifyObservers(containerKey);
            try (RawContainerHandle rawContainerHandle = (RawContainerHandle)rawTransaction.openContainer(containerKey, lockingPolicy, 4);){
                if (rawContainerHandle == null || rawContainerHandle.getContainerStatus() != 1) {
                    if (bl) {
                        if (rawContainerHandle != null) {
                            rawContainerHandle.removeContainer(null);
                        }
                        return;
                    }
                    throw StandardException.newException("40XD2", containerKey);
                }
                if (bl) {
                    rawContainerHandle.dropContainer(null, true);
                    rawContainerHandle.removeContainer(null);
                    break block14;
                }
                ContainerOperation containerOperation = new ContainerOperation(rawContainerHandle, 2);
                rawContainerHandle.preDirty(true);
                try {
                    rawTransaction.logAndDo(containerOperation);
                }
                finally {
                    rawContainerHandle.preDirty(false);
                }
                ReclaimSpace reclaimSpace = new ReclaimSpace(1, containerKey, (DataFactory)this, true);
                rawTransaction.addPostCommitWork(reclaimSpace);
            }
        }
    }

    @Override
    public void checkpoint() throws StandardException {
        this.pageCache.cleanAll();
        this.containerCache.cleanAll();
    }

    @Override
    public void idle() throws StandardException {
        this.pageCache.ageOut();
        this.containerCache.ageOut();
    }

    @Override
    public void setRawStoreFactory(RawStoreFactory rawStoreFactory, boolean bl, Properties properties) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        this.bootLogFactory(bl, properties);
    }

    @Override
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Override
    public int reclaimSpace(Serviceable serviceable, ContextManager contextManager) throws StandardException {
        if (serviceable == null) {
            return 1;
        }
        Transaction transaction = this.rawStoreFactory.findUserTransaction(contextManager, "SystemTransaction");
        return ReclaimSpaceHelper.reclaimSpace(this, (RawTransaction)transaction, (ReclaimSpace)serviceable);
    }

    @Override
    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = !this.isCorrupt;
        this.isCorrupt = true;
        if (this.getLogFactory() != null) {
            this.getLogFactory().markCorrupt(standardException);
        }
        if (bl) {
            if (this.pageCache != null) {
                this.pageCache.discard(null);
            }
            if (this.containerCache != null) {
                this.containerCache.discard(null);
            }
            this.pageCache = null;
            this.containerCache = null;
            this.releaseJBMSLockOnDB();
        }
        return standardException;
    }

    @Override
    public FileResource getFileHandler() {
        return this.fileHandler;
    }

    @Override
    public void removeStubsOK() {
        this.removeStubsOK = true;
    }

    @Override
    public void setUndoInsertEventHandler(UndoHandler undoHandler) {
        this.undo_handler = undoHandler;
    }

    protected void insertUndoNotify(RawTransaction rawTransaction, PageKey pageKey) throws StandardException {
        if (this.undo_handler != null) {
            this.undo_handler.insertUndoNotify(rawTransaction, pageKey);
        }
    }

    public int getIntParameter(String string, Properties properties, int n, int n2, int n3) {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = PropertyUtil.getSystemProperty(string);
        }
        if (string2 != null) {
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= n2 && n4 <= n3) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    CacheManager getContainerCache() {
        return this.containerCache;
    }

    CacheManager getPageCache() {
        return this.pageCache;
    }

    void flush(LogInstant logInstant) throws StandardException {
        this.getLogFactory().flush(logInstant);
    }

    LogFactory getLogFactory() {
        return this.logFactory;
    }

    RawStoreFactory getRawStoreFactory() {
        return this.rawStoreFactory;
    }

    @Override
    public String getRootDirectory() {
        return this.dataDirectory;
    }

    Cacheable newContainerObject() {
        if (this.supportsRandomAccess) {
            return this.newRAFContainer(this);
        }
        return new InputStreamContainer(this);
    }

    protected Cacheable newRAFContainer(BaseDataFileFactory baseDataFileFactory) {
        return new RAFContainer(baseDataFileFactory);
    }

    private PageActions getLoggablePageActions() throws StandardException {
        if (this.loggablePageActions == null) {
            this.loggablePageActions = new LoggableActions();
        }
        return this.loggablePageActions;
    }

    private AllocationActions getLoggableAllocationActions() {
        if (this.loggableAllocActions == null) {
            this.loggableAllocActions = new LoggableAllocActions();
        }
        return this.loggableAllocActions;
    }

    private synchronized void removeTempDirectory() {
        if (this.storageFactory != null) {
            this.actionCode = 2;
            try {
                this.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public StorageFile getContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StorageFile getContainerPath(ContainerKey containerKey, boolean bl, int n) {
        this.actionCode = n;
        try {
            this.containerId = containerKey;
            this.stub = bl;
            try {
                StorageFile storageFile = (StorageFile)this.run();
                return storageFile;
            }
            catch (Exception exception) {
                StorageFile storageFile = null;
                this.containerId = null;
                return storageFile;
            }
        }
        finally {
            this.containerId = null;
        }
    }

    public StorageFile getAlternateContainerPath(ContainerKey containerKey, boolean bl) {
        return this.getContainerPath(containerKey, bl, 4);
    }

    private synchronized void removeStubs() {
        if (this.storageFactory != null) {
            this.actionCode = 9;
            try {
                this.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stubFileToRemoveAfterCheckPoint(StorageFile storageFile, LogInstant logInstant, Object object) {
        if (this.droppedTableStubInfo != null) {
            Object[] objectArray = new Object[]{storageFile, object};
            this.droppedTableStubInfo.put(logInstant, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDroppedContainerFileStubs(LogInstant logInstant) throws StandardException {
        if (this.droppedTableStubInfo != null) {
            Hashtable<LogInstant, Object[]> hashtable = this.droppedTableStubInfo;
            synchronized (hashtable) {
                Enumeration<LogInstant> enumeration = this.droppedTableStubInfo.keys();
                while (enumeration.hasMoreElements()) {
                    LogInstant logInstant2 = enumeration.nextElement();
                    if (!logInstant2.lessThan(logInstant)) continue;
                    Object[] objectArray = this.droppedTableStubInfo.get(logInstant2);
                    Object object = objectArray[1];
                    Cacheable cacheable = this.containerCache.findCached(object);
                    if (cacheable != null) {
                        this.containerCache.remove(cacheable);
                    }
                    BaseDataFileFactory baseDataFileFactory = this;
                    synchronized (baseDataFileFactory) {
                        this.actionFile = (StorageFile)objectArray[0];
                        this.actionCode = 6;
                        try {
                            if (this.run() != null) {
                                this.droppedTableStubInfo.remove(logInstant2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private synchronized long findMaxContainerId() {
        this.actionCode = 5;
        try {
            return (Long)this.run();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private void bootLogFactory(boolean bl, Properties properties) throws StandardException {
        if (this.isReadOnly()) {
            properties.put("derby.__rt.storage.log", "readonly");
        }
        this.logFactory = (LogFactory)BaseDataFileFactory.bootServiceModule(bl, this, this.rawStoreFactory.getLogFactoryModule(), properties);
    }

    private boolean handleServiceType(String string) {
        try {
            PersistentService persistentService = BaseDataFileFactory.getMonitor().getServiceProvider(string);
            return persistentService != null && persistentService.hasStorageFactory();
        }
        catch (StandardException standardException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJBMSLockOnDB(UUID uUID, UUIDFactory uUIDFactory, String string) throws StandardException {
        if (this.fileLockOnDB != null) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 11;
            this.myUUID = uUID;
            this.uuidFactory = uUIDFactory;
            this.databaseDirectory = string;
            try {
                this.run();
            }
            catch (IOException iOException) {
                throw StandardException.plainWrapException(iOException);
            }
            finally {
                this.myUUID = null;
                this.uuidFactory = null;
                this.databaseDirectory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privGetJBMSLockOnDB() throws StandardException {
        Object[] objectArray;
        boolean bl = false;
        String string = null;
        StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
        try {
            if (storageFile.exists()) {
                bl = true;
                this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                try {
                    string = this.fileLockOnDB.readUTF();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                this.fileLockOnDB.close();
                this.fileLockOnDB = null;
                if (!storageFile.delete()) {
                    throw StandardException.newException("XSDB6.D", this.databaseDirectory);
                }
            }
            this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
            storageFile.limitAccessToOwner();
            this.fileLockOnDB.writeUTF(this.myUUID.toString());
            this.fileLockOnDB.sync();
            this.fileLockOnDB.seek(0L);
            objectArray = this.uuidFactory.recreateUUID(this.fileLockOnDB.readUTF());
            if (!objectArray.equals(this.myUUID)) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
        catch (IOException iOException) {
            this.readOnly = true;
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this.fileLockOnDB = null;
            return;
        }
        if (storageFile.delete()) {
            objectArray = new Object[]{this.myUUID, this.databaseDirectory, string};
            int n = 0;
            if (!this.throwDBlckException) {
                this.exFileLock = this.storageFactory.newStorageFile("dbex.lck");
                n = this.exFileLock.getExclusiveFileLock();
            }
            if (n == 0 && bl && !this.throwDBlckException) {
                String string2 = MessageService.getTextMessage("XSDB7.D", objectArray);
                this.logMsg(string2);
                System.err.println(string2);
            }
            try {
                if (this.fileLockOnDB != null) {
                    this.fileLockOnDB.close();
                }
                this.fileLockOnDB = storageFile.getRandomAccessFile("rw");
                storageFile.limitAccessToOwner();
                this.fileLockOnDB.writeUTF(this.myUUID.toString());
                this.fileLockOnDB.sync();
                this.fileLockOnDB.close();
            }
            catch (IOException iOException) {
                try {
                    this.fileLockOnDB.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            finally {
                this.fileLockOnDB = null;
            }
            if (bl && this.throwDBlckException) {
                throw StandardException.newException("XSDB8.D", objectArray);
            }
            if (n == 2) {
                throw StandardException.newException("XSDB6.D", this.databaseDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJBMSLockOnDB() {
        if (this.isReadOnly()) {
            return;
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 12;
            try {
                this.run();
            }
            catch (Exception exception) {
            }
            finally {
                this.fileLockOnDB = null;
            }
        }
    }

    private void privReleaseJBMSLockOnDB() throws IOException {
        if (this.fileLockOnDB != null) {
            this.fileLockOnDB.close();
        }
        if (this.storageFactory != null) {
            StorageFile storageFile = this.storageFactory.newStorageFile("db.lck");
            storageFile.delete();
        }
        if (this.exFileLock != null) {
            this.exFileLock.releaseExclusiveFileLock();
        }
    }

    private void logMsg(String string) {
        if (this.istream == null) {
            this.istream = Monitor.getStream();
        }
        this.istream.println(string);
    }

    @Override
    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    @Override
    public void setDatabaseEncrypted(boolean bl) {
        this.databaseEncrypted = bl;
    }

    @Override
    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3, bl);
    }

    @Override
    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    @Override
    public void decryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        EncryptOrDecryptData encryptOrDecryptData = new EncryptOrDecryptData(this);
        encryptOrDecryptData.decryptAllContainers(rawTransaction);
    }

    @Override
    public void encryptAllContainers(RawTransaction rawTransaction) throws StandardException {
        EncryptOrDecryptData encryptOrDecryptData = new EncryptOrDecryptData(this);
        encryptOrDecryptData.encryptAllContainers(rawTransaction);
    }

    @Override
    public void removeOldVersionOfContainers() throws StandardException {
        EncryptOrDecryptData encryptOrDecryptData = new EncryptOrDecryptData(this);
        encryptOrDecryptData.removeOldVersionOfContainers();
    }

    private static String jarClassPath(Class clazz) {
        CodeSource codeSource = null;
        codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null || codeSource.getLocation() == null) {
            return null;
        }
        URL uRL = codeSource.getLocation();
        return uRL.toString();
    }

    private static String buildOSinfo() {
        Object object = "";
        String string = PropertyUtil.getSystemProperty("os.name");
        if (string != null) {
            object = "os.name=" + string + "\n";
        }
        if ((string = PropertyUtil.getSystemProperty("os.arch")) != null) {
            object = (String)object + "os.arch=" + string + "\n";
        }
        if ((string = PropertyUtil.getSystemProperty("os.version")) != null) {
            object = (String)object + "os.version=" + string;
        }
        return object;
    }

    private static String buildJvmVersion() {
        Object object = "";
        String string = PropertyUtil.getSystemProperty("java.vendor");
        if (string != null) {
            object = "java.vendor=" + string;
        }
        if ((string = PropertyUtil.getSystemProperty("java.runtime.version")) != null) {
            object = (String)object + "\njava.runtime.version=" + string;
        }
        if ((string = PropertyUtil.getSystemProperty("java.fullversion")) != null) {
            object = (String)object + "\njava.fullversion=" + string;
        }
        if ((string = PropertyUtil.getSystemProperty("user.dir")) != null) {
            object = (String)object + "\nuser.dir=" + string;
        }
        return object;
    }

    @Override
    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public String getVersionedName(String string, long l) {
        return string.concat(".G".concat(Long.toString(l)));
    }

    @Override
    public long getMaxContainerId() throws StandardException {
        return this.findMaxContainerId();
    }

    synchronized long getNextId() {
        return this.nextContainerId++;
    }

    int random() {
        return this.databaseEncrypted ? this.rawStoreFactory.random() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileToRemove(StorageFile storageFile, boolean bl) {
        if (this.postRecoveryRemovedFiles == null) {
            this.postRecoveryRemovedFiles = new Hashtable();
        }
        String string = null;
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 7;
            this.actionFile = storageFile;
            try {
                string = (String)this.run();
            }
            catch (Exception exception) {
            }
            finally {
                this.actionFile = null;
            }
        }
        if (bl) {
            this.postRecoveryRemovedFiles.put(string, storageFile);
        } else {
            this.postRecoveryRemovedFiles.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRecovery() throws StandardException {
        DaemonService daemonService = this.rawStoreFactory.getDaemon();
        if (daemonService == null) {
            return;
        }
        if (this.postRecoveryRemovedFiles != null) {
            BaseDataFileFactory baseDataFileFactory = this;
            synchronized (baseDataFileFactory) {
                this.actionCode = 8;
                try {
                    this.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.postRecoveryRemovedFiles = null;
        }
    }

    @Override
    public void setupCacheCleaner(DaemonService daemonService) {
        this.containerCache.useDaemonService(daemonService);
        this.pageCache.useDaemonService(daemonService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezePersistentStore() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            if (this.isFrozen) {
                throw StandardException.newException("XSRS0.S", new Object[0]);
            }
            this.isFrozen = true;
            try {
                while (this.writersInProgress > 0) {
                    try {
                        this.freezeSemaphore.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.isFrozen = false;
                this.freezeSemaphore.notifyAll();
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreezePersistentStore() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            this.isFrozen = false;
            this.freezeSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInProgress() throws StandardException {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            while (this.isFrozen) {
                try {
                    this.freezeSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            ++this.writersInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFinished() {
        Object object = this.freezeSemaphore;
        synchronized (object) {
            --this.writersInProgress;
            this.freezeSemaphore.notifyAll();
        }
    }

    @Override
    public void backupDataFiles(Transaction transaction, File file) throws StandardException {
        String[] stringArray = this.getContainerNames();
        if (stringArray != null) {
            LockingPolicy lockingPolicy = transaction.newLockingPolicy(0, 0, false);
            long l = 0L;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                long l2;
                try {
                    l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                }
                catch (Throwable throwable) {
                    continue;
                }
                ContainerKey containerKey = new ContainerKey(l, l2);
                RawContainerHandle rawContainerHandle = this.openDroppedContainer((RawTransaction)transaction, containerKey, lockingPolicy, 8);
                if (rawContainerHandle == null) continue;
                rawContainerHandle.backupContainer(file.getPath());
                rawContainerHandle.close();
            }
        }
    }

    synchronized String[] getContainerNames() {
        this.actionCode = 14;
        try {
            return (String[])this.run();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDataDirectory(String string) throws StandardException {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2;
                File file2;
                boolean bl3;
                if (!stringArray[i].startsWith("seg") || !(bl3 = Boolean.valueOf((file2 = new File(file, stringArray[i])).exists()).booleanValue()) || !(bl2 = Boolean.valueOf(file2.isDirectory()).booleanValue())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw StandardException.newException("XSDG6.D", file);
            }
        } else {
            throw StandardException.newException("XSDG6.D", file);
        }
        BaseDataFileFactory baseDataFileFactory = this;
        synchronized (baseDataFileFactory) {
            this.actionCode = 13;
            this.backupRoot = file;
            this.bfilelist = stringArray;
            try {
                this.run();
            }
            catch (IOException iOException) {
                throw StandardException.plainWrapException(iOException);
            }
            finally {
                this.backupRoot = null;
                this.bfilelist = null;
            }
        }
    }

    private void privRestoreDataDirectory() throws StandardException {
        StorageFile storageFile;
        int n;
        StorageFile storageFile2 = this.storageFactory.newStorageFile(null);
        String[] stringArray = storageFile2.list();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("seg") && !"LUCENE".equals(stringArray[n]) || (storageFile = this.storageFactory.newStorageFile(stringArray[n])).deleteAll()) continue;
                throw StandardException.newException("XSDG7.D", storageFile);
            }
        }
        for (n = 0; n < this.bfilelist.length; ++n) {
            StorageFile storageFile3;
            File file;
            if (this.bfilelist[n].startsWith("seg") || "LUCENE".equals(this.bfilelist[n])) {
                file = new File(this.backupRoot, this.bfilelist[n]);
                storageFile = this.storageFactory.newStorageFile(this.bfilelist[n]);
                if (FileUtil.copyDirectory(this.writableStorageFactory, file, storageFile)) continue;
                throw StandardException.newException("XSDG8.D", file, storageFile);
            }
            if (!this.databaseEncrypted || !this.bfilelist[n].startsWith("verifyKey.dat") || FileUtil.copyFile(this.writableStorageFactory, file = new File(this.backupRoot, this.bfilelist[n]), storageFile3 = this.storageFactory.newStorageFile(this.bfilelist[n]))) continue;
            throw StandardException.newException("XSDG8.D", this.bfilelist[n], storageFile3);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean luceneLoaded() throws StandardException {
        StorageFactory storageFactory = this.getStorageFactory();
        StorageFile storageFile = storageFactory.newStorageFile("LUCENE");
        return storageFile.exists();
    }

    @Override
    public StorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public final Object run() throws IOException, StandardException {
        switch (this.actionCode) {
            case 10: {
                this.readOnly = this.storageFactory.isReadOnlyDatabase();
                this.supportsRandomAccess = this.storageFactory.supportsRandomAccess();
                return null;
            }
            case 2: {
                StorageFile storageFile = this.storageFactory.getTempDir();
                if (storageFile != null) {
                    storageFile.deleteAll();
                }
                return null;
            }
            case 3: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("seg");
                stringBuffer.append(this.containerId.getSegmentId());
                stringBuffer.append(this.storageFactory.getSeparator());
                if (this.actionCode == 3) {
                    stringBuffer.append(this.stub ? (char)'d' : 'c');
                    stringBuffer.append(Long.toHexString(this.containerId.getContainerId()));
                    stringBuffer.append(".dat");
                } else {
                    stringBuffer.append(this.stub ? (char)'D' : 'C');
                    stringBuffer.append(Long.toHexString(this.containerId.getContainerId()));
                    stringBuffer.append(".DAT");
                }
                return this.storageFactory.newStorageFile(stringBuffer.toString());
            }
            case 9: {
                char c = this.storageFactory.getSeparator();
                StorageFile storageFile = this.storageFactory.newStorageFile(null);
                String[] stringArray = storageFile.list();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    StorageFile storageFile2;
                    if (!stringArray[i].startsWith("seg") || !(storageFile2 = this.storageFactory.newStorageFile(storageFile, stringArray[i])).exists() || !storageFile2.isDirectory()) continue;
                    String[] stringArray2 = storageFile2.list();
                    for (int j = stringArray2.length - 1; j >= 0; --j) {
                        if (!stringArray2[j].startsWith("D") && !stringArray2[j].startsWith("d")) continue;
                        StorageFile storageFile3 = this.storageFactory.newStorageFile(storageFile, stringArray[i] + c + stringArray2[j]);
                        boolean bl = storageFile3.delete();
                    }
                }
                break;
            }
            case 5: {
                long l = 1L;
                StorageFile storageFile = this.storageFactory.newStorageFile("seg0");
                if (storageFile.exists() && storageFile.isDirectory()) {
                    String[] stringArray = storageFile.list();
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        try {
                            long l2 = Long.parseLong(stringArray[i].substring(1, stringArray[i].length() - 4), 16);
                            if (l2 <= l) continue;
                            l = l2;
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return l;
            }
            case 6: {
                boolean bl = this.actionFile.exists() && this.actionFile.delete();
                this.actionFile = null;
                return bl ? this : null;
            }
            case 7: {
                String string = this.actionFile.getPath();
                this.actionFile = null;
                return string;
            }
            case 8: {
                Enumeration<StorageFile> enumeration = this.postRecoveryRemovedFiles.elements();
                while (enumeration.hasMoreElements()) {
                    StorageFile storageFile = enumeration.nextElement();
                    if (!storageFile.exists()) continue;
                    boolean bl = storageFile.delete();
                }
                return null;
            }
            case 11: {
                this.privGetJBMSLockOnDB();
                return null;
            }
            case 12: {
                this.privReleaseJBMSLockOnDB();
                return null;
            }
            case 13: {
                this.privRestoreDataDirectory();
                return null;
            }
            case 14: {
                StorageFile storageFile = this.storageFactory.newStorageFile("seg0");
                if (storageFile.exists() && storageFile.isDirectory()) {
                    return storageFile.list();
                }
                return null;
            }
        }
        return null;
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object startSystemModule(String string) throws StandardException {
        return Monitor.startSystemModule(string);
    }

    private static Object bootServiceModule(boolean bl, Object object, String string, Properties properties) throws StandardException {
        return Monitor.bootServiceModule(bl, object, string, properties);
    }
}

