/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCallableStatement;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetDatabaseMetaData;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class NetConnection
extends ClientConnection {
    private static final MessageUtil msgutil = SqlException.getMessageUtil();
    protected NetAgent netAgent_;
    private final ClientPooledConnection pooledConnection_;
    private final boolean closeStatementsOnClose;
    protected int targetAgent_ = 7;
    protected int targetCmntcpip_ = 5;
    protected int targetRdb_ = 7;
    int targetSecmgr_ = 7;
    protected int targetCmnappc_ = 0;
    protected int targetXamgr_ = 7;
    protected int targetSyncptmgr_ = 0;
    protected int targetRsyncmgr_ = 0;
    protected int targetUnicodemgr_ = 1208;
    private String extnam_;
    String targetSrvclsnm_;
    String targetSrvrlslv_;
    private transient byte[] publicKey_;
    private transient byte[] targetPublicKey_;
    private transient byte[] sourceSeed_;
    private transient byte[] targetSeed_;
    private ByteBuffer prddta_;
    byte[] crrtkn_;
    private int targetSecmec_;
    private int securityMechanism_;
    private transient char[] deferredResetPassword_ = null;
    private boolean connectionNull = false;
    protected NetXAResource xares_ = null;
    private List<Xid> indoubtTransactions_ = null;
    protected int currXACallInfoOffset_ = 0;
    private PreparedStatement isValidStmt;

    private void setDeferredResetPassword(String string) {
        this.deferredResetPassword_ = string == null ? null : this.flipBits(string.toCharArray());
    }

    private String getDeferredResetPassword() {
        if (this.deferredResetPassword_ == null) {
            return null;
        }
        String string = new String(this.flipBits(this.deferredResetPassword_));
        this.flipBits(this.deferredResetPassword_);
        return string;
    }

    NetConnection(LogWriter logWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        super(logWriter, n, string, n2, string2, properties);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        String string3 = BasicClientDataSource.getPassword(properties);
        this.securityMechanism_ = BasicClientDataSource.getSecurityMechanism(properties);
        this.flowConnect(string3, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        }
        this.netAgent_.setTimeout(0);
    }

    NetConnection(LogWriter logWriter, String string, String string2, BasicClientDataSource basicClientDataSource, int n, boolean bl) throws SqlException {
        super(logWriter, string, string2, bl, basicClientDataSource);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(string2, basicClientDataSource, bl);
    }

    NetConnection(LogWriter logWriter, String string, String string2, BasicClientDataSource basicClientDataSource, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(logWriter, string, string2, bl, basicClientDataSource);
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(string2, basicClientDataSource, bl);
        this.pooledConnection_ = clientPooledConnection;
        this.closeStatementsOnClose = !clientPooledConnection.isStatementPoolingEnabled();
    }

    private void initialize(String string, BasicClientDataSource basicClientDataSource, boolean bl) throws SqlException {
        this.securityMechanism_ = basicClientDataSource.getSecurityMechanism(string);
        this.setDeferredResetPassword(string);
        this.checkDatabaseName();
        this.dataSource_ = basicClientDataSource;
        this.isXAConnection_ = bl;
        this.flowConnect(string, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("XCY00.S"), "databaseName", this.databaseName_));
        }
        this.netAgent_.setTimeout(0);
    }

    private void resetNetConnection(LogWriter logWriter) throws SqlException {
        super.resetConnection(logWriter);
        this.targetSrvclsnm_ = null;
        this.targetSrvrlslv_ = null;
        this.publicKey_ = null;
        this.targetPublicKey_ = null;
        this.sourceSeed_ = null;
        this.targetSeed_ = null;
        this.targetSecmec_ = 0;
        this.resetConnectionAtFirstSql_ = false;
        boolean bl = this.flowReconnect(this.getDeferredResetPassword(), this.securityMechanism_);
        this.completeReset(bl);
        this.netAgent_.setTimeout(0);
    }

    @Override
    protected void reset_(LogWriter logWriter) throws SqlException {
        if (this.inUnitOfWork_) {
            throw new SqlException(logWriter, new ClientMessageId("XN001.S"), new Object[0]);
        }
        this.resetNetConnection(logWriter);
    }

    private void completeReset(boolean bl) throws SqlException {
        super.completeReset(bl, this.closeStatementsOnClose, this.xares_);
    }

    private void flowConnect(String string, int n) throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        this.setDeferredResetPassword(string);
        try {
            switch (n) {
                case 3: {
                    this.checkUserPassword(this.user_, string);
                    this.flowUSRIDPWDconnect(string);
                    break;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.flowUSRIDONLconnect();
                    break;
                }
                case 7: {
                    this.checkUserPassword(this.user_, string);
                    this.flowUSRENCPWDconnect(string);
                    break;
                }
                case 9: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRIDPWDconnect(string);
                    break;
                }
                case 12: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRIDDTAconnect();
                    break;
                }
                case 13: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRPWDDTAconnect(string);
                    break;
                }
                case 8: {
                    this.checkUserPassword(this.user_, string);
                    this.flowUSRSSBPWDconnect(string);
                    break;
                }
                default: {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), n);
                }
            }
        }
        catch (Throwable throwable) {
            this.open_ = false;
            this.handleLoginTimeout(throwable);
            SqlException sqlException = throwable instanceof SqlException ? (SqlException)throwable : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), throwable, throwable.getClass().getName(), throwable.getMessage());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    private void flowSimpleConnect() throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        try {
            this.flowServerAttributes();
        }
        catch (Throwable throwable) {
            this.open_ = false;
            this.handleLoginTimeout(throwable);
            SqlException sqlException = throwable instanceof SqlException ? (SqlException)throwable : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), throwable, throwable.getClass().getName(), throwable.getMessage());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    private void handleLoginTimeout(Throwable throwable) throws SqlException {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof SocketTimeoutException)) continue;
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XBDA0.C.1"), throwable, new Object[0]);
        }
    }

    private boolean flowReconnect(String string, int n) throws SqlException {
        this.constructExtnam();
        this.constructPrddta();
        this.checkSecmgrForSecmecSupport(n);
        try {
            switch (n) {
                case 3: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.resetConnectionAtFirstSql_ = true;
                    return true;
                }
                case 7: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 9: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 12: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 13: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 8: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), n);
        }
        catch (SqlException sqlException) {
            this.open_ = false;
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    private void flowUSRIDPWDconnect(String string) throws SqlException {
        this.flowServerAttributesAndKeyExchange(3, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, string, null, null);
    }

    private void flowUSRIDONLconnect() throws SqlException {
        this.flowServerAttributesAndKeyExchange(4, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, null);
    }

    private void flowUSRENCPWDconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(7);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(7, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(string));
    }

    private void flowEUSRIDPWDconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(9, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(string));
    }

    private void flowEUSRIDDTAconnect() throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(12, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), null);
    }

    private void flowEUSRPWDDTAconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(13);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(13, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(string));
    }

    private void flowUSRSSBPWDconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(8);
        this.initializeClientSeed();
        this.flowSeedExchange(8, this.sourceSeed_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(string));
    }

    private void flowServerAttributes() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_, this.targetUnicodemgr_);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.agent_.endReadChain();
    }

    private void flowKeyExchange(int n, byte[] byArray) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(n, this.databaseName_, byArray);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, n);
        this.agent_.endReadChain();
    }

    private void flowSeedExchange(int n, byte[] byArray) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(n, this.databaseName_, byArray);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, n);
        this.agent_.endReadChain();
    }

    private void flowServerAttributesAndKeyExchange(int n, byte[] byArray) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeServerAttributesAndKeyExchange(n, byArray);
        this.agent_.flowOutsideUOW();
        this.readServerAttributesAndKeyExchange(n);
        this.agent_.endReadChain();
    }

    private void flowSecurityCheckAndAccessRdb(int n, String string, String string2, byte[] byArray, byte[] byArray2) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeSecurityCheckAndAccessRdb(n, string, string2, byArray, byArray2);
        this.agent_.flowOutsideUOW();
        this.readSecurityCheckAndAccessRdb();
        this.agent_.endReadChain();
    }

    private void writeAllConnectCommandsChained(int n, String string, String string2) throws SqlException {
        this.writeServerAttributesAndKeyExchange(n, null);
        this.writeSecurityCheckAndAccessRdb(n, string, string2, null, null);
    }

    private void readAllConnectCommandsChained(int n) throws SqlException {
        this.readServerAttributesAndKeyExchange(n);
        this.readSecurityCheckAndAccessRdb();
    }

    private void writeServerAttributesAndKeyExchange(int n, byte[] byArray) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_, this.targetUnicodemgr_);
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(n, this.databaseName_, byArray);
    }

    private void readServerAttributesAndKeyExchange(int n) throws SqlException {
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, n);
    }

    private void writeSecurityCheckAndAccessRdb(int n, String string, String string2, byte[] byArray, byte[] byArray2) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeSecurityCheck(n, this.databaseName_, string, string2, byArray, byArray2);
        this.netAgent_.netConnectionRequest_.writeAccessDatabase(this.databaseName_, false, this.crrtkn_, this.prddta_.array(), this.netAgent_.typdef_);
    }

    private void readSecurityCheckAndAccessRdb() throws SqlException {
        this.netAgent_.netConnectionReply_.readSecurityCheck(this);
        this.netAgent_.netConnectionReply_.readAccessDatabase(this);
    }

    void writeDeferredReset() throws SqlException {
        if (this.securityMechanism_ == 3) {
            this.writeAllConnectCommandsChained(3, this.user_, this.getDeferredResetPassword());
        } else if (this.securityMechanism_ == 4) {
            this.writeAllConnectCommandsChained(4, this.user_, null);
        } else {
            if (this.securityMechanism_ == 8) {
                this.initializeClientSeed();
            } else {
                this.initializePublicKeyForEncryption();
            }
            this.resetConnectionAtFirstSql_ = false;
            if (this.securityMechanism_ == 8) {
                this.flowSeedExchange(this.securityMechanism_, this.sourceSeed_);
            } else {
                this.flowServerAttributesAndKeyExchange(this.securityMechanism_, this.publicKey_);
            }
            this.agent_.beginWriteChainOutsideUOW();
            this.resetConnectionAtFirstSql_ = true;
            if (this.securityMechanism_ == 7) {
                this.writeSecurityCheckAndAccessRdb(7, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(this.getDeferredResetPassword()));
            } else if (this.securityMechanism_ == 8) {
                this.writeSecurityCheckAndAccessRdb(8, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(this.getDeferredResetPassword()));
            } else {
                this.writeSecurityCheckAndAccessRdb(9, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(this.getDeferredResetPassword()));
            }
        }
    }

    void readDeferredReset() throws SqlException {
        this.resetConnectionAtFirstSql_ = false;
        if (this.securityMechanism_ == 3 || this.securityMechanism_ == 4) {
            this.readAllConnectCommandsChained(this.securityMechanism_);
        } else {
            this.readSecurityCheckAndAccessRdb();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    void setServerAttributeData(String string, String string2) {
        this.targetSrvclsnm_ = string;
        this.targetSrvrlslv_ = string2;
    }

    void setAccessSecurityData(int n, int n2, int[] nArray, boolean bl, byte[] byArray) throws DisconnectException {
        if (n != 0) {
            this.netAgent_.setSvrcod(CodePoint.SVRCOD_ERROR);
            this.agent_.accumulateReadException(this.mapSecchkcd(n));
        } else if (nArray.length == 1 && nArray[0] == n2) {
            this.targetSecmec_ = nArray[0];
            if (this.targetSecmec_ == 7 || this.targetSecmec_ == 9 || this.targetSecmec_ == 8 || this.targetSecmec_ == 12 || this.targetSecmec_ == 13) {
                if (!bl) {
                    this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.19"), new Object[0]));
                } else {
                    if (this.targetSecmec_ == 8) {
                        this.targetSeed_ = byArray;
                    } else {
                        this.targetPublicKey_ = byArray;
                    }
                    if (this.encryptionManager_ != null) {
                        this.encryptionManager_.resetSecurityKeys();
                    }
                }
            }
        } else {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XN002.U"), new Object[0]));
        }
    }

    void securityCheckComplete(int n, int n2) {
        this.netAgent_.setSvrcod(n);
        if (n2 == 0) {
            return;
        }
        this.agent_.accumulateReadException(this.mapSecchkcd(n2));
    }

    void rdbAccessed(int n, String string, boolean bl, byte[] byArray) {
        if (bl) {
            this.crrtkn_ = byArray;
        }
        this.netAgent_.setSvrcod(n);
        this.productID_ = string;
    }

    @Override
    protected Agent newAgent_(LogWriter logWriter, int n, String string, int n2, int n3) throws SqlException {
        return new NetAgent(this, logWriter, n, string, n2, n3);
    }

    @Override
    protected ClientStatement newStatement_(int n, int n2, int n3) throws SqlException {
        return new NetStatement((NetAgent)this.netAgent_, (NetConnection)this, (int)n, (int)n2, (int)n3).statement_;
    }

    @Override
    protected void resetStatement_(ClientStatement clientStatement, int n, int n2, int n3) throws SqlException {
        ((NetStatement)clientStatement.getMaterialStatement()).resetNetStatement(this.netAgent_, this, n, n2, n3);
    }

    @Override
    protected ClientPreparedStatement newPositionedUpdatePreparedStatement_(String string, Section section) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (Section)section, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    @Override
    protected ClientPreparedStatement newPreparedStatement_(String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (int)n, (int)n2, (int)n3, (int)n4, (String[])stringArray, (int[])nArray, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    @Override
    protected void resetPreparedStatement_(ClientPreparedStatement clientPreparedStatement, String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        ((NetPreparedStatement)clientPreparedStatement.materialPreparedStatement_).resetNetPreparedStatement(this.netAgent_, this, string, n, n2, n3, n4, stringArray, nArray);
    }

    @Override
    protected ClientCallableStatement newCallableStatement_(String string, int n, int n2, int n3) throws SqlException {
        return new NetCallableStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (int)n, (int)n2, (int)n3, (ClientPooledConnection)this.pooledConnection_).callableStatement_;
    }

    @Override
    protected void resetCallableStatement_(ClientCallableStatement clientCallableStatement, String string, int n, int n2, int n3) throws SqlException {
        ((NetCallableStatement)clientCallableStatement.materialCallableStatement_).resetNetCallableStatement(this.netAgent_, this, string, n, n2, n3);
    }

    @Override
    protected ClientDatabaseMetaData newDatabaseMetaData_() {
        return ClientAutoloadedDriver.getFactory().newNetDatabaseMetaData(this.netAgent_, this);
    }

    private void checkDatabaseName() throws SqlException {
        if (this.databaseName_ == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08001.C.1"), "databaseName");
        }
    }

    private void checkUserLength(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.5"), n, 255);
        }
    }

    private void checkPasswordLength(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.6"), n, 255);
        }
    }

    private void checkUser(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.7"), new Object[0]);
        }
        this.checkUserLength(string);
    }

    private void checkUserPassword(String string, String string2) throws SqlException {
        this.checkUser(string);
        if (string2 == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.8"), new Object[0]);
        }
        this.checkPasswordLength(string2);
    }

    private void checkSecmgrForSecmecSupport(int n) throws SqlException {
        boolean bl = false;
        int[] nArray = NetConfiguration.SECMGR_SECMECS;
        for (int i = 0; i < nArray.length && !bl; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
        }
        if (!bl) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), n);
        }
    }

    private SqlException mapSecchkcd(int n) {
        if (n == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J110", new Object[0]));
            }
            case 16: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J111", new Object[0]));
            }
            case 18: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J112", new Object[0]));
            }
            case 19: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113", new Object[0]));
            }
            case 20: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J114", new Object[0]));
            }
            case 21: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J115", new Object[0]));
            }
            case 10: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J116", new Object[0]));
            }
            case 11: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J117", new Object[0]));
            }
            case 14: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J118", new Object[0]));
            }
            case 15: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113", new Object[0]));
            }
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J120", new Object[0]));
    }

    protected void constructCrrtkn() throws SqlException {
        if (this.crrtkn_ == null) {
            this.crrtkn_ = new byte[19];
        } else {
            Arrays.fill(this.crrtkn_, (byte)0);
        }
        byte[] byArray = this.netAgent_.socket_.getLocalAddress().getAddress();
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            int n3 = byArray[n] < 0 ? byArray[n] + 256 : byArray[n];
            int n4 = n3 >> 4 & 0xF;
            this.crrtkn_[n2] = n == 0 ? this.netAgent_.getCurrentCcsidManager().numToSnaRequiredCrrtknChar_[n4] : this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[n4];
            n4 = n3 & 0xF;
            this.crrtkn_[n2 + 1] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[n4];
            ++n;
            n2 += 2;
        }
        this.crrtkn_[8] = this.netAgent_.getCurrentCcsidManager().dot_;
        n = this.netAgent_.socket_.getLocalPort();
        n2 = n >> 12 & 0xF;
        this.crrtkn_[9] = this.netAgent_.getCurrentCcsidManager().numToSnaRequiredCrrtknChar_[n2];
        n2 = n >> 8 & 0xF;
        this.crrtkn_[10] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[n2];
        n2 = n >> 4 & 0xF;
        this.crrtkn_[11] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[n2];
        n2 = n & 0xF;
        this.crrtkn_[12] = this.netAgent_.getCurrentCcsidManager().numToCharRepresentation_[n2];
        long l = System.currentTimeMillis();
        for (int i = 0; i < 6; ++i) {
            this.crrtkn_[i + 13] = (byte)(l >>> 40 - i * 8);
        }
    }

    private void constructExtnam() throws SqlException {
        char[] cArray = Thread.currentThread().getName().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= '\u00ff') continue;
            cArray[i] = 63;
        }
        this.extnam_ = "derbydnc" + new String(cArray);
    }

    private void constructPrddta() throws SqlException {
        int n;
        if (this.prddta_ == null) {
            this.prddta_ = ByteBuffer.allocate(255);
        } else {
            this.prddta_.clear();
            Arrays.fill(this.prddta_.array(), (byte)0);
        }
        CcsidManager ccsidManager = this.netAgent_.getCurrentCcsidManager();
        for (n = 0; n < 55; ++n) {
            this.prddta_.put(n, ccsidManager.space_);
        }
        this.prddta_.position(1);
        n = 1;
        ccsidManager.startEncoding();
        n &= ccsidManager.encode(CharBuffer.wrap(NetConfiguration.PRDID), this.prddta_, this.agent_);
        ccsidManager.startEncoding();
        n &= ccsidManager.encode(CharBuffer.wrap("JVM               "), this.prddta_, this.agent_);
        int n2 = this.prddta_.position();
        int n3 = Math.min(this.extnam_.length(), 20);
        ccsidManager.startEncoding();
        n &= ccsidManager.encode(CharBuffer.wrap(this.extnam_, 0, n3), this.prddta_, this.agent_);
        n2 += 20;
        n2 += 8;
        this.prddta_.put(55, (byte)0);
        this.prddta_.put(0, (byte)(++n2 - 1));
    }

    private void initializePublicKeyForEncryption() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_);
        }
        this.publicKey_ = this.encryptionManager_.obtainPublicKey();
    }

    private void initializeClientSeed() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_, "SHA-1");
        }
        this.sourceSeed_ = this.encryptionManager_.generateSeed();
    }

    private byte[] encryptedPasswordForUSRENCPWD(String string) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(string, this.netAgent_), 7, this.netAgent_.getCurrentCcsidManager().convertFromJavaString(this.user_, this.netAgent_), this.targetPublicKey_);
    }

    private byte[] encryptedUseridForEUSRIDPWD() throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(this.user_, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] encryptedPasswordForEUSRIDPWD(String string) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.getCurrentCcsidManager().convertFromJavaString(string, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] passwordSubstituteForUSRSSBPWD(String string) throws SqlException {
        String string2;
        String string3 = this.user_;
        if (this.dataSource_ != null && !(string2 = this.dataSource_.getUser()).equals("") && string3.equalsIgnoreCase("APP") && !string2.equalsIgnoreCase("APP")) {
            string3 = string2;
        }
        return this.encryptionManager_.substitutePassword(string3, string, this.sourceSeed_, this.targetSeed_);
    }

    public int getSQLAM() {
        return this.netAgent_.targetSqlam_;
    }

    public int getAGENT() {
        return this.targetAgent_;
    }

    public int getCMNTCPIP() {
        return this.targetCmntcpip_;
    }

    public int getRDB() {
        return this.targetRdb_;
    }

    public int getSECMGR() {
        return this.targetSecmgr_;
    }

    public int getXAMGR() {
        return this.targetXamgr_;
    }

    public int getSYNCPTMGR() {
        return this.targetSyncptmgr_;
    }

    public int getRSYNCMGR() {
        return this.targetRsyncmgr_;
    }

    private char[] flipBits(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            int n2 = n++;
            cArray[n2] = (char)(cArray[n2] ^ 0xFF);
        }
        return cArray;
    }

    @Override
    public void writeCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionRequest_.writeCommitSubstitute(this);
    }

    @Override
    public void readCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionReply_.readCommitSubstitute(this);
    }

    @Override
    public void writeLocalXAStart_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXAStart(this);
    }

    @Override
    public void readLocalXAStart_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXAStart(this);
    }

    @Override
    public void writeLocalXACommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXACommit(this);
    }

    @Override
    public void readLocalXACommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXACommit(this);
    }

    @Override
    public void writeLocalXARollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXARollback(this);
    }

    @Override
    public void readLocalXARollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXARollback(this);
    }

    @Override
    public void writeLocalCommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalCommit(this);
    }

    @Override
    public void readLocalCommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalCommit(this);
    }

    @Override
    public void writeLocalRollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalRollback(this);
    }

    @Override
    public void readLocalRollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalRollback(this);
    }

    @Override
    protected void markClosed_() {
    }

    @Override
    protected boolean isGlobalPending_() {
        return false;
    }

    @Override
    protected boolean doCloseStatementsOnClose_() {
        return this.closeStatementsOnClose;
    }

    @Override
    protected boolean allowCloseInUOW_() {
        return this.autoCommit_ || !this.allowLocalCommitRollback_();
    }

    @Override
    protected boolean allowLocalCommitRollback_() {
        return this.getXAState() == 0;
    }

    public void setInputStream(InputStream inputStream) {
        this.netAgent_.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.netAgent_.setOutputStream(outputStream);
    }

    public InputStream getInputStream() {
        return this.netAgent_.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.netAgent_.getOutputStream();
    }

    @Override
    public void writeTransactionStart(ClientStatement clientStatement) throws SqlException {
    }

    @Override
    public void readTransactionStart() throws SqlException {
        super.readTransactionStart();
    }

    public void setIndoubtTransactions(List<Xid> list) {
        if (this.isXAConnection_) {
            if (this.indoubtTransactions_ != null) {
                this.indoubtTransactions_.clear();
            }
            this.indoubtTransactions_ = list;
        }
    }

    Xid[] getIndoubtTransactionIds() {
        Xid[] xidArray = new Xid[]{};
        return this.indoubtTransactions_.toArray(xidArray);
    }

    @Override
    public SectionManager newSectionManager(Agent agent) {
        return new SectionManager(agent);
    }

    @Override
    public boolean willAutoCommitGenerateFlow() {
        if (!this.autoCommit_) {
            return false;
        }
        if (!this.isXAConnection_) {
            return true;
        }
        boolean bl = false;
        int n = this.getXAState();
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public int getSecurityMechanism() {
        return this.securityMechanism_;
    }

    public EncryptionManager getEncryptionManager() {
        return this.encryptionManager_;
    }

    public byte[] getTargetPublicKey() {
        return this.targetPublicKey_ != null ? (byte[])this.targetPublicKey_.clone() : null;
    }

    public String getProductID() {
        return this.targetSrvclsnm_;
    }

    public final boolean isConnectionNull() {
        return this.connectionNull;
    }

    public void setConnectionNull(boolean bl) {
        this.connectionNull = bl;
    }

    final boolean serverSupportsQryclsimp() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsQryclsimp();
    }

    public final boolean serverSupportsLayerBStreaming() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsLayerBStreaming();
    }

    public final boolean serverSupportLongRDBNAM() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportLongRDBNAM();
    }

    @Override
    protected final boolean supportsSessionDataCaching() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsSessionDataCaching();
    }

    protected final boolean serverSupportsUtf8Ccsid() {
        return this.targetUnicodemgr_ == 1208;
    }

    protected final boolean serverSupportsUDTs() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsUDTs();
    }

    protected final boolean serverSupportsEXTDTAAbort() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsEXTDTAAbort();
    }

    @Override
    protected final boolean serverSupportsLocators() {
        return this.serverSupportsLayerBStreaming();
    }

    @Override
    protected final boolean serverSupportsTimestampNanoseconds() {
        NetDatabaseMetaData netDatabaseMetaData = (NetDatabaseMetaData)this.databaseMetaData_;
        return netDatabaseMetaData.serverSupportsTimestampNanoseconds();
    }

    public boolean isOpen() {
        return this.open_;
    }

    @Override
    protected void writeXACommit_() throws SqlException {
        this.xares_.netXAConn_.writeCommit();
    }

    @Override
    protected void readXACommit_() throws SqlException {
        this.xares_.netXAConn_.readCommit();
    }

    @Override
    protected void writeXARollback_() throws SqlException {
        this.xares_.netXAConn_.writeRollback();
    }

    @Override
    protected void readXARollback_() throws SqlException {
        this.xares_.netXAConn_.readRollback();
    }

    @Override
    protected void writeXATransactionStart(ClientStatement clientStatement) throws SqlException {
        this.xares_.netXAConn_.writeTransactionStart(clientStatement);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createArrayOf(String,Object[])");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createNClob ()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionFactory.notImplemented("createSQLXML ()");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw SQLExceptionFactory.notImplemented("createStruct(String,Object[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), n, "timeout", "java.sql.Connection.isValid").getSQLException();
        }
        if (this.isClosed()) {
            return false;
        }
        NetConnection netConnection = this;
        synchronized (netConnection) {
            try {
                int n2 = this.netAgent_.getTimeout();
                this.netAgent_.setTimeout(n);
                if (this.isValidStmt == null) {
                    this.isValidStmt = this.prepareStatement("VALUES (1)");
                }
                this.isValidStmt.setQueryTimeout(n);
                ResultSet resultSet = this.isValidStmt.executeQuery();
                resultSet.close();
                this.netAgent_.setTimeout(n2);
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isValidStmt != null) {
            this.isValidStmt.close();
            this.isValidStmt = null;
        }
        super.close();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        Properties properties = FailedProperties40.makeProperties(string, string2);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
        if (string == null && string2 == null) {
            return;
        }
        this.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        FailedProperties40 failedProperties40 = new FailedProperties40(properties);
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode(), failedProperties40.getProperties());
        }
        if (properties == null || properties.isEmpty()) {
            return;
        }
        SqlException sqlException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XCY02.S"), failedProperties40.getFirstKey(), failedProperties40.getFirstValue());
        throw new SQLClientInfoException(sqlException.getMessage(), sqlException.getSQLState(), sqlException.getErrorCode(), failedProperties40.getProperties());
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            this.checkForClosedConnection();
            return null;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForClosedConnection();
            return new Properties();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.checkForClosedConnection();
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }
}

