AUTOCOMMIT OFF;

-- MODULE  DML130  

-- SQL Test Suite, V6.0, Interactive SQL, dml130.sql
-- 59-byte ID
-- TEd Version #

-- AUTHORIZATION FLATER
   set schema FLATER;

--O   SELECT USER FROM HU.ECCO;
  VALUES USER;
-- RERUN if USER value does not match preceding AUTHORIZATION comment
   ROLLBACK WORK;

-- date_time print

-- TEST:0678 Data type semantics with NULL / NOT NULL!

   CREATE TABLE CH1 (
  CH1A CHARACTER (10) NOT NULL,
  CH1B CHARACTER NOT NULL,
  CH1C CHAR (10) NOT NULL);
-- PASS:0678 If table is created?

   COMMIT WORK;

   CREATE TABLE NUM1 (
  NUM1C1 NUMERIC (3, 2) NOT NULL,
  NUM1C2 NUMERIC (2) NOT NULL,
  NUM1C3 NUMERIC NOT NULL);
-- PASS:0678 If table is created?

   COMMIT WORK;

   INSERT INTO CH1 VALUES ('FOO', '', '0123456789');
-- PASS:0678 If 1 row is inserted?

   SELECT CH1A, CH1B, CH1C
  FROM CH1;
-- PASS:0678 If 1 row selected and CH1A = 'FOO       '?
-- PASS:0678 AND CH1B = ' ' and CH1C = '0123456789'?

-- NOTE:0678 One subtest deleted.

   INSERT INTO CH1 VALUES ('FOO',
  'F', 'LITTLETOOLONG');
-- PASS:0678 If ERROR, string data, right truncation, 0 rows selected?

   DELETE FROM CH1;

   INSERT INTO CH1 VALUES ('FOO',
  'F', 'BLANKS       ');
-- PASS:0678 If 1 row is inserted?

   SELECT CH1A, CH1B, CH1C
  FROM CH1;
-- PASS:0678 If 1 row selected and CH1A = 'FOO       '?
-- PASS:0678 AND CH1B = 'F' and CH1C = 'BLANKS    '?

   INSERT INTO NUM1 VALUES (9.99, -99, 9);
-- PASS:0678 If 1 row is inserted?

   SELECT NUM1C1 * 100, NUM1C2, NUM1C3
  FROM NUM1;
-- PASS:0678 If 1 row selected and values are 999, -99, 9?

   DELETE FROM NUM1;

   INSERT INTO NUM1 VALUES (-10, 0, 0);
-- PASS:0678 If ERROR, string data, numeric value out of range?
-- PASS:0678 AND 0 rows inserted?

   INSERT INTO NUM1 VALUES (0, 100, 0);
-- PASS:0678 If ERROR, string data, numeric value out of range?
-- PASS:0678 AND 0 rows inserted?

   INSERT INTO NUM1 VALUES (0, 0, 0.1);
-- PASS:0678 If 1 row is inserted?

   SELECT NUM1C1 * 100, NUM1C2, NUM1C3
  FROM NUM1;
-- PASS:0678 If 1 row selected and values are 0, 0, 0?

   ROLLBACK WORK;

--O   DROP TABLE NUM1 CASCADE;
   DROP TABLE NUM1 ;

   COMMIT WORK;

--O   DROP TABLE CH1 CASCADE;
   DROP TABLE CH1 ;

   COMMIT WORK;

-- END TEST >>> 0678 <<< END TEST

-- *********************************************

--O-- TEST:0679 INFO_SCHEM:  Table data types!
--O
--O   CREATE TABLE LOTSA_TYPES (
--O  FLAAG CHAR DEFAULT 'Y', KODE CHAR (5) NOT NULL,
--O  AMPL REAL DEFAULT 3,
--O  COORD DOUBLE PRECISION, SWAY FLOAT, REVS INTEGER,
--O  PITCH SMALLINT, DEGREE NUMERIC (3, 2), RUDDER DECIMAL (2));
--O-- PASS:0679 If table is created?
--O
--O   COMMIT WORK;
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.TABLES
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND TABLE_TYPE = 'BASE TABLE';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.VIEWS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES';
--O-- PASS:0679 If count = 0?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'FLAAG' AND ORDINAL_POSITION = 1
--O  AND COLUMN_DEF = '''Y''' AND DATA_TYPE = 'CHARACTER'
--O  AND CHAR_MAX_LENGTH = 1 AND CHAR_OCTET_LENGTH
--O  > 0 AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'KODE' AND ORDINAL_POSITION = 2
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'CHARACTER'
--O  AND CHAR_MAX_LENGTH = 5 AND CHAR_OCTET_LENGTH
--O  > 3 AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'NO';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'AMPL' AND ORDINAL_POSITION = 3
--O  AND COLUMN_DEF IS NOT NULL AND DATA_TYPE = 'REAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'COORD' AND ORDINAL_POSITION = 4
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'DOUBLE PRECISION'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'SWAY' AND ORDINAL_POSITION = 5
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'FLOAT'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'REVS' AND ORDINAL_POSITION = 6
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTEGER'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 0 AND NUM_SCALE = 0 AND
--O  (NUM_PREC_RADIX = 2 OR NUM_PREC_RADIX = 10)
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'PITCH' AND ORDINAL_POSITION = 7
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'SMALLINT'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 0 AND NUM_SCALE = 0 AND
--O  (NUM_PREC_RADIX = 2 OR NUM_PREC_RADIX = 10)
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'DEGREE' AND ORDINAL_POSITION = 8
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'NUMERIC'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC = 3 AND NUM_SCALE = 2
--O  AND NUM_PREC_RADIX = 10
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'RUDDER' AND ORDINAL_POSITION = 9
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'DECIMAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 2 AND NUM_SCALE = 0
--O  AND NUM_PREC_RADIX = 10
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0679 If count = 1?
--O
--O   ROLLBACK WORK;
--O
--O   DROP TABLE LOTSA_TYPES CASCADE;
--O
--O   COMMIT WORK;
--O
--O-- END TEST >>> 0679 <<< END TEST
--O
--O-- *********************************************
--O
--O-- TEST:0680 INFO_SCHEM:  View data types!
--O
--O   CREATE TABLE LT1 (
--O  FLAAG CHAR DEFAULT 'Y', KODE CHAR (5) NOT NULL,
--O  AMPL REAL DEFAULT 3,
--O  COORD DOUBLE PRECISION, SWAY FLOAT, REVS INTEGER);
--O-- PASS:0680 If table is created?
--O
--O   COMMIT WORK;
--O
--O   CREATE TABLE LT2 (
--O  PITCH SMALLINT, DEGREE NUMERIC (3, 2), RUDDER DECIMAL (2));
--O-- PASS:0680 If table is created?
--O
--O   COMMIT WORK;
--O
--O   CREATE VIEW LOTSA_TYPES AS
--O  SELECT * FROM LT1, LT2;
--O-- PASS:0680 If view is created?
--O
--O   COMMIT WORK;
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.TABLES
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND TABLE_TYPE = 'VIEW';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.VIEWS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'FLAAG' AND ORDINAL_POSITION = 1
--O  AND COLUMN_DEF = '''Y''' AND DATA_TYPE = 'CHARACTER'
--O  AND CHAR_MAX_LENGTH = 1 AND CHAR_OCTET_LENGTH
--O  > 0 AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'KODE' AND ORDINAL_POSITION = 2
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'CHARACTER'
--O  AND CHAR_MAX_LENGTH = 5 AND CHAR_OCTET_LENGTH
--O  > 0 AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'NO';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'AMPL' AND ORDINAL_POSITION = 3
--O  AND COLUMN_DEF IS NOT NULL AND DATA_TYPE = 'REAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'COORD' AND ORDINAL_POSITION = 4
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'DOUBLE PRECISION'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'SWAY' AND ORDINAL_POSITION = 5
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'FLOAT'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 8 AND NUM_PREC_RADIX
--O  = 2 AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'REVS' AND ORDINAL_POSITION = 6
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTEGER'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 0 AND NUM_SCALE = 0 AND
--O  (NUM_PREC_RADIX = 2 OR NUM_PREC_RADIX = 10)
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'PITCH' AND ORDINAL_POSITION = 7
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'SMALLINT'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC > 0 AND NUM_SCALE = 0 AND
--O  (NUM_PREC_RADIX = 2 OR NUM_PREC_RADIX = 10)
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'DEGREE' AND ORDINAL_POSITION = 8
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'NUMERIC'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC = 3 AND NUM_SCALE = 2
--O  AND NUM_PREC_RADIX = 10
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_TYPES'
--O  AND COLUMN_NAME = 'RUDDER' AND ORDINAL_POSITION = 9
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'DECIMAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC >= 2 AND NUM_SCALE = 0
--O  AND NUM_PREC_RADIX = 10
--O  AND DATETIME_PREC IS NULL AND INTERVAL_TYPE IS NULL AND
--O  INTERVAL_PREC IS NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0680 If count = 1?
--O
--O   ROLLBACK WORK;
--O
--O   DROP TABLE LT1 CASCADE;
--O
--O   COMMIT WORK;
--O
--O   DROP TABLE LT2 CASCADE;
--O
--O   COMMIT WORK;
--O
--O-- END TEST >>> 0680 <<< END TEST
--O
--O-- *********************************************
--O
--O-- TEST:0682 INFO_SCHEM:  Datetime data types!
--O
--O   CREATE TABLE LOTSA_DATETIMES (
--O  C1 DATE, C2 TIME, C3 TIMESTAMP,
--O  C4 INTERVAL YEAR, C5 INTERVAL MONTH, C6 INTERVAL DAY,
--O  C7 INTERVAL HOUR, C8 INTERVAL MINUTE, C9 INTERVAL SECOND,
--O  C10 INTERVAL YEAR TO MONTH,
--O  C11 INTERVAL DAY TO HOUR,
--O  C12 INTERVAL DAY TO MINUTE,
--O  C13 INTERVAL DAY TO SECOND,
--O  C14 INTERVAL HOUR TO MINUTE,
--O  C15 INTERVAL HOUR TO SECOND,
--O  C16 INTERVAL MINUTE TO SECOND);
--O-- PASS:0682 If table is created?
--O
--O   COMMIT WORK;
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.TABLES
--O  WHERE TABLE_SCHEM = 'FLATER'
--O  AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND TABLE_TYPE = 'BASE TABLE';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C1' AND ORDINAL_POSITION = 1
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'DATE'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS
--O  NOT NULL AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C2' AND ORDINAL_POSITION = 2
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'TIME'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 0
--O  AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C3' AND ORDINAL_POSITION = 3
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'TIMESTAMP'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 6
--O  AND INTERVAL_TYPE IS NULL AND INTERVAL_PREC IS
--O  NULL AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C4' AND ORDINAL_POSITION = 4
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'YEAR' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C5' AND ORDINAL_POSITION = 5
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'MONTH' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C6' AND ORDINAL_POSITION = 6
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'DAY' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C7' AND ORDINAL_POSITION = 7
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'HOUR' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C8' AND ORDINAL_POSITION = 8
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'MINUTE' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C9' AND ORDINAL_POSITION = 9
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 6
--O  AND INTERVAL_TYPE = 'SECOND' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C10' AND ORDINAL_POSITION = 10
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'YEAR TO MONTH' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C11' AND ORDINAL_POSITION = 11
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'DAY TO HOUR' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C12' AND ORDINAL_POSITION = 12
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'DAY TO MINUTE' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C13' AND ORDINAL_POSITION = 13
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 6
--O  AND INTERVAL_TYPE = 'DAY TO SECOND' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C14' AND ORDINAL_POSITION = 14
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC IS NOT NULL
--O  AND INTERVAL_TYPE = 'HOUR TO MINUTE' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C15' AND ORDINAL_POSITION = 15
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 6
--O  AND INTERVAL_TYPE = 'HOUR TO SECOND' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   SELECT COUNT(*) FROM INFO_SCHEM.COLUMNS
--O  WHERE TABLE_SCHEM = 'FLATER' AND TABLE_NAME = 'LOTSA_DATETIMES'
--O  AND COLUMN_NAME = 'C16' AND ORDINAL_POSITION = 16
--O  AND COLUMN_DEF IS NULL AND DATA_TYPE = 'INTERVAL'
--O  AND CHAR_MAX_LENGTH IS NULL AND CHAR_OCTET_LENGTH
--O  IS NULL AND NUM_PREC IS NULL AND NUM_PREC_RADIX
--O  IS NULL AND NUM_SCALE IS NULL AND DATETIME_PREC = 6
--O  AND INTERVAL_TYPE = 'MINUTE TO SECOND' AND INTERVAL_PREC = 2
--O  AND IS_NULLABLE = 'YES';
--O-- PASS:0682 If count = 1?
--O
--O   ROLLBACK WORK;
--O
--O   DROP TABLE LOTSA_DATETIMES CASCADE;
--O
--O   COMMIT WORK;
--O
--O-- END TEST >>> 0682 <<< END TEST
--O
--O-- *************************************************////END-OF-MODULE
