/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.dfs.ReadAheadRejectedExecutionHandler;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private long blockLimit;
    private int blockSize;
    private int readAheadLimit;
    private ThreadPoolExecutor readAheadService;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        this.blockSize = Math.max(512, newSize);
        return this;
    }

    public int getReadAheadLimit() {
        return this.readAheadLimit;
    }

    public DfsBlockCacheConfig setReadAheadLimit(int newSize) {
        this.readAheadLimit = Math.max(0, newSize);
        return this;
    }

    public ThreadPoolExecutor getReadAheadService() {
        return this.readAheadService;
    }

    public DfsBlockCacheConfig setReadAheadService(ThreadPoolExecutor svc) {
        if (svc != null) {
            svc.setRejectedExecutionHandler(ReadAheadRejectedExecutionHandler.INSTANCE);
        }
        this.readAheadService = svc;
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc) {
        this.setBlockLimit(rc.getLong("core", "dfs", "blockLimit", this.getBlockLimit()));
        this.setBlockSize(rc.getInt("core", "dfs", "blockSize", this.getBlockSize()));
        this.setReadAheadLimit(rc.getInt("core", "dfs", "readAheadLimit", this.getReadAheadLimit()));
        int readAheadThreads = rc.getInt("core", "dfs", "readAheadThreads", 0);
        if (0 < this.getReadAheadLimit() && 0 < readAheadThreads) {
            this.setReadAheadService(new ThreadPoolExecutor(1, readAheadThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadFactory(){
                private final String name = "JGit-DFS-ReadAhead";
                private final AtomicInteger cnt = new AtomicInteger();
                private final ThreadGroup group = new ThreadGroup("JGit-DFS-ReadAhead");

                public Thread newThread(Runnable body) {
                    int id = this.cnt.incrementAndGet();
                    Thread thread = new Thread(this.group, body, "JGit-DFS-ReadAhead-" + id);
                    thread.setDaemon(true);
                    thread.setContextClassLoader(this.getClass().getClassLoader());
                    return thread;
                }
            }, ReadAheadRejectedExecutionHandler.INSTANCE));
        }
        return this;
    }
}

