/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.option;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.qname.QualifiedNameMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private QualifiedNameMap<Option> globalScope = new QualifiedNameMap();

    public void setGlobalOption(Option option) {
        this.globalScope.put(option.getQualifiedName(), option);
    }

    public void addGlobalOptions(Collection<Option> options) {
        for (Option option : options) {
            this.setGlobalOption(option);
        }
    }

    public Option getInHierarchy(QualifiedName key) {
        QualifiedName globalKey = this.globalScope.getKeyInHierarchy(key);
        Option globalOption = this.globalScope.get(globalKey);
        return globalOption;
    }

    public Options getInHierarchy(Namespace namespace) {
        Options result = new Options();
        result.globalScope = this.globalScope.getInHierarchy(namespace);
        return result;
    }

    public Options getAllInHierarchy(Namespace namespace) {
        Options result = new Options();
        result.globalScope = this.globalScope.getAllInHierarchy(namespace);
        return result;
    }

    public Collection<Option> values() {
        HashMap<QualifiedName, Option> result = new HashMap<QualifiedName, Option>();
        for (Option globalOption : this.globalScope.values()) {
            result.put(globalOption.getQualifiedName(), globalOption);
        }
        return Collections.unmodifiableCollection(result.values());
    }

    public Collection<QualifiedName> keySet() {
        Collection<Option> options = this.values();
        HashSet<QualifiedName> result = new HashSet<QualifiedName>(options.size());
        for (Option option : options) {
            result.add(option.getQualifiedName());
        }
        return result;
    }

    public Map<QualifiedName, Option> getGlobalScope() {
        return Collections.unmodifiableMap(this.globalScope);
    }

    public boolean containsKey(QualifiedName key) {
        return this.globalScope.containsKey(key);
    }

    public String toString() {
        return "global Scope: " + this.globalScope.toString();
    }
}

