/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.stream.FileSource;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.apache.torque.generator.source.stream.XmlSourceFormat;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;

public class IncludeSchemaTransformer
implements SourceTransformer {
    private static Log log = LogFactory.getLog(IncludeSchemaTransformer.class);
    private File baseDir;

    public IncludeSchemaTransformer() {
    }

    public IncludeSchemaTransformer(File baseDir) {
        this.baseDir = baseDir;
    }

    public SourceElement transform(SourceElement root, ControllerState controllerState) throws SourceTransformerException {
        List includeSchemaList = root.getChildren((SourceElementName)TorqueSchemaElementName.INCLUDE_SCHEMA);
        List childrenList = root.getChildren();
        for (SourceElement includeSchemaElement : includeSchemaList) {
            File includeSchemaBaseDir;
            if (this.baseDir == null) {
                File currentSourceFile = controllerState.getSourceFile();
                includeSchemaBaseDir = currentSourceFile.getParentFile();
            } else {
                includeSchemaBaseDir = this.baseDir;
            }
            String relativePath = includeSchemaElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FILENAME).toString();
            File includeSchemaPath = new File(includeSchemaBaseDir, relativePath);
            log.trace((Object)("Trying to read included file " + includeSchemaPath));
            try {
                FileSource fileSource = new FileSource((StreamSourceFormat)new XmlSourceFormat(), includeSchemaPath, controllerState);
                SourceElement includeSchemaRootElement = fileSource.getRootElement();
                log.trace((Object)("successfully read included file " + includeSchemaPath));
                this.transform(includeSchemaRootElement, controllerState);
                ArrayList toIncludeList = new ArrayList(includeSchemaRootElement.getChildren());
                for (SourceElement childToInclude : toIncludeList) {
                    childToInclude.getParents().clear();
                }
                childrenList.addAll(toIncludeList);
                log.trace((Object)("finished processing included file " + includeSchemaPath));
            }
            catch (SourceException e) {
                log.error((Object)("Could not construct source from schema file " + includeSchemaPath), (Throwable)e);
                throw new SourceTransformerException((Throwable)e);
            }
        }
        return root;
    }
}

