/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.EncoderException;

public class KerberosEncoder {
    public static ByteBuffer encode(Asn1Object asn1Obj, boolean isTcp) throws IOException {
        int responseLength;
        ByteBuffer kerberosMessage = null;
        int bufferLen = responseLength = asn1Obj.computeLength();
        if (isTcp) {
            bufferLen += 4;
        }
        kerberosMessage = ByteBuffer.allocate(bufferLen);
        if (isTcp) {
            kerberosMessage.putInt(responseLength);
        }
        try {
            asn1Obj.encode(kerberosMessage);
            kerberosMessage.flip();
            return kerberosMessage;
        }
        catch (EncoderException e) {
            throw new IOException(e.getMessage());
        }
    }
}

