// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/apache/doris-operator/api/doris/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDorisClusters implements DorisClusterInterface
type FakeDorisClusters struct {
	Fake *FakeDorisV1
	ns   string
}

var dorisclustersResource = v1.SchemeGroupVersion.WithResource("dorisclusters")

var dorisclustersKind = v1.SchemeGroupVersion.WithKind("DorisCluster")

// Get takes name of the dorisCluster, and returns the corresponding dorisCluster object, and an error if there is any.
func (c *FakeDorisClusters) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.DorisCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(dorisclustersResource, c.ns, name), &v1.DorisCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DorisCluster), err
}

// List takes label and field selectors, and returns the list of DorisClusters that match those selectors.
func (c *FakeDorisClusters) List(ctx context.Context, opts metav1.ListOptions) (result *v1.DorisClusterList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(dorisclustersResource, dorisclustersKind, c.ns, opts), &v1.DorisClusterList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.DorisClusterList{ListMeta: obj.(*v1.DorisClusterList).ListMeta}
	for _, item := range obj.(*v1.DorisClusterList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dorisClusters.
func (c *FakeDorisClusters) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(dorisclustersResource, c.ns, opts))

}

// Create takes the representation of a dorisCluster and creates it.  Returns the server's representation of the dorisCluster, and an error, if there is any.
func (c *FakeDorisClusters) Create(ctx context.Context, dorisCluster *v1.DorisCluster, opts metav1.CreateOptions) (result *v1.DorisCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(dorisclustersResource, c.ns, dorisCluster), &v1.DorisCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DorisCluster), err
}

// Update takes the representation of a dorisCluster and updates it. Returns the server's representation of the dorisCluster, and an error, if there is any.
func (c *FakeDorisClusters) Update(ctx context.Context, dorisCluster *v1.DorisCluster, opts metav1.UpdateOptions) (result *v1.DorisCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(dorisclustersResource, c.ns, dorisCluster), &v1.DorisCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DorisCluster), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDorisClusters) UpdateStatus(ctx context.Context, dorisCluster *v1.DorisCluster, opts metav1.UpdateOptions) (*v1.DorisCluster, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(dorisclustersResource, "status", c.ns, dorisCluster), &v1.DorisCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DorisCluster), err
}

// Delete takes name of the dorisCluster and deletes it. Returns an error if one occurs.
func (c *FakeDorisClusters) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(dorisclustersResource, c.ns, name, opts), &v1.DorisCluster{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDorisClusters) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(dorisclustersResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1.DorisClusterList{})
	return err
}

// Patch applies the patch and returns the patched dorisCluster.
func (c *FakeDorisClusters) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DorisCluster, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(dorisclustersResource, c.ns, name, pt, data, subresources...), &v1.DorisCluster{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1.DorisCluster), err
}
