-- tpch18 using 1395599672 as a seed to the RNG
select
  c.c_name,
  c.c_custkey,
  o.o_orderkey,
  o.o_orderdate,
  o.o_totalprice,
  sum(l.l_quantity)
from
  cp.`tpch/customer.parquet` c,
  cp.`tpch/orders.parquet` o,
  cp.`tpch/lineitem.parquet` l
where
  o.o_orderkey in (
    select
      l_orderkey
    from
      cp.`tpch/lineitem.parquet`
    group by
      l_orderkey having
        sum(l_quantity) > 300
  )
  and c.c_custkey = o.o_custkey
  and o.o_orderkey = l.l_orderkey
group by
  c.c_name,
  c.c_custkey,
  o.o_orderkey,
  o.o_orderdate,
  o.o_totalprice
order by
  o.o_totalprice desc,
  o.o_orderdate
limit 100;