/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.k8s.overlord.KubernetesPeonLifecycle;

public class KubernetesWorkItem
extends TaskRunnerWorkItem {
    private final Task task;
    private final KubernetesPeonLifecycle kubernetesPeonLifecycle;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public KubernetesWorkItem(Task task, ListenableFuture<TaskStatus> statusFuture, KubernetesPeonLifecycle kubernetesPeonLifecycle) {
        super(task.getId(), statusFuture);
        this.task = task;
        this.kubernetesPeonLifecycle = kubernetesPeonLifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            KubernetesWorkItem kubernetesWorkItem = this;
            synchronized (kubernetesWorkItem) {
                this.kubernetesPeonLifecycle.startWatchingLogs();
                this.kubernetesPeonLifecycle.shutdown();
            }
        }
    }

    protected boolean isPending() {
        return RunnerTaskState.PENDING.equals((Object)this.getRunnerTaskState());
    }

    protected boolean isRunning() {
        return RunnerTaskState.RUNNING.equals((Object)this.getRunnerTaskState());
    }

    protected RunnerTaskState getRunnerTaskState() {
        if (this.kubernetesPeonLifecycle == null) {
            return RunnerTaskState.PENDING;
        }
        switch (this.kubernetesPeonLifecycle.getState()) {
            case NOT_STARTED: 
            case PENDING: {
                return RunnerTaskState.PENDING;
            }
            case RUNNING: {
                return RunnerTaskState.RUNNING;
            }
            case STOPPED: {
                return RunnerTaskState.NONE;
            }
        }
        throw new ISE("Peon lifecycle in unknown state", new Object[0]);
    }

    protected Optional<InputStream> streamTaskLogs() {
        return this.kubernetesPeonLifecycle.streamLogs();
    }

    public TaskLocation getLocation() {
        return this.kubernetesPeonLifecycle.getTaskLocation();
    }

    public String getTaskType() {
        return this.task.getType();
    }

    public String getDataSource() {
        return this.task.getDataSource();
    }

    public Task getTask() {
        return this.task;
    }

    protected KubernetesPeonLifecycle getPeonLifeycle() {
        return this.kubernetesPeonLifecycle;
    }
}

