/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluent;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluentImpl;

public class V1StatefulSetSpecBuilder
extends V1StatefulSetSpecFluentImpl<V1StatefulSetSpecBuilder>
implements VisitableBuilder<V1StatefulSetSpec, V1StatefulSetSpecBuilder> {
    V1StatefulSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1StatefulSetSpecBuilder() {
        this(false);
    }

    public V1StatefulSetSpecBuilder(Boolean validationEnabled) {
        this(new V1StatefulSetSpec(), validationEnabled);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1StatefulSetSpec(), validationEnabled);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, V1StatefulSetSpec instance) {
        this(fluent, instance, false);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, V1StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withMinReadySeconds(instance.getMinReadySeconds());
            fluent.withOrdinals(instance.getOrdinals());
            fluent.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
            fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
            fluent.withReplicas(instance.getReplicas());
            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            fluent.withSelector(instance.getSelector());
            fluent.withServiceName(instance.getServiceName());
            fluent.withTemplate(instance.getTemplate());
            fluent.withUpdateStrategy(instance.getUpdateStrategy());
            fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        }
        this.validationEnabled = validationEnabled;
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpec instance) {
        this(instance, (Boolean)false);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withOrdinals(instance.getOrdinals());
            this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
            this.withPodManagementPolicy(instance.getPodManagementPolicy());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withServiceName(instance.getServiceName());
            this.withTemplate(instance.getTemplate());
            this.withUpdateStrategy(instance.getUpdateStrategy());
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1StatefulSetSpec build() {
        V1StatefulSetSpec buildable = new V1StatefulSetSpec();
        buildable.setMinReadySeconds(this.fluent.getMinReadySeconds());
        buildable.setOrdinals(this.fluent.getOrdinals());
        buildable.setPersistentVolumeClaimRetentionPolicy(this.fluent.getPersistentVolumeClaimRetentionPolicy());
        buildable.setPodManagementPolicy(this.fluent.getPodManagementPolicy());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setRevisionHistoryLimit(this.fluent.getRevisionHistoryLimit());
        buildable.setSelector(this.fluent.getSelector());
        buildable.setServiceName(this.fluent.getServiceName());
        buildable.setTemplate(this.fluent.getTemplate());
        buildable.setUpdateStrategy(this.fluent.getUpdateStrategy());
        buildable.setVolumeClaimTemplates(this.fluent.getVolumeClaimTemplates());
        return buildable;
    }
}

