/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.catalog.CatalogException;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.SchemaRegistry;
import org.apache.druid.catalog.model.SchemaRegistryImpl;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.storage.sql.CatalogManager;
import org.apache.druid.catalog.sync.CatalogSource;
import org.apache.druid.catalog.sync.CatalogUpdateListener;
import org.apache.druid.catalog.sync.CatalogUpdateProvider;
import org.apache.druid.guice.annotations.Json;

public class CatalogStorage
implements CatalogUpdateProvider,
CatalogSource {
    protected final SchemaRegistry schemaRegistry = new SchemaRegistryImpl();
    protected final TableDefnRegistry tableRegistry;
    protected final CatalogManager catalogMgr;

    @Inject
    public CatalogStorage(CatalogManager catalogMgr, @Json ObjectMapper jsonMapper) {
        this.tableRegistry = new TableDefnRegistry(jsonMapper);
        this.catalogMgr = catalogMgr;
    }

    public CatalogManager tables() {
        return this.catalogMgr;
    }

    public SchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }

    public ObjectMapper jsonMapper() {
        return this.tableRegistry.jsonMapper();
    }

    public SchemaRegistry.SchemaSpec resolveSchema(String dbSchema) {
        return this.schemaRegistry.schema(dbSchema);
    }

    @Override
    public void register(CatalogUpdateListener listener) {
        this.tables().register(listener);
    }

    @Override
    public List<TableMetadata> tablesForSchema(String dbSchema) {
        return this.tables().tablesInSchema(dbSchema);
    }

    @Override
    @Nullable
    public TableMetadata table(TableId id) {
        try {
            return this.tables().read(id);
        }
        catch (CatalogException.NotFoundException e) {
            return null;
        }
    }

    public void validate(TableMetadata table) {
        table.validate();
        this.tableRegistry.resolve(table.spec()).validate();
    }

    public TableDefnRegistry tableRegistry() {
        return this.tableRegistry;
    }

    @Override
    @Nullable
    public ResolvedTable resolveTable(TableId id) {
        TableMetadata table = this.table(id);
        return table == null ? null : this.tableRegistry.resolve(table.spec());
    }
}

