/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.arch;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.architecture.InstanceDescription;
import org.apache.felix.shell.Command;

public class ArchCommandImpl
implements Command {
    private Architecture[] m_archs;
    private Factory[] m_factories;
    private HandlerFactory[] m_handlers;
    static /* synthetic */ Class class$org$apache$felix$ipojo$IPojoFactory;

    public String getName() {
        return "arch";
    }

    public String getUsage() {
        return "arch [-factories] [-instances] [-handlers] [-factory factory_name] [-instance instance_name]";
    }

    public String getShortDescription() {
        return "Architecture command : display the architecture";
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        String line2 = line.substring("arch".length()).trim();
        if (line2.equalsIgnoreCase("-instances") || line2.length() == 0) {
            this.printInstances(out);
            return;
        }
        if (line2.equalsIgnoreCase("-factories")) {
            this.printFactories(out);
            return;
        }
        if (line2.startsWith("-factory")) {
            String name = line2.substring("-factory".length()).trim();
            this.printFactory(name, out, err);
            return;
        }
        if (line2.startsWith("-instance")) {
            String name = line2.substring("-instance".length()).trim();
            this.printInstance(name, out, err);
            return;
        }
        if (line2.startsWith("-handlers")) {
            this.printHandlers(out);
            return;
        }
        if (line2.startsWith("-stats")) {
            this.printStats(out);
            return;
        }
        err.println(this.getUsage());
    }

    private void printStats(PrintStream out) {
        try {
            Field field = (class$org$apache$felix$ipojo$IPojoFactory == null ? (class$org$apache$felix$ipojo$IPojoFactory = ArchCommandImpl.class$("org.apache.felix.ipojo.IPojoFactory")) : class$org$apache$felix$ipojo$IPojoFactory).getDeclaredField("INSTANCE_NAME");
            field.setAccessible(true);
            List names = (List)field.get(null);
            out.println("Number of living instances : " + names.size());
            out.println("Created instances : " + names);
        }
        catch (SecurityException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            out.println("Cannot compute stats : " + e.getMessage());
        }
    }

    private void printInstances(PrintStream out) {
        for (int i = 0; i < this.m_archs.length; ++i) {
            InstanceDescription instance = this.m_archs[i].getInstanceDescription();
            if (instance.getState() == 2) {
                out.println("Instance " + instance.getName() + " -> valid");
            }
            if (instance.getState() == 1) {
                out.println("Instance " + instance.getName() + " -> invalid");
            }
            if (instance.getState() != 0) continue;
            out.println("Instance " + instance.getName() + " -> stopped");
        }
    }

    private void printInstance(String name, PrintStream out, PrintStream err) {
        for (int i = 0; i < this.m_archs.length; ++i) {
            InstanceDescription instance = this.m_archs[i].getInstanceDescription();
            if (!instance.getName().equalsIgnoreCase(name)) continue;
            out.println(instance.getDescription());
            return;
        }
        err.println("Instance " + name + " not found");
    }

    private void printFactories(PrintStream out) {
        for (int i = 0; i < this.m_factories.length; ++i) {
            if (this.m_factories[i].getMissingHandlers().size() == 0) {
                out.println("Factory " + this.m_factories[i].getName() + " (VALID)");
                continue;
            }
            out.println("Factory " + this.m_factories[i].getName() + " (INVALID : " + this.m_factories[i].getMissingHandlers() + ")");
        }
    }

    private void printFactory(String name, PrintStream out, PrintStream err) {
        boolean found = false;
        for (int i = 0; i < this.m_factories.length; ++i) {
            if (!this.m_factories[i].getName().equalsIgnoreCase(name)) continue;
            if (found) {
                out.println();
            }
            out.println(this.m_factories[i].getDescription());
            found = true;
        }
        if (!found) {
            err.println("Factory " + name + " not found");
        }
    }

    private void printHandlers(PrintStream out) {
        for (int i = 0; i < this.m_handlers.length; ++i) {
            String name = this.m_handlers[i].getHandlerName();
            if ("composite".equals(this.m_handlers[i].getType())) {
                name = name + " [composite]";
            }
            if (this.m_handlers[i].getMissingHandlers().size() == 0) {
                out.println("Handler " + name + " (VALID)");
                continue;
            }
            out.println("Handler " + name + " (INVALID : " + this.m_handlers[i].getMissingHandlers() + ")");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

