/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.iteration.datacache.nonkeyed.FileSegmentReader;
import org.apache.flink.iteration.datacache.nonkeyed.MemorySegmentReader;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentReader;

public class DataCacheReader<T>
implements Iterator<T> {
    private final TypeSerializer<T> serializer;
    private final List<Segment> segments;
    @Nullable
    private SegmentReader<T> currentSegmentReader;
    private int currentSegmentIndex;
    private int currentSegmentCount;

    public DataCacheReader(TypeSerializer<T> serializer, List<Segment> segments) {
        this(serializer, segments, (Tuple2<Integer, Integer>)Tuple2.of((Object)0, (Object)0));
    }

    public DataCacheReader(TypeSerializer<T> serializer, List<Segment> segments, Tuple2<Integer, Integer> readerPosition) {
        this.serializer = serializer;
        this.segments = segments;
        this.currentSegmentIndex = (Integer)readerPosition.f0;
        this.currentSegmentCount = (Integer)readerPosition.f1;
        this.createSegmentReader((Integer)readerPosition.f0, (Integer)readerPosition.f1);
    }

    @Override
    public boolean hasNext() {
        return this.currentSegmentReader != null && this.currentSegmentReader.hasNext();
    }

    @Override
    public T next() {
        try {
            T record = this.currentSegmentReader.next();
            ++this.currentSegmentCount;
            if (!this.currentSegmentReader.hasNext()) {
                this.currentSegmentReader.close();
                ++this.currentSegmentIndex;
                this.currentSegmentCount = 0;
                this.createSegmentReader(this.currentSegmentIndex, this.currentSegmentCount);
            }
            return record;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Tuple2<Integer, Integer> getPosition() {
        return new Tuple2((Object)this.currentSegmentIndex, (Object)this.currentSegmentCount);
    }

    private void createSegmentReader(int index, int startOffset) {
        try {
            if (index >= this.segments.size()) {
                this.currentSegmentReader = null;
                return;
            }
            Segment segment = this.segments.get(this.currentSegmentIndex);
            this.currentSegmentReader = !segment.getCache().isEmpty() ? new MemorySegmentReader<T>(this.serializer, segment, startOffset) : new FileSegmentReader<T>(this.serializer, segment, startOffset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

