/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.iteration.datacache.nonkeyed.FileSegmentWriter;
import org.apache.flink.iteration.datacache.nonkeyed.MemorySegmentReader;
import org.apache.flink.iteration.datacache.nonkeyed.MemorySegmentWriter;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentWriter;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class DataCacheWriter<T> {
    static final long MAX_SEGMENT_SIZE = 0x40000000L;
    private final TypeSerializer<T> serializer;
    private final FileSystem fileSystem;
    private final SupplierWithException<Path, IOException> pathGenerator;
    @Nullable
    private final MemorySegmentPool segmentPool;
    private final List<Segment> finishedSegments;
    @Nullable
    private SegmentWriter<T> currentSegmentWriter;

    public DataCacheWriter(TypeSerializer<T> serializer, FileSystem fileSystem, SupplierWithException<Path, IOException> pathGenerator) throws IOException {
        this(serializer, fileSystem, pathGenerator, null, Collections.emptyList());
    }

    public DataCacheWriter(TypeSerializer<T> serializer, FileSystem fileSystem, SupplierWithException<Path, IOException> pathGenerator, MemorySegmentPool segmentPool) throws IOException {
        this(serializer, fileSystem, pathGenerator, segmentPool, Collections.emptyList());
    }

    public DataCacheWriter(TypeSerializer<T> serializer, FileSystem fileSystem, SupplierWithException<Path, IOException> pathGenerator, List<Segment> priorFinishedSegments) throws IOException {
        this(serializer, fileSystem, pathGenerator, null, priorFinishedSegments);
    }

    public DataCacheWriter(TypeSerializer<T> serializer, FileSystem fileSystem, SupplierWithException<Path, IOException> pathGenerator, @Nullable MemorySegmentPool segmentPool, List<Segment> priorFinishedSegments) throws IOException {
        this.fileSystem = fileSystem;
        this.pathGenerator = pathGenerator;
        this.segmentPool = segmentPool;
        this.serializer = serializer;
        this.finishedSegments = new ArrayList<Segment>(priorFinishedSegments);
        this.currentSegmentWriter = this.createSegmentWriter();
    }

    public void addRecord(T record) throws IOException {
        if (!this.currentSegmentWriter.addRecord(record)) {
            this.currentSegmentWriter.finish().ifPresent(this.finishedSegments::add);
            this.currentSegmentWriter = new FileSegmentWriter<T>(this.serializer, (Path)this.pathGenerator.get());
            Preconditions.checkState((boolean)this.currentSegmentWriter.addRecord(record));
        }
    }

    public List<Segment> finish() throws IOException {
        if (this.currentSegmentWriter == null) {
            return this.finishedSegments;
        }
        this.currentSegmentWriter.finish().ifPresent(this.finishedSegments::add);
        this.currentSegmentWriter = null;
        return this.finishedSegments;
    }

    public List<Segment> getSegments() throws IOException {
        this.finishCurrentSegmentIfExists();
        return this.finishedSegments;
    }

    private void finishCurrentSegmentIfExists() throws IOException {
        if (this.currentSegmentWriter == null) {
            return;
        }
        this.currentSegmentWriter.finish().ifPresent(this.finishedSegments::add);
        this.currentSegmentWriter = this.createSegmentWriter();
    }

    public void clear() throws IOException {
        this.finishCurrentSegmentIfExists();
        for (Segment segment : this.finishedSegments) {
            if (segment.getFsSize() > 0L) {
                this.fileSystem.delete(segment.getPath(), false);
            }
            if (segment.getCache().isEmpty()) continue;
            this.segmentPool.returnAll(segment.getCache());
        }
        this.finishedSegments.clear();
    }

    public void writeSegmentsToFiles() throws IOException {
        this.finishCurrentSegmentIfExists();
        for (Segment segment : this.finishedSegments) {
            if (segment.getFsSize() > 0L) continue;
            MemorySegmentReader<T> reader = new MemorySegmentReader<T>(this.serializer, segment, 0);
            FileSegmentWriter writer = new FileSegmentWriter(this.serializer, segment.getPath());
            while (reader.hasNext()) {
                writer.addRecord(reader.next());
            }
            segment.setFsSize(writer.finish().get().getFsSize());
        }
    }

    private SegmentWriter<T> createSegmentWriter() throws IOException {
        if (this.segmentPool != null) {
            try {
                return new MemorySegmentWriter<T>(this.serializer, (Path)this.pathGenerator.get(), this.segmentPool, 0L);
            }
            catch (MemoryAllocationException memoryAllocationException) {
                // empty catch block
            }
        }
        return new FileSegmentWriter<T>(this.serializer, (Path)this.pathGenerator.get());
    }
}

