/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentWriter;

@Internal
class FileSegmentWriter<T>
implements SegmentWriter<T> {
    private final TypeSerializer<T> serializer;
    private final Path path;
    private final FSDataOutputStream outputStream;
    private final BufferedOutputStream bufferedOutputStream;
    private final DataOutputView outputView;
    private int count;

    FileSegmentWriter(TypeSerializer<T> serializer, Path path) throws IOException {
        this.serializer = serializer;
        this.path = path;
        this.outputStream = path.getFileSystem().create(path, FileSystem.WriteMode.NO_OVERWRITE);
        this.bufferedOutputStream = new BufferedOutputStream((OutputStream)this.outputStream);
        this.outputView = new DataOutputViewStreamWrapper((OutputStream)this.bufferedOutputStream);
    }

    @Override
    public boolean addRecord(T record) throws IOException {
        if (this.outputStream.getPos() >= 0x40000000L) {
            return false;
        }
        this.serializer.serialize(record, this.outputView);
        ++this.count;
        return true;
    }

    @Override
    public Optional<Segment> finish() throws IOException {
        this.bufferedOutputStream.flush();
        long size = this.outputStream.getPos();
        this.outputStream.close();
        if (this.count > 0) {
            Segment segment = new Segment(this.path, this.count, size);
            return Optional.of(segment);
        }
        this.path.getFileSystem().delete(this.path, false);
        return Optional.empty();
    }
}

