/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.HeadOperator;
import org.apache.flink.iteration.operator.coordinator.HeadOperatorCoordinator;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.OperatorEventHandler;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.util.Preconditions;

public class HeadOperatorFactory
extends AbstractStreamOperatorFactory<IterationRecord<?>>
implements OneInputStreamOperatorFactory<IterationRecord<?>, IterationRecord<?>>,
CoordinatedOperatorFactory<IterationRecord<?>>,
YieldingOperatorFactory<IterationRecord<?>> {
    private final IterationID iterationId;
    private final int feedbackIndex;
    private final boolean isCriteriaStream;
    private final int totalInitialVariableParallelism;
    private int criteriaStreamParallelism;

    public HeadOperatorFactory(IterationID iterationId, int feedbackIndex, boolean isCriteriaStream, int totalInitialVariableParallelism) {
        this.iterationId = iterationId;
        this.feedbackIndex = feedbackIndex;
        this.isCriteriaStream = isCriteriaStream;
        Preconditions.checkArgument((totalInitialVariableParallelism > 0 ? 1 : 0) != 0, (Object)"totalInitialVariableParallelism should be positive");
        this.totalInitialVariableParallelism = totalInitialVariableParallelism;
    }

    public void setCriteriaStreamParallelism(int criteriaStreamParallelism) {
        Preconditions.checkArgument((criteriaStreamParallelism > 0 ? 1 : 0) != 0, (Object)"totalInitialVariableParallelism should be positive");
        this.criteriaStreamParallelism = criteriaStreamParallelism;
    }

    public <T extends StreamOperator<IterationRecord<?>>> T createStreamOperator(StreamOperatorParameters<IterationRecord<?>> streamOperatorParameters) {
        MailboxExecutor mailboxExecutor = streamOperatorParameters.getContainingTask().getMailboxExecutorFactory().createExecutor(-1);
        HeadOperator headOperator = new HeadOperator(this.iterationId, this.feedbackIndex, this.isCriteriaStream, mailboxExecutor, this.createOperatorEventGateway(streamOperatorParameters), streamOperatorParameters.getProcessingTimeService());
        headOperator.setup(streamOperatorParameters.getContainingTask(), streamOperatorParameters.getStreamConfig(), streamOperatorParameters.getOutput());
        streamOperatorParameters.getOperatorEventDispatcher().registerEventHandler(streamOperatorParameters.getStreamConfig().getOperatorID(), (OperatorEventHandler)headOperator);
        return (T)((Object)headOperator);
    }

    public OperatorCoordinator.Provider getCoordinatorProvider(String s, OperatorID operatorID) {
        return new HeadOperatorCoordinator.HeadOperatorCoordinatorProvider(operatorID, this.iterationId, this.totalInitialVariableParallelism + this.criteriaStreamParallelism);
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return HeadOperator.class;
    }

    @VisibleForTesting
    OperatorEventGateway createOperatorEventGateway(StreamOperatorParameters<IterationRecord<?>> streamOperatorParameters) {
        return streamOperatorParameters.getOperatorEventDispatcher().getOperatorEventGateway(streamOperatorParameters.getStreamConfig().getOperatorID());
    }

    public void setMailboxExecutor(MailboxExecutor mailboxExecutor) {
    }

    public ChainingStrategy getChainingStrategy() {
        return ChainingStrategy.HEAD;
    }
}

