/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.allround;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.allround.AbstractAllRoundWrapperOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;

public class MultipleInputAllRoundWrapperOperator<OUT>
extends AbstractAllRoundWrapperOperator<OUT, MultipleInputStreamOperator<OUT>>
implements MultipleInputStreamOperator<IterationRecord<OUT>>,
BoundedMultiInput {
    public MultipleInputAllRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
    }

    private <IN> void processElement(int inputIndex, Input<IN> input, StreamRecord<IN> reusedInput, StreamRecord<IterationRecord<IN>> element) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                input.processElement(reusedInput);
                this.clearIterationContextRound();
                break;
            }
            case EPOCH_WATERMARK: {
                this.onEpochWatermarkEvent(inputIndex, (IterationRecord)element.getValue());
                break;
            }
            default: {
                throw new FlinkRuntimeException("Not supported iteration record type: " + element);
            }
        }
    }

    public List<Input> getInputs() {
        ArrayList<Input> proxyInputs = new ArrayList<Input>();
        for (int i = 0; i < ((MultipleInputStreamOperator)this.wrappedOperator).getInputs().size(); ++i) {
            proxyInputs.add(new ProxyInput(i));
        }
        return proxyInputs;
    }

    @Override
    public void endInput(int i) throws Exception {
        super.endInput(i);
        if (this.wrappedOperator instanceof BoundedMultiInput) {
            ((BoundedMultiInput)this.wrappedOperator).endInput(i);
        }
    }

    private class ProxyInput<IN>
    implements Input<IterationRecord<IN>> {
        private final int inputIndex;
        private final StreamRecord<IN> reusedInput;
        private final Input<IN> input;

        public ProxyInput(int inputIndex) {
            this.inputIndex = inputIndex;
            this.reusedInput = new StreamRecord(null, 0L);
            this.input = (Input)((MultipleInputStreamOperator)MultipleInputAllRoundWrapperOperator.this.wrappedOperator).getInputs().get(inputIndex);
        }

        public void processElement(StreamRecord<IterationRecord<IN>> element) throws Exception {
            MultipleInputAllRoundWrapperOperator.this.processElement(this.inputIndex, this.input, this.reusedInput, element);
        }

        public void processWatermark(Watermark mark) throws Exception {
            this.input.processWatermark(mark);
        }

        public void processWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
            this.input.processWatermarkStatus(watermarkStatus);
        }

        public void processLatencyMarker(LatencyMarker latencyMarker) throws Exception {
            this.input.processLatencyMarker(latencyMarker);
        }

        public void setKeyContextElement(StreamRecord<IterationRecord<IN>> record) throws Exception {
            this.reusedInput.replace((Object)((IterationRecord)record.getValue()), record.getTimestamp());
            this.input.setKeyContextElement(this.reusedInput);
        }
    }
}

