/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.headprocessor;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.event.GloballyAlignedEvent;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorRecordProcessor;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorState;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.FlinkRuntimeException;

public class TerminatingHeadOperatorRecordProcessor
implements HeadOperatorRecordProcessor {
    private HeadOperatorRecordProcessor.Context headOperatorContext;

    public TerminatingHeadOperatorRecordProcessor(HeadOperatorRecordProcessor.Context headOperatorContext) {
        this.headOperatorContext = headOperatorContext;
    }

    @Override
    public void initializeState(HeadOperatorState headOperatorState, Iterable<StatePartitionStreamProvider> rawStates) {
        this.headOperatorContext.notifyTerminatingOnInitialize();
    }

    @Override
    public void processElement(StreamRecord<IterationRecord<?>> record) {
        throw new FlinkRuntimeException("It is not possible to receive the element from normal input during terminating.");
    }

    @Override
    public boolean processFeedbackElement(StreamRecord<IterationRecord<?>> record) {
        if (((IterationRecord)record.getValue()).getType() == IterationRecord.Type.EPOCH_WATERMARK) {
            return ((IterationRecord)record.getValue()).getEpoch() == Integer.MIN_VALUE;
        }
        return false;
    }

    @Override
    public boolean onGloballyAligned(GloballyAlignedEvent globallyAlignedEvent) {
        throw new FlinkRuntimeException("It is not possible to receive the globally aligned event from normal input during terminating.");
    }

    @Override
    public HeadOperatorState snapshotState() {
        return HeadOperatorState.FINISHED_STATE;
    }
}

