/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast.typeinfo;

public class CacheElement<T> {
    private T record;
    private long watermark;
    private Type type;

    public CacheElement(T record, long watermark, Type type) {
        this.record = record;
        this.watermark = watermark;
        this.type = type;
    }

    public static <T> CacheElement<T> newRecord(T record) {
        return new CacheElement<T>(record, -1L, Type.RECORD);
    }

    public static <T> CacheElement<T> newWatermark(long watermark) {
        return new CacheElement<Object>(null, watermark, Type.WATERMARK);
    }

    public T getRecord() {
        return this.record;
    }

    public void setRecord(T record) {
        this.record = record;
    }

    public long getWatermark() {
        return this.watermark;
    }

    public void setWatermark(long watermark) {
        this.watermark = watermark;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        RECORD,
        WATERMARK;

    }
}

