/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.iteration;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.iteration.IterationListener;
import org.apache.flink.util.Collector;

public class ForwardInputsOfLastRound<T>
implements FlatMapFunction<T, T>,
IterationListener<T> {
    private List<T> valuesInLastEpoch = new ArrayList<T>();
    private List<T> valuesInCurrentEpoch = new ArrayList<T>();

    public void flatMap(T value, Collector<T> out) {
        this.valuesInCurrentEpoch.add(value);
    }

    @Override
    public void onEpochWatermarkIncremented(int epochWatermark, IterationListener.Context context, Collector<T> out) {
        this.valuesInLastEpoch = this.valuesInCurrentEpoch;
        this.valuesInCurrentEpoch = new ArrayList<T>();
    }

    @Override
    public void onIterationTerminated(IterationListener.Context context, Collector<T> out) {
        for (T value : this.valuesInLastEpoch) {
            out.collect(value);
        }
        if (!this.valuesInCurrentEpoch.isEmpty()) {
            throw new IllegalStateException("flatMap() is invoked since the last onEpochWatermarkIncremented callback");
        }
        this.valuesInLastEpoch.clear();
    }
}

