/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.lossfunc;

import org.apache.flink.annotation.Internal;
import org.apache.flink.ml.common.feature.LabeledPointWithWeight;
import org.apache.flink.ml.common.lossfunc.LossFunc;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;

@Internal
public class HingeLoss
implements LossFunc {
    public static final HingeLoss INSTANCE = new HingeLoss();

    private HingeLoss() {
    }

    @Override
    public double computeLoss(LabeledPointWithWeight dataPoint, DenseVector coefficient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        double labelScaled = 2.0 * dataPoint.getLabel() - 1.0;
        return dataPoint.getWeight() * Math.max(0.0, 1.0 - labelScaled * dot);
    }

    @Override
    public void computeGradient(LabeledPointWithWeight dataPoint, DenseVector coefficient, DenseVector cumGradient) {
        double dot = BLAS.dot((Vector)dataPoint.getFeatures(), (Vector)coefficient);
        double labelScaled = 2.0 * dataPoint.getLabel() - 1.0;
        if (1.0 - labelScaled * dot > 0.0) {
            BLAS.axpy(-labelScaled * dataPoint.getWeight(), (Vector)dataPoint.getFeatures(), cumGradient, dataPoint.getFeatures().size());
        }
    }
}

