/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.countvectorizer;

import org.apache.flink.ml.common.param.HasInputCol;
import org.apache.flink.ml.common.param.HasOutputCol;
import org.apache.flink.ml.param.BooleanParam;
import org.apache.flink.ml.param.DoubleParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;

public interface CountVectorizerModelParams<T>
extends HasInputCol<T>,
HasOutputCol<T> {
    public static final Param<Double> MIN_TF = new DoubleParam("minTF", "Filter to ignore rare words in a document. For each document,terms with frequency/count less than the given threshold are ignored. If this is an integer >= 1, then this specifies a count (of times the term must appear in the document); if this is a double in [0,1), then this specifies a fraction (out of the document's token count).", 1.0, ParamValidators.gtEq(0.0));
    public static final Param<Boolean> BINARY = new BooleanParam("binary", "Binary toggle to control the output vector values. If True, all nonzero counts (after minTF filter applied) are set to 1.0.", false);

    default public double getMinTF() {
        return this.get(MIN_TF);
    }

    default public T setMinTF(double value) {
        return this.set(MIN_TF, value);
    }

    default public boolean getBinary() {
        return this.get(BINARY);
    }

    default public T setBinary(boolean value) {
        return this.set(BINARY, value);
    }
}

