/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.param.ParamValidator;

@PublicEvolving
public class Param<T>
implements Serializable {
    private static final long serialVersionUID = 4396556083935765299L;
    public final String name;
    public final Class<T> clazz;
    public final String description;
    public final T defaultValue;
    public final ParamValidator<T> validator;

    public Param(String name, Class<T> clazz, String description, T defaultValue, ParamValidator<T> validator) {
        this.name = name;
        this.clazz = clazz;
        this.description = description;
        this.defaultValue = defaultValue;
        this.validator = validator;
        if (defaultValue != null && !validator.validate(defaultValue)) {
            throw new IllegalArgumentException("Parameter " + name + " is given an invalid value " + defaultValue);
        }
    }

    public Object jsonEncode(T value) throws IOException {
        return value;
    }

    public T jsonDecode(Object json) throws IOException {
        return (T)json;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Param)) {
            return false;
        }
        return ((Param)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

