/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.servable.api.TransformerServable;
import org.apache.flink.ml.util.FileUtils;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class ServableReadWriteUtils {
    public static List<TransformerServable<?>> loadPipeline(String path) throws IOException {
        Map<String, ?> metadata = FileUtils.loadMetadata(path, "");
        int numStages = (Integer)metadata.get("numStages");
        ArrayList servables = new ArrayList(numStages);
        for (int i = 0; i < numStages; ++i) {
            String stagePath = FileUtils.getPathForPipelineStage(i, numStages, path);
            servables.add(ServableReadWriteUtils.loadServable(stagePath));
        }
        return servables;
    }

    private static TransformerServable<?> loadServable(String path) throws IOException {
        Map<String, ?> metadata = FileUtils.loadMetadata(path, "");
        String className = (String)metadata.get("className");
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("loadServable", String.class);
            method.setAccessible(true);
            return (TransformerServable)method.invoke(null, path);
        }
        catch (NoSuchMethodException e) {
            String methodName = String.format("%s::loadServable(String)", className);
            throw new RuntimeException("Failed to load servable because the static method " + methodName + " is not implemented.", e);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load servable.", e);
        }
    }

    public static <T extends TransformerServable<T>> T loadServableParam(String path, Class<T> clazz) throws IOException {
        TransformerServable instance = (TransformerServable)InstantiationUtil.instantiate(clazz);
        HashMap nameToParam = new HashMap();
        for (Param<?> param : ParamUtils.getPublicFinalParamFields(instance)) {
            nameToParam.put(param.name, param);
        }
        Map<String, ?> jsonMap = FileUtils.loadMetadata(path, "");
        if (jsonMap.containsKey("paramMap")) {
            Map paramMap = (Map)jsonMap.get("paramMap");
            for (Map.Entry entry : paramMap.entrySet()) {
                Param param = (Param)nameToParam.get(entry.getKey());
                ParamUtils.setParam(instance, param, param.jsonDecode(entry.getValue()));
            }
        }
        return (T)instance;
    }

    public static InputStream loadModelData(String path) throws IOException {
        Path modelDataPath = FileUtils.getDataPath(path);
        FileSystem fileSystem = modelDataPath.getFileSystem();
        FileStatus[] files = fileSystem.listStatus(modelDataPath);
        Preconditions.checkState((files.length == 1 ? 1 : 0) != 0, (String)"Only one model data file is expected in the directory %s.", (Object[])new Object[]{path});
        return fileSystem.open(files[0].getPath());
    }
}

