/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.message;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufSerializer;
import org.apache.flink.statefun.flink.core.generated.Checkpoint;
import org.apache.flink.statefun.flink.core.generated.Envelope;
import org.apache.flink.statefun.flink.core.generated.Payload;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializer;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializerKryo;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializerPb;
import org.apache.flink.statefun.flink.core.message.MessagePayloadSerializerRaw;
import org.apache.flink.statefun.flink.core.message.ProtobufMessage;
import org.apache.flink.statefun.flink.core.message.SdkMessage;
import org.apache.flink.statefun.sdk.Address;

public final class MessageFactory {
    private final ProtobufSerializer<Envelope> envelopeSerializer = ProtobufSerializer.forMessageGeneratedClass(Envelope.class);
    private final MessagePayloadSerializer userMessagePayloadSerializer;

    public static MessageFactory forKey(MessageFactoryKey key) {
        return new MessageFactory(MessageFactory.forPayloadKey(key));
    }

    private MessageFactory(MessagePayloadSerializer userMessagePayloadSerializer) {
        this.userMessagePayloadSerializer = Objects.requireNonNull(userMessagePayloadSerializer);
    }

    public Message from(long checkpointId) {
        return this.from(MessageFactory.envelopeWithCheckpointId(checkpointId));
    }

    public Message from(DataInputView input) throws IOException {
        return this.from(this.deserializeEnvelope(input));
    }

    public Message from(Address from, Address to, Object payload) {
        return new SdkMessage(from, to, payload);
    }

    public Message from(Address from, Address to, Object payload, String cancellationToken) {
        return new SdkMessage(from, to, payload, cancellationToken);
    }

    void copy(DataInputView source, DataOutputView target) throws IOException {
        this.copyEnvelope(source, target);
    }

    private Message from(Envelope envelope) {
        return new ProtobufMessage(envelope);
    }

    Payload serializeUserMessagePayload(Object payloadObject) {
        return this.userMessagePayloadSerializer.serialize(payloadObject);
    }

    Object deserializeUserMessagePayload(ClassLoader targetClassLoader, Payload payload) {
        return this.userMessagePayloadSerializer.deserialize(targetClassLoader, payload);
    }

    Object copyUserMessagePayload(ClassLoader targetClassLoader, Object payload) {
        return this.userMessagePayloadSerializer.copy(targetClassLoader, payload);
    }

    void serializeEnvelope(Envelope envelope, DataOutputView target) throws IOException {
        this.envelopeSerializer.serialize((com.google.protobuf.Message)envelope, target);
    }

    private Envelope deserializeEnvelope(DataInputView source) throws IOException {
        return (Envelope)this.envelopeSerializer.deserialize(source);
    }

    private void copyEnvelope(DataInputView source, DataOutputView target) throws IOException {
        this.envelopeSerializer.copy(source, target);
    }

    private static Envelope envelopeWithCheckpointId(long checkpointId) {
        Checkpoint checkpoint = Checkpoint.newBuilder().setCheckpointId(checkpointId).build();
        return Envelope.newBuilder().setCheckpoint(checkpoint).build();
    }

    private static MessagePayloadSerializer forPayloadKey(MessageFactoryKey key) {
        switch (key.getType()) {
            case WITH_KRYO_PAYLOADS: {
                return new MessagePayloadSerializerKryo();
            }
            case WITH_PROTOBUF_PAYLOADS: {
                return new MessagePayloadSerializerPb();
            }
            case WITH_RAW_PAYLOADS: {
                return new MessagePayloadSerializerRaw();
            }
            case WITH_CUSTOM_PAYLOADS: {
                String className = key.getCustomPayloadSerializerClassName().orElseThrow(() -> new UnsupportedOperationException("WITH_CUSTOM_PAYLOADS requires custom payload serializer class name to be specified in MessageFactoryKey"));
                return MessageFactory.forCustomPayloadSerializer(className);
            }
        }
        throw new IllegalArgumentException("unknown serialization method " + (Object)((Object)key.getType()));
    }

    private static MessagePayloadSerializer forCustomPayloadSerializer(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (MessagePayloadSerializer)constructor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new UnsupportedOperationException(String.format("Failed to create custom payload serializer: %s", className), ex);
        }
    }
}

