/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufOutputStream;
import org.apache.flink.util.Preconditions;

final class NettyProtobuf {
    NettyProtobuf() {
    }

    public static <M extends Message> ByteBuf serializeProtobuf(IntFunction<ByteBuf> allocator, M message) {
        int requiredSize = message.getSerializedSize();
        ByteBuf buf = allocator.apply(requiredSize);
        try {
            if (buf.nioBufferCount() == 1) {
                NettyProtobuf.zeroCopySerialize(message, requiredSize, buf);
            } else {
                NettyProtobuf.serializeOutputStream(message, buf);
            }
            return buf;
        }
        catch (IOException e) {
            buf.release();
            throw new UncheckedIOException(e);
        }
    }

    public static <M extends Message> M deserializeProtobuf(ByteBuf buf, Parser<M> parser) {
        try {
            if (buf.nioBufferCount() == 1) {
                return NettyProtobuf.zeroCopyDeserialize(buf, parser);
            }
            return NettyProtobuf.deserializeInputStream(buf, parser);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <M extends Message> void zeroCopySerialize(M message, int len, ByteBuf buf) throws IOException {
        Preconditions.checkState((len <= buf.writableBytes() ? 1 : 0) != 0);
        int originalWriterIndex = buf.writerIndex();
        ByteBuffer nioBuf = buf.nioBuffer(originalWriterIndex, len);
        CodedOutputStream out = CodedOutputStream.newInstance((ByteBuffer)nioBuf);
        message.writeTo(out);
        out.flush();
        buf.writerIndex(originalWriterIndex + len);
    }

    private static <M extends Message> void serializeOutputStream(M message, ByteBuf buf) throws IOException {
        message.writeTo((OutputStream)new ByteBufOutputStream(buf));
    }

    private static <M extends Message> M zeroCopyDeserialize(ByteBuf buf, Parser<M> parser) throws InvalidProtocolBufferException {
        int messageLength = buf.readableBytes();
        int originalReaderIndex = buf.readerIndex();
        ByteBuffer nioBuffer = buf.nioBuffer(originalReaderIndex, messageLength);
        CodedInputStream in = CodedInputStream.newInstance((ByteBuffer)nioBuffer);
        Message message = (Message)parser.parseFrom(in);
        buf.readerIndex(originalReaderIndex + messageLength);
        return (M)message;
    }

    private static <M extends Message> M deserializeInputStream(ByteBuf buf, Parser<M> parser) throws InvalidProtocolBufferException {
        return (M)((Message)parser.parseFrom((InputStream)new ByteBufInputStream(buf)));
    }
}

