/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.common.Maps;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.translation.IngressRouterOperator;
import org.apache.flink.statefun.sdk.io.IngressIdentifier;
import org.apache.flink.streaming.api.datastream.DataStream;

final class RouterTranslator {
    private final StatefulFunctionsUniverse universe;
    private final StatefulFunctionsConfig configuration;

    RouterTranslator(StatefulFunctionsUniverse universe, StatefulFunctionsConfig configuration) {
        this.universe = universe;
        this.configuration = configuration;
    }

    Map<IngressIdentifier<?>, DataStream<Message>> translate(Map<IngressIdentifier<?>, DataStream<?>> sources) {
        return Maps.transformValues(this.universe.routers(), (id, unused) -> this.createRoutersForSource((IngressIdentifier<?>)id, (DataStream<?>)((DataStream)sources.get(id))));
    }

    private DataStream<Message> createRoutersForSource(IngressIdentifier<?> id, DataStream<?> sourceStream) {
        IngressIdentifier<?> castedId = id;
        DataStream<?> castedSource = sourceStream;
        IngressRouterOperator router = new IngressRouterOperator(this.configuration, castedId);
        TypeInformation<Message> typeInfo = this.universe.types().registerType(Message.class);
        int sourceParallelism = castedSource.getParallelism();
        String operatorName = "router (" + castedId.name() + ")";
        return castedSource.transform(operatorName, typeInfo, router).setParallelism(sourceParallelism).uid(this.routerUID(id)).returns(typeInfo);
    }

    private String routerUID(IngressIdentifier<?> identifier) {
        return String.format("%s-%s-router", identifier.namespace(), identifier.name());
    }
}

